/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop;

import org.jagatoo.util.timing.TimerInterface;
import org.xith3d.loop.FPSLimiter;

public class DefaultFPSLimiter
implements FPSLimiter {
    private static final long ONE_MIO = 1000000L;
    private static final long HALF_MIO = 500000L;
    private long accumulator = 0L;
    private static DefaultFPSLimiter instance = null;

    public static final DefaultFPSLimiter getInstance() {
        if (instance == null) {
            instance = new DefaultFPSLimiter();
        }
        return instance;
    }

    public long limitFPS(long frameIdx, long frameTime, long minFrameTime, TimerInterface timer) {
        this.accumulator += minFrameTime - frameTime;
        if (this.accumulator <= 0L) {
            Thread.yield();
            return 0L;
        }
        long waitMillis = this.accumulator / 1000000L;
        this.accumulator -= waitMillis * 1000000L;
        if (this.accumulator >= 500000L) {
            this.accumulator -= 1000000L;
            ++waitMillis;
        }
        long t1 = timer.getNanoseconds();
        try {
            Thread.sleep(waitMillis);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long sleptTime = timer.getNanoseconds() - t1;
        this.accumulator -= sleptTime - waitMillis * 1000000L;
        return sleptTime;
    }
}

