/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop;

import org.xith3d.loop.ConsciousFPSListener;
import org.xith3d.loop.RenderLoop;

public abstract class TitleFPSListener
implements ConsciousFPSListener {
    private String baseTitle;
    private RenderLoop renderLoop;

    public final void setBaseTitle(String baseTitle) {
        this.baseTitle = baseTitle;
    }

    public final String getBaseTitle() {
        return this.baseTitle;
    }

    protected abstract void onDetachedFromRenderLoop();

    public final void setRenderLoop(RenderLoop renderLoop) {
        boolean detached = this.renderLoop != null && renderLoop == null;
        this.renderLoop = renderLoop;
        if (detached) {
            this.onDetachedFromRenderLoop();
        }
    }

    public final RenderLoop getRenderLoop() {
        return this.renderLoop;
    }

    protected boolean isLimited() {
        return this.renderLoop != null && this.renderLoop.getMinIterationTime() != 0L;
    }

    protected String getLimitedString() {
        return " (limited)";
    }

    protected String getDynamicTitlePart(float fps, boolean limited) {
        if (limited) {
            return ", FPS: " + (int)fps + this.getLimitedString();
        }
        return ", FPS: " + (int)fps;
    }

    protected abstract void setTitle(String var1);

    public void onFPSCountIntervalHit(float fps) {
        this.setTitle(this.getBaseTitle() + this.getDynamicTitlePart(fps, this.isLimited()));
    }

    public TitleFPSListener(String baseTitle) {
        this.baseTitle = baseTitle;
    }
}

