/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision;

import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollisionPool;

public class Collision {
    private static final CollisionPool POOL = new CollisionPool(128);
    private Collideable c1;
    private Collideable c2;
    private Point3f pos;
    private Vector3f normal;
    private float depth;
    private final Vector3f outNormal = new Vector3f();

    public final Collideable getCollideable1() {
        return this.c1;
    }

    public final Collideable getCollideable2() {
        return this.c2;
    }

    public final Point3f getPosition() {
        return this.pos;
    }

    public final Vector3f getNormal() {
        return this.normal;
    }

    public final Vector3f getScaledNormal() {
        this.outNormal.scale(this.depth, this.normal);
        return this.outNormal;
    }

    public final Vector3f getInvertedNormal() {
        this.outNormal.negate(this.normal);
        return this.outNormal;
    }

    public final Vector3f getScaledInvertedNormal() {
        this.outNormal.scale(-this.depth, this.normal);
        return this.outNormal;
    }

    public final float getDepth() {
        return this.depth;
    }

    public String toString() {
        return "Collision between a " + this.c1.getType() + " and a " + this.c2.getType() + " at position " + this.pos + " with normal " + this.normal + " and depth " + this.depth;
    }

    protected final void set(Point3f pos, Vector3f normal, float depth, Collideable c1, Collideable c2) {
        if (pos != null) {
            this.pos = pos;
        }
        if (normal != null) {
            this.normal = normal;
        }
        this.depth = depth;
        this.c1 = c1;
        this.c2 = c2;
    }

    public Collision(Point3f pos, Vector3f normal, float depth, Collideable c1, Collideable c2) {
        this.pos = pos;
        this.normal = normal;
        this.depth = depth;
        this.c1 = c1;
        this.c2 = c2;
    }

    protected Collision() {
        this.pos = new Point3f();
        this.normal = new Vector3f();
        this.depth = 0.0f;
        this.c1 = null;
        this.c2 = null;
    }

    public static final Collision fromPool(Point3f pos, Vector3f normal, float depth, Collideable c1, Collideable c2) {
        return POOL.alloc(pos, normal, depth, c1, c2);
    }

    public static final Collision fromPool() {
        return POOL.alloc();
    }

    public static final void toPool(Collision collision) {
        POOL.free(collision);
    }
}

