/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.joode;

import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Plane;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.collideable.PlaneCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCollisionEngine;
import org.xith3d.physics.joode.Convert;

public class JoodePlaneCollideable
extends PlaneCollideable
implements JoodeCollideable {
    public static final Vector3 tmpNormal = new Vector3();
    public static final Vector3 tmpPoint = new Vector3();
    private final Plane joodeGeom;
    private Matrix3 rotMatrix3 = null;

    public JoodePlaneCollideable(JoodeCollisionEngine eng, Vector3f normal, Point3f point) {
        super((CollisionEngine)eng, normal, point);
        this.joodeGeom = new Plane(null, JoodePlaneCollideable.getTmpNormal(normal), JoodePlaneCollideable.getTmpPoint(point));
        this.init(eng, this.joodeGeom);
    }

    public JoodePlaneCollideable(JoodeCollisionEngine eng, Vector3f normal, float d) {
        super((CollisionEngine)eng, normal, d);
        this.joodeGeom = new Plane(null, JoodePlaneCollideable.getTmpNormal(normal), d);
        this.init(eng, this.joodeGeom);
    }

    public JoodePlaneCollideable(JoodeCollisionEngine eng, float a, float b, float c, float d) {
        super(eng, a, b, c, d);
        this.joodeGeom = new Plane(null, a, b, c, d);
        this.init(eng, this.joodeGeom);
    }

    private static final Vector3 getTmpNormal(Tuple3f normal) {
        tmpNormal.set(normal.getX(), normal.getY(), normal.getZ());
        return tmpNormal;
    }

    private static final Vector3 getTmpPoint(Tuple3f point) {
        tmpPoint.set(point.getX(), point.getY(), point.getZ());
        return tmpPoint;
    }

    public void setNormal(Vector3f normal) {
        super.setNormal(normal);
        throw new Error("Setting normal of plane (PlaneCollideable.setNormal()) not yet implemented with JOODE backend");
    }

    public void setD(float d) {
        super.setD(d);
        throw new Error("Setting point of plane (PlaneCollideable.setNormal()) not yet implemented with JOODE backend");
    }

    private final void init(JoodeCollisionEngine engine, Geom geom) {
        boolean cfr_ignored_0 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setPosition(Convert.toJOODE(this.getWorldPos()));
        }
        boolean cfr_ignored_1 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setRotation(Convert.toJOODE(this.getWorldRotMat()));
        }
        geom.setUserData(this);
    }

    public void finalize() {
        this.joodeGeom.setUserData(null);
    }

    public JoodeCollisionEngine getEngine() {
        return (JoodeCollisionEngine)super.getEngine();
    }

    public final Plane getJOODEGeom() {
        return this.joodeGeom;
    }

    public void setParent(CollideableGroup parent) {
        super.setParent(parent);
    }

    public final void setEnabled(boolean enabled) {
        this.getJOODEGeom().setEnabled(enabled);
    }

    public final boolean isEnabled() {
        return this.getJOODEGeom().isEnabled();
    }

    protected void applyWorldRotation(Matrix3f worldRot) {
        if (this.rotMatrix3 == null) {
            this.rotMatrix3 = new Matrix3();
        }
        Convert.toJOODE(worldRot, this.rotMatrix3);
        this.joodeGeom.setRotation(this.rotMatrix3);
    }

    protected void applyWorldPosition(Tuple3f worldPos) {
        this.joodeGeom.setPosition(worldPos.getX(), worldPos.getY(), worldPos.getZ());
    }
}

