/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.joode;

import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Vector3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.simulation.JointLimitMotor;

public final class Convert {
    public static final Vector3f toXith(Vector3 vec) {
        return new Vector3f(vec.getX(), vec.getY(), vec.getZ());
    }

    public static final Point3f toXithPoint(Vector3 vec) {
        return new Point3f(vec.getX(), vec.getY(), vec.getZ());
    }

    public static final Tuple3f toXith(Vector3 vec, Tuple3f tupf) {
        tupf.set(vec.getX(), vec.getY(), vec.getZ());
        return tupf;
    }

    public static final Vector3 toJOODE(Tuple3f vecf) {
        return new Vector3(vecf.getX(), vecf.getY(), vecf.getZ());
    }

    public static final Vector3 toJOODE(Tuple3f vecf, Vector3 vec) {
        vec.set(vecf.getX(), vecf.getY(), vecf.getZ());
        return vec;
    }

    public static final Quaternion4f toXith(Quaternion quat) {
        return Convert.toXith(quat, new Quaternion4f());
    }

    public static final Quaternion4f toXith(Quaternion quat, Quaternion4f quatf) {
        quatf.set(quat.m[0], quat.m[1], quat.m[2], quat.m[2]);
        return quatf;
    }

    public static final Quaternion toJOODE(Quaternion4f quatf) {
        return new Quaternion(quatf.getA(), quatf.getB(), quatf.getC(), quatf.getD());
    }

    public static final Quaternion toJOODE(Quaternion4f quatf, Quaternion quat) {
        quat.set(quatf.getA(), quatf.getB(), quatf.getD(), quatf.getD());
        return quat;
    }

    public static final Matrix3 toJOODE(Matrix3f rotf) {
        Matrix3 mat = new Matrix3();
        mat.set(0, 0, rotf.m00());
        mat.set(1, 0, rotf.m01());
        mat.set(2, 0, rotf.m02());
        mat.set(0, 1, rotf.m10());
        mat.set(1, 1, rotf.m11());
        mat.set(2, 1, rotf.m12());
        mat.set(0, 2, rotf.m20());
        mat.set(1, 2, rotf.m21());
        mat.set(2, 2, rotf.m22());
        return mat;
    }

    public static final Matrix3 toJOODE(Matrix3f rotf, Matrix3 rot) {
        rot.set(0, 0, rotf.m00());
        rot.set(1, 0, rotf.m01());
        rot.set(2, 0, rotf.m02());
        rot.set(0, 1, rotf.m10());
        rot.set(1, 1, rotf.m11());
        rot.set(2, 1, rotf.m12());
        rot.set(0, 2, rotf.m20());
        rot.set(1, 2, rotf.m21());
        rot.set(2, 2, rotf.m22());
        return rot;
    }

    public static final Matrix3f toXith(Matrix3 rot) {
        Matrix3f rotf = new Matrix3f();
        rotf.set(0, 0, rot.get(0, 0));
        rotf.set(1, 0, rot.get(0, 1));
        rotf.set(2, 0, rot.get(0, 2));
        rotf.set(0, 1, rot.get(1, 0));
        rotf.set(1, 1, rot.get(1, 1));
        rotf.set(2, 1, rot.get(1, 2));
        rotf.set(0, 2, rot.get(2, 0));
        rotf.set(1, 2, rot.get(2, 1));
        rotf.set(2, 2, rot.get(2, 2));
        return rotf;
    }

    public static final Matrix3f toXith(Matrix3 rot, Matrix3f rotf) {
        rotf.set(0, 0, rot.get(0, 0));
        rotf.set(1, 0, rot.get(0, 1));
        rotf.set(2, 0, rot.get(0, 2));
        rotf.set(0, 1, rot.get(1, 0));
        rotf.set(1, 1, rot.get(1, 1));
        rotf.set(2, 1, rot.get(1, 2));
        rotf.set(0, 2, rot.get(2, 0));
        rotf.set(1, 2, rot.get(2, 1));
        rotf.set(2, 2, rot.get(2, 2));
        return rotf;
    }

    public static final Vector3[] toJOODE(Tuple3f[] vecfs) {
        Vector3[] vecs = new Vector3[vecfs.length];
        int i = 0;
        while (i < vecs.length) {
            vecs[i] = Convert.toJOODE(vecfs[i]);
            ++i;
        }
        return vecs;
    }

    public static final void toJOODE(JointLimitMotor xithMotor, net.java.dev.joode.joint.JointLimitMotor joodeMotor) {
        joodeMotor.setVelocity(xithMotor.getVelocity());
        joodeMotor.setMaxForce(xithMotor.getMaxForce());
        joodeMotor.setLowStop(xithMotor.getLowStop());
        joodeMotor.setHighStop(xithMotor.getHighStop());
        joodeMotor.setFudgeFactor(xithMotor.getFudgeFactor());
        joodeMotor.setNormalCFM(xithMotor.getNormalCFM());
        joodeMotor.setStopERP(xithMotor.getStopERP());
        joodeMotor.setStopCFM(xithMotor.getStopCFM());
        joodeMotor.setBounce(xithMotor.getBounce());
        joodeMotor.setLimit(xithMotor.getLimit());
        joodeMotor.setLimitError(xithMotor.getLimitError());
    }
}

