/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.collision.CollisionResolversManager;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.physics.simulation.SurfaceParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimulationEngine
implements Updatable,
Enableable {
    protected final ArrayList<SimulationWorld> worlds = new ArrayList(1);
    private CollisionResolversManager collisionResolversManager = null;
    private long stepMicros = 5000L;
    private long maxStepMicros = 2000000L;
    private boolean enabled = true;

    public final ArrayList<SimulationWorld> getWorlds() {
        return this.worlds;
    }

    public abstract SimulationWorld newWorldImpl();

    public final SimulationWorld newWorld() {
        SimulationWorld world = this.newWorldImpl();
        this.worlds.add(world);
        return world;
    }

    public abstract SurfaceParameters newSurfaceParameters(String[] var1, Object[] var2);

    public final SurfaceParameters newSurfaceParameters() {
        return this.newSurfaceParameters(null, null);
    }

    public void destroyWorld(SimulationWorld world) {
        this.worlds.remove(world);
    }

    public final void setStepSize(long micros) {
        if (micros < 1L) {
            throw new IllegalArgumentException("micros must be greater then 0");
        }
        this.stepMicros = micros;
    }

    public final long getStepSize() {
        return this.stepMicros;
    }

    public final void setMaxStepSize(long micros) {
        if (micros < 1L) {
            throw new IllegalArgumentException("micros must be greater then 0");
        }
        this.maxStepMicros = micros;
    }

    public final long getMaxStepSize() {
        return this.maxStepMicros;
    }

    public final void step(long stepMicros) {
        for (int i = 0; i < this.worlds.size(); ++i) {
            this.worlds.get(i).step(stepMicros, this.collisionResolversManager);
        }
    }

    public final void setCollisionResolversManager(CollisionResolversManager collisionResolversManager) {
        this.collisionResolversManager = collisionResolversManager;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.isEnabled()) {
            this.step(timingMode.getMicroSeconds(frameTime));
        }
    }

    protected SimulationEngine() {
    }
}

