/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation;

import java.util.ArrayList;
import java.util.Set;
import org.jagatoo.datatypes.Enableable;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionResolversManager;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.Joint;
import org.xith3d.physics.simulation.JointLimitMotor;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SurfaceParameters;
import org.xith3d.physics.simulation.joints.BallJoint;
import org.xith3d.physics.simulation.joints.FixedJoint;
import org.xith3d.physics.simulation.joints.Hinge2Joint;
import org.xith3d.physics.simulation.joints.HingeJoint;
import org.xith3d.physics.simulation.joints.SliderJoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimulationWorld
implements Updatable,
Enableable {
    protected SimulationEngine engine;
    private final ArrayList<Body> bodies = new ArrayList();
    private final ArrayList<Joint> joints = new ArrayList();
    private final Vector3f gravity;
    private boolean gravityEnabled = true;
    private long stepMicros = -1L;
    private long maxStepMicros = -1L;
    private boolean enabled = true;
    private long stepAccumulator = 0L;

    public SimulationEngine getEngine() {
        return this.engine;
    }

    protected abstract void setGravityImpl(float var1, float var2, float var3);

    public final void setGravity(float x, float y, float z) {
        this.gravity.set(x, y, z);
        this.setGravityImpl(x, y, z);
    }

    public final void setGravity(Vector3f gravity) {
        this.setGravity(gravity.getX(), gravity.getY(), gravity.getZ());
    }

    public void setGravityEnabled(boolean enabled) {
        if (enabled == this.gravityEnabled) {
            return;
        }
        this.gravityEnabled = enabled;
        if (enabled) {
            this.setGravityImpl(this.gravity.getX(), this.gravity.getY(), this.gravity.getZ());
        } else {
            this.setGravityImpl(0.0f, 0.0f, 0.0f);
        }
    }

    public final boolean isGravityEnabled() {
        return this.gravityEnabled;
    }

    public final Vector3f getGravity() {
        return this.gravity.getReadOnly();
    }

    protected abstract Body newBodyImpl();

    public final Body newBody() {
        Body body = this.newBodyImpl();
        return body;
    }

    protected abstract void addBodyImpl(Body var1);

    public final void addBody(Body body) {
        if (!this.bodies.contains(body)) {
            this.bodies.add(body);
            this.addBodyImpl(body);
        }
    }

    protected abstract void removeBodyImpl(Body var1);

    public final void removeBody(Body body) {
        if (this.bodies.remove(body)) {
            this.removeBodyImpl(body);
        }
    }

    public final int numBodies() {
        return this.bodies.size();
    }

    public final Body getBody(int i) {
        return this.bodies.get(i);
    }

    protected JointLimitMotor newJointLimitMotor(float defaultCFM, float defaultERP) {
        return new JointLimitMotor(defaultCFM, defaultERP);
    }

    public final JointLimitMotor newJointLimitMotor() {
        return this.newJointLimitMotor(0.2f, 1.0E-6f);
    }

    protected abstract BallJoint newBallJointImpl(Body var1, Body var2);

    public final BallJoint newBallJoint(Body body1, Body body2) {
        BallJoint joint = this.newBallJointImpl(body1, body2);
        return joint;
    }

    protected abstract FixedJoint newFixedJointImpl(Body var1, Body var2);

    public final FixedJoint newFixedJoint(Body body1, Body body2) {
        FixedJoint joint = this.newFixedJointImpl(body1, body2);
        return joint;
    }

    protected abstract HingeJoint newHingeJointImpl(Body var1, Body var2);

    public final HingeJoint newHingeJoint(Body body1, Body body2) {
        HingeJoint joint = this.newHingeJointImpl(body1, body2);
        return joint;
    }

    protected abstract Hinge2Joint newHinge2JointImpl(Body var1, Body var2);

    public final Hinge2Joint newHinge2Joint(Body body1, Body body2) {
        Hinge2Joint joint = this.newHinge2JointImpl(body1, body2);
        return joint;
    }

    protected abstract SliderJoint newSliderJointImpl(Body var1, Body var2);

    public final SliderJoint newSliderJoint(Body body1, Body body2) {
        SliderJoint joint = this.newSliderJointImpl(body1, body2);
        return joint;
    }

    protected abstract void addJointImpl(Joint var1);

    public final void addJoint(Joint joint) {
        if (!this.joints.contains(joint)) {
            this.joints.add(joint);
            this.addJointImpl(joint);
        }
    }

    protected abstract void removeJointImpl(Joint var1);

    public final void removeJoint(Joint joint) {
        if (this.joints.remove(joint)) {
            this.removeJointImpl(joint);
        }
    }

    public final int numJoints() {
        return this.joints.size();
    }

    public final Joint getJoint(int i) {
        return this.joints.get(i);
    }

    public abstract Set<String> getStepperFunctions();

    public abstract void setStepperFunction(String var1);

    public abstract String getStepperFunction();

    public final void setStepSize(long micros) {
        if (micros < 1L && micros != -1L) {
            throw new IllegalArgumentException("micros must be -1 or greater then 0");
        }
        this.stepMicros = micros;
    }

    public final long getStepSize() {
        if (this.stepMicros == -1L) {
            return this.engine.getStepSize();
        }
        return this.stepMicros;
    }

    public final void setMaxStepSize(long micros) {
        if (micros < 1L && micros != -1L) {
            throw new IllegalArgumentException("micros must be -1 or greater then 0");
        }
        this.maxStepMicros = micros;
    }

    public final long getMaxStepSize() {
        if (this.maxStepMicros == -1L) {
            return this.engine.getMaxStepSize();
        }
        return this.maxStepMicros;
    }

    protected abstract void beforeStep();

    protected abstract void afterStep();

    protected abstract void stepImpl(long var1);

    public final void step(long stepMicros, CollisionResolversManager collisionResolversManager) {
        int i;
        long step = this.getStepSize();
        long maxStep = this.getMaxStepSize();
        if (stepMicros > maxStep) {
            stepMicros = step;
        }
        this.beforeStep();
        this.stepAccumulator += stepMicros;
        while (this.stepAccumulator >= step) {
            if (collisionResolversManager != null) {
                collisionResolversManager.update();
            }
            this.stepImpl(step);
            this.stepAccumulator -= step;
        }
        for (i = 0; i < this.bodies.size(); ++i) {
            this.bodies.get(i).refresh();
        }
        for (i = 0; i < this.joints.size(); ++i) {
            this.joints.get(i).refresh();
        }
        this.afterStep();
    }

    public abstract void resolveCollision(Collision var1, Body var2, Body var3, SurfaceParameters var4);

    public final void resolveCollision(Collision collision, SurfaceParameters surfParams) {
        this.resolveCollision(collision, collision.getCollideable1().getBody(), collision.getCollideable2().getBody(), surfParams);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.isEnabled()) {
            this.step(timingMode.getMicroSeconds(frameTime), null);
        }
    }

    public SimulationWorld(SimulationEngine engine) {
        this.engine = engine;
        this.gravity = new Vector3f(0.0f, -9.81f, 0.0f);
    }
}

