/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation.joode;

import net.java.dev.joode.Mass;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.collision.collideable.CapsuleCollideable;
import org.xith3d.physics.collision.collideable.CylinderCollideable;
import org.xith3d.physics.collision.collideable.PlaneCollideable;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.collision.collideable.TriMeshCollideable;
import org.xith3d.physics.collision.joode.JoodeCapsuleCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCylinderCollideable;
import org.xith3d.physics.joode.Convert;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.joode.JoodeSimulationWorld;

public class JoodeBody
extends Body {
    protected final net.java.dev.joode.Body body = new net.java.dev.joode.Body(null, Mass.createSphere(1.0f, 0.0f));
    private static Matrix3 matrix3 = null;
    private static Vector3f tmpVec3f = null;

    public JoodeBody(JoodeSimulationWorld world) {
        super(world);
    }

    protected void onPositionChanged() {
        super.onPositionChanged();
        this.body.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
    }

    protected void onRotationChanged() {
        super.onRotationChanged();
        if (matrix3 == null) {
            matrix3 = new Matrix3();
        }
        Convert.toJOODE(this.rotation, matrix3);
        this.body.setRotation(Convert.toJOODE(this.rotation));
    }

    public final net.java.dev.joode.Body getJOODEBody() {
        return this.body;
    }

    public final void setEnabled(boolean enabled) {
        this.getJOODEBody().setEnabled(enabled);
    }

    public final boolean isEnabled() {
        return this.getJOODEBody().isEnabled();
    }

    public void setGravityEnabled(boolean enabled) {
        this.getJOODEBody().setFlag(64, enabled);
    }

    public boolean isGravityEnabled() {
        return this.getJOODEBody().getFlag(64);
    }

    public void setMass(float mass) {
        this.body.getMass().adjust(mass);
    }

    public float getMass() {
        return this.body.getMass().getMass();
    }

    public Vector3f getAngularVelocity() {
        if (tmpVec3f == null) {
            tmpVec3f = new Vector3f();
        }
        Convert.toXith(this.body.getAngularVel(), tmpVec3f);
        return tmpVec3f;
    }

    public Vector3f getLinearVelocity() {
        if (tmpVec3f == null) {
            tmpVec3f = new Vector3f();
        }
        Convert.toXith(this.body.getLinearVel(), tmpVec3f);
        return tmpVec3f;
    }

    public void setLinearVelocity(float velX, float velY, float velZ) {
        this.body.setLinearVel(velX, velY, velZ);
    }

    public void setAngularVelocity(float velX, float velY, float velZ) {
        this.body.setAngularVel(velX, velY, velZ);
    }

    protected void refresh() {
        Vector3 bodyPos = this.body.getPosition();
        Convert.toXith(bodyPos, this.position);
        this.onPositionChanged();
        Matrix3 bodyR = this.body.getRotation();
        Convert.toXith(bodyR, this.rotation);
        this.onRotationChanged();
        super.refresh();
    }

    public void addForce(float fx, float fy, float fz) {
        this.body.addForce(fx, fy, fz);
    }

    public void addTorque(float tx, float ty, float tz) {
        this.body.addTorque(tx, ty, tz);
    }

    public void addCollideable(Collideable c) {
        super.addCollideable(c);
        this.body.addGeom(((JoodeCollideable)c).getJOODEGeom());
        if (this.getCollideablesCount() == 1) {
            if (c instanceof BoxCollideable) {
                BoxCollideable box = (BoxCollideable)c;
                this.body.setMass(Mass.createBox(1.0f, box.getSize().getX(), box.getSize().getY(), box.getSize().getZ()));
            } else if (c instanceof CapsuleCollideable) {
                JoodeCapsuleCollideable caps = (JoodeCapsuleCollideable)c;
                this.body.setMass(Mass.createCapsule(1.0f, 1, caps.getRadius(), caps.getLength()));
            } else if (c instanceof CylinderCollideable) {
                JoodeCylinderCollideable cyl = (JoodeCylinderCollideable)c;
                this.body.setMass(Mass.createCylinder(1.0f, 1, cyl.getRadius(), cyl.getLength()));
            } else if (c instanceof PlaneCollideable) {
                this.body.setMass(Mass.createSphere(1.0f, 1.0f));
            } else if (c instanceof SphereCollideable) {
                SphereCollideable sph = (SphereCollideable)c;
                this.body.setMass(Mass.createSphere(1.0f, sph.getRadius()));
            } else if (c instanceof TriMeshCollideable) {
                this.body.setMass(Mass.createSphere(1.0f, 1.0f));
            } else {
                this.body.setMass(Mass.createSphere(1.0f, 1.0f));
            }
        } else {
            this.body.setMass(Mass.createSphere(1.0f, 1.0f));
        }
    }

    public void removeCollideable(Collideable c) {
        super.removeCollideable(c);
        this.body.removeGeom(((JoodeCollideable)c).getJOODEGeom());
        if (this.getCollideablesCount() == 0) {
            this.body.setMass(Mass.createSphere(1.0f, 0.0f));
        }
    }
}

