/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation.joode;

import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionListener;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.physics.simulation.SurfaceParameters;
import org.xith3d.physics.simulation.joode.JoodeSimulationWorld;
import org.xith3d.physics.simulation.joode.JoodeSurfaceParameters;

public class JoodeSimulationEngine
extends SimulationEngine {
    public SimulationWorld newWorldImpl() {
        return new JoodeSimulationWorld(this);
    }

    public SurfaceParameters newSurfaceParameters(String[] paramStrings, Object[] paramValues) {
        return new JoodeSurfaceParameters(paramStrings, paramValues);
    }

    public final void initialize(CollisionEngine collEngine) {
        System.out.print("Initializing JOODE...");
        final JoodeSimulationWorld world = (JoodeSimulationWorld)this.newWorld();
        BoxCollideable box1 = collEngine.newBox(1.0f, 1.0f, 1.0f);
        box1.setPosition(0.0f, 0.0f, 0.0f);
        BoxCollideable box2 = collEngine.newBox(1.0f, 1.0f, 1.0f);
        final Body body = world.newBody();
        body.addCollideable(box2);
        body.setPosition(0.5f, 0.0f, 0.0f);
        world.addBody(body);
        final SurfaceParameters surfaceParams = this.newSurfaceParameters();
        CollisionListener listener = new CollisionListener(){

            public void onCollision(Collision collision) {
                world.resolveCollision(collision, body, null, surfaceParams);
            }
        };
        int i = 0;
        while (i < 1000) {
            body.setPosition(0.5f, 0.0f, 0.0f);
            collEngine.checkCollisions((Collideable)box1, (Collideable)box2, false, listener);
            world.stepImpl(20L);
            ++i;
        }
        world.removeBody(body);
        this.destroyWorld(world);
        System.out.println("ok");
    }
}

