/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import org.openmali.FastMath;
import org.openmali.spatial.LineContainer;
import org.openmali.spatial.TriangleContainer;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.picking.GeometryPickTester;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.PointArray;
import org.xith3d.scenegraph.PointAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.View;

public class DefaultGeometryPickTester
implements GeometryPickTester {
    private static final int[] TMP_ARRAY = new int[1];

    private static final float testTriangle(PickResult pr, int faceIndex, Triangle triang, Ray3f pickRay, float closestIntersection, boolean testIntersectionsInWorldSpace) {
        float f;
        if (testIntersectionsInWorldSpace) {
            triang.transform(pr.getTransform().getMatrix4f());
        }
        if ((f = triang.intersects(pickRay, closestIntersection)) >= 0.0f) {
            if ((f /= pickRay.length()) < closestIntersection) {
                pr.setMinimumDistance(f);
                pr.setFaceIndex(faceIndex);
                return f;
            }
            return -1.0f;
        }
        return -1.0f;
    }

    public float testGeometryIntersection(PickResult pickCandidate, Ray3f pickRay, float closestIntersection, boolean testIntersectionsInWorldSpace, Triangle bufferTriangle) {
        float result = -1.0f;
        Geometry geom = pickCandidate.getGeometry();
        if (geom instanceof TriangleContainer) {
            TriangleContainer triangCnt = (TriangleContainer)((Object)geom);
            if (geom instanceof TriangleStripArray) {
                int[] stripLengths;
                TriangleStripArray tsa = (TriangleStripArray)geom;
                if (tsa.getStripVertexCounts() == null) {
                    stripLengths = TMP_ARRAY;
                    stripLengths[0] = tsa.getVertexCount();
                } else {
                    stripLengths = tsa.getStripVertexCounts();
                }
                int offset = 0;
                for (int i = 0; i < stripLengths.length; ++i) {
                    for (int j = 2; j < stripLengths[i]; ++j) {
                        int idx0 = offset + j - 2;
                        int idx1 = offset + j - 1;
                        int idx2 = offset + j - 0;
                        tsa.getTriangle(idx0, idx1, idx2, bufferTriangle);
                        float f = DefaultGeometryPickTester.testTriangle(pickCandidate, idx0, bufferTriangle, pickRay, closestIntersection, testIntersectionsInWorldSpace);
                        if (!(f >= 0.0f)) continue;
                        closestIntersection = f;
                        result = f;
                    }
                    offset += stripLengths[i] - 2;
                }
            } else if (geom instanceof IndexedTriangleStripArray) {
                int[] stripLengths;
                IndexedTriangleStripArray itsa = (IndexedTriangleStripArray)geom;
                if (itsa.getStripVertexCounts() == null) {
                    stripLengths = TMP_ARRAY;
                    stripLengths[0] = itsa.getVertexCount();
                } else {
                    stripLengths = itsa.getStripVertexCounts();
                }
                int[] index = itsa.getIndex();
                int offset = 0;
                for (int i = 0; i < stripLengths.length; ++i) {
                    for (int j = 2; j < stripLengths[i]; ++j) {
                        int idx0 = index[offset + j - 2];
                        int idx1 = index[offset + j - 1];
                        int idx2 = index[offset + j - 0];
                        itsa.getTriangle(idx0, idx1, idx2, bufferTriangle);
                        float f = DefaultGeometryPickTester.testTriangle(pickCandidate, idx0, bufferTriangle, pickRay, closestIntersection, testIntersectionsInWorldSpace);
                        if (!(f >= 0.0f)) continue;
                        closestIntersection = f;
                        result = f;
                    }
                    offset += stripLengths[i] - 2;
                }
            } else {
                int nTrian = triangCnt.getTriangleCount();
                for (int i = 0; i < nTrian; ++i) {
                    triangCnt.getTriangle(i, bufferTriangle);
                    float f = DefaultGeometryPickTester.testTriangle(pickCandidate, i, bufferTriangle, pickRay, closestIntersection, testIntersectionsInWorldSpace);
                    if (!(f >= 0.0f)) continue;
                    closestIntersection = f;
                    result = f;
                }
            }
        } else if (geom instanceof PointArray) {
            float fovH;
            PointArray points = (PointArray)geom;
            if (!(pickCandidate.getNode() instanceof Shape3D)) {
                return result;
            }
            Shape3D shape = (Shape3D)pickCandidate.getNode();
            if (shape.getAppearance() == null) {
                return result;
            }
            PointAttributes pointAttribs = shape.getAppearance().getPointAttributes();
            if (pointAttribs == null) {
                return result;
            }
            float size = pointAttribs.getPointSize();
            Leaf node2 = pickCandidate.getNode();
            BranchGroup root = node2 == null ? null : node2.getRoot();
            SceneGraph sceneGraph = root == null ? null : root.getSceneGraph();
            View view = sceneGraph == null ? null : sceneGraph.getView();
            Point3f viewPosition = view == null ? null : view.getPosition();
            Canvas3D canvas = view == null ? null : view.getCanvas3D(0);
            View.ProjectionPolicy projectionPolicy = view == null ? View.ProjectionPolicy.PERSPECTIVE_PROJECTION : view.getProjectionPolicy();
            float h = fovH = size * 0.001167f;
            if (viewPosition != null && canvas != null) {
                switch (projectionPolicy) {
                    case PERSPECTIVE_PROJECTION: {
                        fovH = size * FastMath.tan(view.getFieldOfView()) / (float)canvas.getHeight();
                        break;
                    }
                    case PARALLEL_PROJECTION: {
                        h = size / 2.0f * (2.0f / (float)canvas.getWidth());
                    }
                }
            }
            Point3f point = Point3f.fromPool();
            Vector3f tmp = Vector3f.fromPool();
            int n = points.getVertexCount();
            for (int i = 0; i < n; ++i) {
                points.getVertex(i, point);
                if (projectionPolicy == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    tmp.sub(point, viewPosition);
                    h = fovH * tmp.length();
                }
                float px = point.getX();
                float py = point.getY();
                float pz = point.getZ();
                for (int j = 0; j < 6; ++j) {
                    float ax = 0.0f;
                    float ay = 0.0f;
                    float az = 0.0f;
                    float bx = 0.0f;
                    float by = 0.0f;
                    float bz = 0.0f;
                    float cx = 0.0f;
                    float cy = 0.0f;
                    float cz = 0.0f;
                    switch (j) {
                        case 0: {
                            ax = -h;
                            ay = -h;
                            az = 0.0f;
                            bx = h;
                            by = h;
                            bz = 0.0f;
                            cx = -h;
                            cy = h;
                            cz = 0.0f;
                            break;
                        }
                        case 1: {
                            ax = -h;
                            ay = -h;
                            az = 0.0f;
                            bx = h;
                            by = -h;
                            bz = 0.0f;
                            cx = h;
                            cy = h;
                            cz = 0.0f;
                            break;
                        }
                        case 2: {
                            ax = -h;
                            ay = 0.0f;
                            az = -h;
                            bx = h;
                            by = 0.0f;
                            bz = h;
                            cx = -h;
                            cy = 0.0f;
                            cz = h;
                            break;
                        }
                        case 3: {
                            ax = -h;
                            ay = 0.0f;
                            az = -h;
                            bx = h;
                            by = 0.0f;
                            bz = -h;
                            cx = h;
                            cy = 0.0f;
                            cz = h;
                            break;
                        }
                        case 4: {
                            ax = 0.0f;
                            ay = -h;
                            az = -h;
                            bx = 0.0f;
                            by = h;
                            bz = h;
                            cx = 0.0f;
                            cy = -h;
                            cz = h;
                            break;
                        }
                        case 5: {
                            ax = 0.0f;
                            ay = -h;
                            az = -h;
                            bx = 0.0f;
                            by = h;
                            bz = -h;
                            cx = 0.0f;
                            cy = h;
                            cz = h;
                        }
                    }
                    bufferTriangle.setVertexCoordA(tmp.set(px + ax, py + ay, pz + az));
                    bufferTriangle.setVertexCoordB(tmp.set(px + bx, py + by, pz + bz));
                    bufferTriangle.setVertexCoordC(tmp.set(px + cx, py + cy, pz + cz));
                    float f = DefaultGeometryPickTester.testTriangle(pickCandidate, i, bufferTriangle, pickRay, closestIntersection, testIntersectionsInWorldSpace);
                    if (!(f >= 0.0f)) continue;
                    if (f < closestIntersection) {
                        closestIntersection = f;
                    }
                    result = f;
                }
            }
            Vector3f.toPool(tmp);
            Point3f.toPool(point);
        } else if (geom instanceof LineContainer) {
            float fovH;
            LineContainer lines = (LineContainer)((Object)geom);
            if (!(pickCandidate.getNode() instanceof Shape3D)) {
                return result;
            }
            Shape3D shape = (Shape3D)pickCandidate.getNode();
            if (shape.getAppearance() == null) {
                return result;
            }
            LineAttributes lineAttribs = shape.getAppearance().getLineAttributes();
            if (lineAttribs == null) {
                return result;
            }
            float lwidth = lineAttribs.getLineWidth();
            Leaf node3 = pickCandidate.getNode();
            BranchGroup root = node3 == null ? null : node3.getRoot();
            SceneGraph sceneGraph = root == null ? null : root.getSceneGraph();
            View view = sceneGraph == null ? null : sceneGraph.getView();
            Point3f viewPosition = view == null ? null : view.getPosition();
            Canvas3D canvas = view == null ? null : view.getCanvas3D(0);
            View.ProjectionPolicy projectionPolicy = view == null ? View.ProjectionPolicy.PERSPECTIVE_PROJECTION : view.getProjectionPolicy();
            float hn = fovH = lwidth * 0.001167f;
            float hn1 = fovH;
            if (viewPosition != null && canvas != null) {
                switch (projectionPolicy) {
                    case PERSPECTIVE_PROJECTION: {
                        fovH = lwidth * FastMath.tan(view.getFieldOfView()) / (float)canvas.getHeight();
                        break;
                    }
                    case PARALLEL_PROJECTION: {
                        hn1 = hn = lwidth / 2.0f * (2.0f / (float)canvas.getWidth());
                    }
                }
            }
            int n = lines.getLinesCount();
            Point3f pn = Point3f.fromPool();
            Point3f pn1 = Point3f.fromPool();
            Point3f pfll = Point3f.fromPool();
            Point3f pful = Point3f.fromPool();
            Point3f pflr = Point3f.fromPool();
            Point3f pfur = Point3f.fromPool();
            Point3f pbll = Point3f.fromPool();
            Point3f pbul = Point3f.fromPool();
            Point3f pblr = Point3f.fromPool();
            Point3f pbur = Point3f.fromPool();
            Vector3f lineVector = Vector3f.fromPool();
            Vector3f right = Vector3f.fromPool();
            Vector3f up = Vector3f.fromPool();
            Vector3f tmp = Vector3f.fromPool();
            Matrix4f transform = Matrix4f.fromPool();
            Matrix3f rot = Matrix3f.fromPool();
            for (int i = 0; i < n; ++i) {
                lines.getLineCoordinates(i, pn, pn1);
                if (projectionPolicy == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    tmp.sub(pn, viewPosition);
                    hn = fovH * tmp.length();
                    tmp.sub(pn1, viewPosition);
                    hn1 = fovH * tmp.length();
                }
                ((Tuple3f)lineVector.set((TupleNf)pn1)).sub(pn);
                float l = lineVector.length();
                lineVector.normalize();
                pfll.set(-hn, 0.0f - hn, hn);
                pflr.set(hn, 0.0f - hn, hn);
                pful.set(-hn1, l + hn1, hn1);
                pfur.set(hn1, l + hn1, hn1);
                pbll.set(-hn, 0.0f - hn, -hn);
                pblr.set(hn, 0.0f - hn, -hn);
                pbul.set(-hn1, l + hn1, -hn1);
                pbur.set(hn1, l + hn1, -hn1);
                float dz = pn1.getZ() - pn.getZ();
                tmp.set((TupleNf)(-0.001f < dz && dz < 0.001f ? Vector3f.NEGATIVE_Z_AXIS : Vector3f.NEGATIVE_Y_AXIS));
                right.cross(lineVector, tmp);
                right.normalize();
                up.cross(lineVector, right);
                up.normalize();
                rot.setColumn(0, right);
                rot.setColumn(1, lineVector);
                rot.setColumn(2, up);
                transform.setIdentity();
                transform.setRotation(rot);
                transform.setTranslation(pn);
                transform.transform(pfll);
                transform.transform(pful);
                transform.transform(pflr);
                transform.transform(pfur);
                transform.transform(pbll);
                transform.transform(pbul);
                transform.transform(pblr);
                transform.transform(pbur);
                for (int j = 0; j < 8; ++j) {
                    switch (j) {
                        case 0: {
                            bufferTriangle.setVertexCoordA(pfll);
                            bufferTriangle.setVertexCoordB(pbur);
                            bufferTriangle.setVertexCoordC(pful);
                            break;
                        }
                        case 1: {
                            bufferTriangle.setVertexCoordA(pfll);
                            bufferTriangle.setVertexCoordB(pbur);
                            bufferTriangle.setVertexCoordC(pblr);
                            break;
                        }
                        case 2: {
                            bufferTriangle.setVertexCoordA(pflr);
                            bufferTriangle.setVertexCoordB(pbul);
                            bufferTriangle.setVertexCoordC(pfur);
                            break;
                        }
                        case 3: {
                            bufferTriangle.setVertexCoordA(pflr);
                            bufferTriangle.setVertexCoordB(pbul);
                            bufferTriangle.setVertexCoordC(pbll);
                            break;
                        }
                        case 4: {
                            bufferTriangle.setVertexCoordA(pbll);
                            bufferTriangle.setVertexCoordB(pflr);
                            bufferTriangle.setVertexCoordC(pfll);
                            break;
                        }
                        case 5: {
                            bufferTriangle.setVertexCoordA(pbll);
                            bufferTriangle.setVertexCoordB(pflr);
                            bufferTriangle.setVertexCoordC(pblr);
                            break;
                        }
                        case 6: {
                            bufferTriangle.setVertexCoordA(pbul);
                            bufferTriangle.setVertexCoordB(pfur);
                            bufferTriangle.setVertexCoordC(pful);
                            break;
                        }
                        case 7: {
                            bufferTriangle.setVertexCoordA(pbul);
                            bufferTriangle.setVertexCoordB(pfur);
                            bufferTriangle.setVertexCoordC(pbur);
                        }
                    }
                    float f = DefaultGeometryPickTester.testTriangle(pickCandidate, i, bufferTriangle, pickRay, closestIntersection, testIntersectionsInWorldSpace);
                    if (!(f >= 0.0f)) continue;
                    if (f < closestIntersection) {
                        closestIntersection = f;
                    }
                    result = f;
                }
            }
            Point3f.toPool(pn);
            Point3f.toPool(pn1);
            Point3f.toPool(pfll);
            Point3f.toPool(pful);
            Point3f.toPool(pflr);
            Point3f.toPool(pfur);
            Point3f.toPool(pbll);
            Point3f.toPool(pbul);
            Point3f.toPool(pblr);
            Point3f.toPool(pbur);
            Vector3f.toPool(lineVector);
            Vector3f.toPool(tmp);
            Vector3f.toPool(right);
            Vector3f.toPool(up);
            Matrix4f.toPool(transform);
            Matrix3f.toPool(rot);
        }
        return result;
    }
}

