/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.util.errorhandling.UnsupportedFunction;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickResult
implements Comparable<PickResult> {
    private Leaf node;
    private int faceIndex;
    protected Tuple3f tmpPos = new Point3f();
    private Tuple3f pos;
    private float minDistance;
    private float maxDistance;
    private float medDistance;
    private Transform3D tmpTrans = new Transform3D();
    private MouseButton button;

    public PickResult(Leaf node2, float minDist, float maxDist, float medDist) {
        this(node2, -1, minDist, maxDist, medDist);
    }

    public PickResult(Leaf node2, int faceIndex, float minDist, float maxDist, float medDist) {
        this.node = node2;
        this.faceIndex = faceIndex;
        this.pos = null;
        this.minDistance = minDist;
        this.maxDistance = maxDist;
        this.medDistance = medDist;
        this.button = null;
    }

    public PickResult(Leaf node2, float dist) {
        this(node2, dist, dist, dist);
    }

    PickResult() {
    }

    void set(Leaf node2, float dist, MouseButton button) {
        this.node = node2;
        this.faceIndex = -1;
        this.pos = null;
        this.minDistance = dist;
        this.maxDistance = dist;
        this.medDistance = dist;
        this.button = button;
    }

    public Leaf getNode() {
        return this.node;
    }

    public Node getPickHost() {
        return this.node.getPickHost();
    }

    public Node getPickHostOrNode() {
        if (this.node.getPickHost() == null) {
            return this.node;
        }
        return this.node.getPickHost();
    }

    public Geometry getGeometry() {
        if (this.node instanceof Shape3D) {
            return ((Shape3D)this.node).getGeometry();
        }
        return null;
    }

    public void setFaceIndex(int faceIndex) {
        this.faceIndex = faceIndex;
    }

    public int getFaceIndex() {
        if (this.faceIndex == -1) {
            throw new UnsupportedFunction("You tried to get the index of the face which has been picked, but you use OpenGL-style picking. If you want to use this functionality, please use org.xith3d.picking.PickingLibrary !!");
        }
        return this.faceIndex;
    }

    public void transform(Vector3f v) {
        this.node.getWorldTransform(this.tmpTrans);
        this.tmpTrans.invert();
        this.tmpTrans.transform(v);
    }

    public void transform(Point3f p) {
        this.node.getWorldTransform(this.tmpTrans);
        this.tmpTrans.invert();
        this.tmpTrans.transform(p);
    }

    public void transform(Ray3f ray) {
        this.node.getWorldTransform(this.tmpTrans);
        this.tmpTrans.invert();
        Point3f targ = new Point3f(ray.getOrigin());
        targ.add(ray.getDirection());
        this.tmpTrans.transform(ray.getOrigin());
        this.tmpTrans.transform(targ);
        targ.sub(ray.getOrigin());
        ray.setDirection(targ);
        ray.getDirection().normalize();
    }

    public void setPos(Tuple3f pos) {
        this.pos = pos;
    }

    public Tuple3f getPos() {
        return this.pos;
    }

    public void setMinimumDistance(float dist) {
        this.minDistance = dist;
    }

    public float getMinimumDistance() {
        return this.minDistance;
    }

    public void setMaximumDistance(float dist) {
        this.maxDistance = dist;
    }

    public float getMaximumDistance() {
        return this.maxDistance;
    }

    public void setMedialDistance(float dist) {
        this.medDistance = dist;
    }

    public float getMedialDistance() {
        return this.medDistance;
    }

    public final MouseButton getButton() {
        return this.button;
    }

    public String toString() {
        return "PickResult: Node: " + this.node + " Pos: " + this.pos;
    }

    @Override
    public int compareTo(PickResult pr) {
        if (this.minDistance > pr.minDistance) {
            return 1;
        }
        if (this.minDistance < pr.minDistance) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof PickResult) {
            PickResult r = (PickResult)o;
            if (this.node == r.node || ((TupleNf)this.pos).equals(r.pos)) {
                return true;
            }
        }
        return false;
    }

    public Transform3D getTransform() {
        return this.node.getWorldTransform();
    }
}

