/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import java.util.List;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.FastMath;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.DefaultGeometryPickTester;
import org.xith3d.picking.GeometryPickTester;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickPool;
import org.xith3d.picking.PickRay;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.general.SortableList;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickingLibrary {
    private static GeometryPickTester geomPickTester = new DefaultGeometryPickTester();
    private static boolean isGeometryIgnored = false;

    public static void setGeometryPickTester(GeometryPickTester geomPickTester) {
        PickingLibrary.geomPickTester = geomPickTester;
    }

    public static final GeometryPickTester getGeometryPickTester() {
        return geomPickTester;
    }

    public static void setGeometryIgnored(boolean geomIgnored) {
        isGeometryIgnored = geomIgnored;
    }

    public static boolean isGeometryIgnored() {
        return isGeometryIgnored;
    }

    private static void getPickCandidates(GroupNode group, Ray3f pickRay, MouseButton button, List<PickResult> candidates, Point3f pos) {
        for (int i = 0; i < group.numChildren(); ++i) {
            Node node2 = group.getChild(i);
            if (!node2.isPickable() || !node2.isRenderable()) continue;
            Bounds bounds = node2.getWorldBounds();
            if (bounds == null) {
                String msg = "null bounds detected... skipping full (sub-) group.\n  One reson for null bounds is, that you try to pick on a HUD's graph.  You should consider using one of the pick*() methods, that take a GroupNode instance. This is anyway faster.";
                X3DLog.error("null bounds detected... skipping full (sub-) group.\n  One reson for null bounds is, that you try to pick on a HUD's graph.  You should consider using one of the pick*() methods, that take a GroupNode instance. This is anyway faster.");
                continue;
            }
            if (!bounds.intersects(pickRay, pos)) continue;
            if (node2 instanceof GroupNode) {
                PickingLibrary.getPickCandidates((GroupNode)node2, pickRay, button, candidates, pos);
                continue;
            }
            if (!(node2 instanceof Leaf)) continue;
            float dist = pos.distanceSquared(pickRay.getOrigin());
            PickResult pr = PickPool.allocatePickResult();
            pr.set((Leaf)node2, dist, button);
            candidates.add(pr);
        }
    }

    private static SortableList<PickResult> getPickCandidates(List<? extends GroupNode> groups, Ray3f pickRay, MouseButton button) {
        SortableList<PickResult> candidates = PickPool.allocatePickResultList();
        Point3f pos = Point3f.fromPool();
        for (int g = 0; g < groups.size(); ++g) {
            GroupNode group = groups.get(g);
            group.updateBounds(true);
            PickingLibrary.getPickCandidates(group, pickRay, button, candidates, pos);
        }
        Point3f.toPool(pos);
        return candidates;
    }

    private static SortableList<PickResult> checkGeomIntersections(SortableList<PickResult> pickCandidates, Ray3f pickRay, boolean onlyNearest, boolean testIntersectionsInWorldSpace) {
        Triangle triang = PickPool.allocateTriangle();
        Ray3f transRay = PickPool.allocateRay3f();
        float closestIntersect = Float.POSITIVE_INFINITY;
        SortableList<PickResult> pickResults = PickPool.allocatePickResultList();
        for (int i = 0; i < pickCandidates.size(); ++i) {
            float intersectionDistance;
            boolean intersects;
            PickResult pr = (PickResult)pickCandidates.get(i);
            transRay.set(pickRay);
            if (!testIntersectionsInWorldSpace) {
                pr.transform(transRay);
            }
            boolean bl = intersects = (intersectionDistance = geomPickTester.testGeometryIntersection(pr, transRay, closestIntersect, testIntersectionsInWorldSpace, triang)) >= 0.0f;
            if (intersects && onlyNearest) {
                closestIntersect = intersectionDistance;
            }
            if (intersects) {
                Tuple3f p = pr.tmpPos;
                p.scaleAdd(FastMath.sqrt(pr.getMinimumDistance()), pickRay.getDirection(), pickRay.getOrigin());
                pr.setPos(p);
                pickResults.add(pr);
                continue;
            }
            PickPool.deallocatePickResult(pr);
        }
        PickPool.deallocateRay3f(transRay);
        PickPool.deallocateTriangle(triang);
        PickPool.deallocatePickResultList(pickCandidates);
        return pickResults;
    }

    public static void pickAll(List<? extends GroupNode> groups, Ray3f pickRay, MouseButton button, AllPickListener l, Object userObject) {
        long t0 = System.currentTimeMillis();
        SortableList<PickResult> intersecting = PickingLibrary.getPickCandidates(groups, pickRay, button);
        if (intersecting.size() > 0) {
            if (!PickingLibrary.isGeometryIgnored()) {
                intersecting = PickingLibrary.checkGeomIntersections(intersecting, pickRay, false, l.testIntersectionsInWorldSpaceForPicking());
            }
            intersecting.sort();
            if (intersecting.size() > 0) {
                l.onObjectsPicked(intersecting, userObject, System.currentTimeMillis() - t0);
            } else {
                l.onPickingMissed(userObject, System.currentTimeMillis() - t0);
            }
        } else {
            l.onPickingMissed(userObject, System.currentTimeMillis() - t0);
        }
        for (int i = 0; i < intersecting.size(); ++i) {
            PickPool.deallocatePickResult((PickResult)intersecting.get(i));
        }
        PickPool.deallocatePickResultList(intersecting);
    }

    public static void pickAll(List<? extends GroupNode> groups, Ray3f pickRay, MouseButton button, AllPickListener l) {
        PickingLibrary.pickAll(groups, pickRay, button, l, null);
    }

    private static void calcPickRay(RenderPassConfig rpConfig, List<? extends GroupNode> groups, PickRay pickRay, Canvas3D canvas, int x, int y) {
        if (groups.size() > 0) {
            pickRay.recalculate(rpConfig, canvas, x, y);
        } else {
            pickRay.recalculate(View.CameraMode.VIEW_NORMAL, canvas, x, y);
        }
    }

    public static void pickAll(RenderPassConfig rpConfig, List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int x, int y, AllPickListener l, Object userObject) {
        if (groups.size() == 0) {
            return;
        }
        PickRay pickRay = PickPool.allocatePickRay();
        PickingLibrary.calcPickRay(rpConfig, groups, pickRay, canvas, x, y);
        PickingLibrary.pickAll(groups, pickRay, button, l, userObject);
        PickPool.deallocatePickRay(pickRay);
    }

    public static void pickAll(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int x, int y, AllPickListener l, Object userObject) {
        if (groups.size() == 0) {
            return;
        }
        PickRay pickRay = PickPool.allocatePickRay();
        PickingLibrary.calcPickRay(null, groups, pickRay, canvas, x, y);
        PickingLibrary.pickAll(groups, pickRay, button, l, userObject);
        PickPool.deallocatePickRay(pickRay);
    }

    public static void pickAll(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int x, int y, AllPickListener l) {
        PickingLibrary.pickAll(groups, canvas, button, x, y, l, (Object)null);
    }

    public static void pickAll(GroupNode group, Canvas3D canvas, MouseButton button, int x, int y, AllPickListener l, Object userObject) {
        List<GroupNode> groups = PickPool.allocateGroupList();
        groups.add(group);
        PickingLibrary.pickAll(groups, canvas, button, x, y, l, userObject);
        PickPool.deallocateGroupList(groups);
    }

    public static void pickAll(GroupNode group, Canvas3D canvas, MouseButton button, int x, int y, AllPickListener l) {
        PickingLibrary.pickAll(group, canvas, button, x, y, l, (Object)null);
    }

    public static void pickNearest(List<? extends GroupNode> groups, Ray3f pickRay, MouseButton button, NearestPickListener l, Object userObject) {
        long t0 = System.currentTimeMillis();
        SortableList<PickResult> intersecting = PickingLibrary.getPickCandidates(groups, pickRay, button);
        if (intersecting.size() > 0) {
            if (!PickingLibrary.isGeometryIgnored()) {
                intersecting = PickingLibrary.checkGeomIntersections(intersecting, pickRay, true, l.testIntersectionsInWorldSpaceForPicking());
            }
            intersecting.sort();
            if (intersecting.size() > 0) {
                l.onObjectPicked((PickResult)intersecting.get(0), userObject, System.currentTimeMillis() - t0);
            } else {
                l.onPickingMissed(userObject, System.currentTimeMillis() - t0);
            }
        } else {
            l.onPickingMissed(userObject, System.currentTimeMillis() - t0);
        }
        for (int i = 0; i < intersecting.size(); ++i) {
            PickPool.deallocatePickResult((PickResult)intersecting.get(i));
        }
        PickPool.deallocatePickResultList(intersecting);
    }

    public static void pickNearest(List<? extends GroupNode> groups, Ray3f pickRay, MouseButton button, NearestPickListener l) {
        PickingLibrary.pickNearest(groups, pickRay, button, l, null);
    }

    public static void pickNearest(RenderPassConfig rpConfig, List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int x, int y, NearestPickListener l, Object userObject) {
        PickRay pickRay = PickPool.allocatePickRay();
        PickingLibrary.calcPickRay(rpConfig, groups, pickRay, canvas, x, y);
        PickingLibrary.pickNearest(groups, pickRay, button, l, userObject);
        PickPool.deallocatePickRay(pickRay);
    }

    public static void pickNearest(RenderPassConfig rpConfig, GroupNode group, Canvas3D canvas, MouseButton button, int x, int y, NearestPickListener l, Object userObject) {
        List<GroupNode> groups = PickPool.allocateGroupList();
        groups.add(group);
        PickingLibrary.pickNearest(rpConfig, groups, canvas, button, x, y, l, userObject);
        PickPool.deallocateGroupList(groups);
    }

    public static void pickNearest(RenderPassConfig rpConfig, GroupNode group, Canvas3D canvas, MouseButton button, int x, int y, NearestPickListener l) {
        PickingLibrary.pickNearest(rpConfig, group, canvas, button, x, y, l, null);
    }

    public static void pickNearest(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int x, int y, NearestPickListener l, Object userObject) {
        PickingLibrary.pickNearest(null, groups, canvas, button, x, y, l, userObject);
    }

    public static void pickNearest(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int x, int y, NearestPickListener l) {
        PickingLibrary.pickNearest(groups, canvas, button, x, y, l, (Object)null);
    }

    public static void pickNearest(GroupNode group, Canvas3D canvas, MouseButton button, int x, int y, NearestPickListener l, Object userObject) {
        List<GroupNode> groups = PickPool.allocateGroupList();
        groups.add(group);
        PickingLibrary.pickNearest(groups, canvas, button, x, y, l, userObject);
        PickPool.deallocateGroupList(groups);
    }

    public static void pickNearest(GroupNode group, Canvas3D canvas, MouseButton button, int x, int y, NearestPickListener l) {
        PickingLibrary.pickNearest(group, canvas, button, x, y, l, (Object)null);
    }
}

