/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.Canvas3DWrapper;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;

public class Canvas3DJPanel
extends JPanel
implements Canvas3DWrapper {
    private static final long serialVersionUID = 9086864231543663085L;
    private Canvas3D canvas = null;
    private boolean isInitialized = false;

    public final Canvas3D getCanvas() {
        return this.canvas;
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.canvas != null && this.canvas.getPeer() != null && this.canvas.getPeer().getComponent() instanceof JComponent) {
            ((JComponent)this.canvas.getPeer().getComponent()).setOpaque(isOpaque);
        }
    }

    public void setLayout(LayoutManager mgr) {
        if (this.isInitialized) {
            throw new UnsupportedOperationException("You cannot change the LayoutManager of a Canvas3DPanel.");
        }
    }

    public void setFocusable(boolean b) {
        super.setFocusable(b);
        ((Component)this.canvas.getPeer().getComponent()).setFocusable(b);
    }

    public void requestFocus() {
        ((Component)this.canvas.getPeer().getComponent()).requestFocus();
    }

    public synchronized void addKeyListener(KeyListener l) {
        ((Component)this.canvas.getPeer().getComponent()).addKeyListener(l);
    }

    public synchronized void removeKeyListener(KeyListener l) {
        ((Component)this.canvas.getPeer().getComponent()).removeKeyListener(l);
    }

    public synchronized void addMouseListener(MouseListener l) {
        ((Component)this.canvas.getPeer().getComponent()).addMouseListener(l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        ((Component)this.canvas.getPeer().getComponent()).removeMouseListener(l);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        ((Component)this.canvas.getPeer().getComponent()).addMouseMotionListener(l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        ((Component)this.canvas.getPeer().getComponent()).removeMouseMotionListener(l);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        ((Component)this.canvas.getPeer().getComponent()).addMouseWheelListener(l);
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener l) {
        super.removeMouseWheelListener(l);
        ((Component)this.canvas.getPeer().getComponent()).removeMouseWheelListener(l);
    }

    public void setRenderOptions(RenderOptions ro) {
        this.getCanvas().setRenderOptions(ro);
    }

    public final RenderOptions getRenderOptions() {
        return this.getCanvas().getRenderOptions();
    }

    public void setWireframeMode(boolean enable) {
        this.getCanvas().setWireframeMode(enable);
    }

    public final boolean isWireframeMode() {
        return this.getCanvas().isWireframeMode();
    }

    public boolean switchWireframeMode() {
        return this.getCanvas().switchWireframeMode();
    }

    public void enableLighting() {
        this.getCanvas().enableLighting();
    }

    public void disableLighting() {
        this.getCanvas().disableLighting();
    }

    public Canvas3DJPanel(OpenGLLayer layer, int bpp, FSAA fsaa, boolean vsync) {
        super(true);
        if (layer != OpenGLLayer.JOGL_AWT && layer != OpenGLLayer.JOGL_SWING && layer != OpenGLLayer.LWJGL_AWT) {
            throw new IllegalArgumentException("You can only use JOGL_AWT, JOGL_SWING or LWJGL_AWT as OpenGLLayer");
        }
        super.setLayout(new GridLayout());
        super.setBackground(Color.BLACK);
        this.canvas = Canvas3DFactory.create(layer, 800, 600, bpp, DisplayMode.WINDOWED, vsync, fsaa, this);
        this.setFocusable(true);
        this.isInitialized = true;
    }

    public Canvas3DJPanel(OpenGLLayer layer, int bpp, FSAA fsaa) {
        this(layer, bpp, fsaa, true);
    }

    public Canvas3DJPanel(OpenGLLayer layer, int bpp) {
        this(layer, bpp, FSAA.OFF);
    }

    public Canvas3DJPanel(OpenGLLayer layer) {
        this(layer, DisplayMode.getDefaultBPP());
    }

    public Canvas3DJPanel(int bpp, FSAA fsaa) {
        this(OpenGLLayer.JOGL_SWING, bpp, fsaa);
    }

    public Canvas3DJPanel(FSAA fsaa) {
        this(DisplayMode.getDefaultBPP(), fsaa);
    }

    public Canvas3DJPanel(int bpp) {
        this(bpp, FSAA.OFF);
    }

    public Canvas3DJPanel() {
        this(DisplayMode.getDefaultBPP());
    }

    public Canvas3DJPanel(CanvasConstructionInfo canvasInfo) {
        this(canvasInfo.getOpenGLLayer(), canvasInfo.getDisplayMode().getBPP(), canvasInfo.getFSAAMode());
    }
}

