/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.jagatoo.util.nio.BufferUtils;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.RenderTarget;
import org.xith3d.scenegraph.GroupNode;

public class ImageRenderTarget
implements RenderTarget {
    private GroupNode group;
    private ByteBuffer byteBuffer;
    private BufferedImage image;
    private Colorf backgroundColor = null;
    private boolean backgroundRenderingEnabled = false;

    public final void setGroup(GroupNode group) {
        if (group == null) {
            throw new NullPointerException("group must not be null");
        }
        this.group = group;
    }

    public final GroupNode getGroup() {
        return this.group;
    }

    public final void setImage(BufferedImage image) {
        if (image == null) {
            throw new NullPointerException("image must not be null");
        }
        this.image = image;
        this.byteBuffer = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 4);
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public final void setBackgroundColor(Colorf color) {
        this.backgroundColor = color;
    }

    public final Colorf getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundRenderingEnabled(boolean enabled) {
        this.backgroundRenderingEnabled = enabled;
    }

    public final boolean isBackgroundRenderingEnabled() {
        return this.backgroundRenderingEnabled;
    }

    public final void copyBufferToImage() {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int bytesPerRow = width * 4;
        int p = width * height * 4;
        for (int row = 0; row < height; ++row) {
            int q = p = row * bytesPerRow;
            for (int col = 0; col < width; ++col) {
                byte iR = this.byteBuffer.get(q++);
                byte iG = this.byteBuffer.get(q++);
                byte iB = this.byteBuffer.get(q++);
                byte iA = this.byteBuffer.get(q++);
                int pixelInt = 0xFF000000 | (iA & 0xFF) << 24 | (iR & 0xFF) << 16 | (iG & 0xFF) << 8 | iB & 0xFF;
                this.image.setRGB(col, height - row - 1, pixelInt);
            }
        }
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public final void freeOpenGLResources(Canvas3D canvas) {
    }

    public ImageRenderTarget(GroupNode group, Colorf backgroundColor) {
        if (group == null) {
            throw new NullPointerException("group must not be null");
        }
        this.group = group;
        this.backgroundColor = backgroundColor;
    }

    public ImageRenderTarget(GroupNode group) {
        this(group, null);
    }
}

