/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import org.xith3d.render.OpenGLInfo;

public class OpenGLCapabilities {
    private final int maxTextureSize;
    private final int maxTextureUnits;
    private final int maxAnisotropicLevel;
    private final int maxVertexAttributes;
    private final boolean isMinVersion13;
    private final boolean isMinVersion15;
    private final boolean supportsPlainMultiTexturing;
    private final boolean supportsVBOs;

    public final int getMaxTextureSize() {
        return this.maxTextureSize;
    }

    public final int getMaxTextureUnits() {
        return this.maxTextureUnits;
    }

    public final int getMaxAnisotropicLevel() {
        return this.maxAnisotropicLevel;
    }

    public final int getMaxVertexAttributes() {
        return this.maxVertexAttributes;
    }

    public final boolean isMinVersion13() {
        return this.isMinVersion13;
    }

    public final boolean isMinVersion15() {
        return this.isMinVersion15;
    }

    public final boolean supportsPlainMultiTexturing() {
        return this.supportsPlainMultiTexturing;
    }

    public final boolean supportsVBOs() {
        return this.supportsVBOs;
    }

    public OpenGLCapabilities(int maxTextureSize, int maxTextureUnits, int maxAnisotropicLevel, int maxVertexAttributes, OpenGLInfo glInfo) {
        this.maxTextureSize = maxTextureSize;
        this.maxTextureUnits = maxTextureUnits;
        this.maxAnisotropicLevel = maxAnisotropicLevel;
        this.maxVertexAttributes = maxVertexAttributes;
        this.isMinVersion13 = glInfo.getNormalizedVersion() >= OpenGLInfo.NORM_VERSION_1_3;
        this.isMinVersion15 = glInfo.getNormalizedVersion() >= OpenGLInfo.NORM_VERSION_1_5;
        this.supportsPlainMultiTexturing = glInfo.getKnwonVendor() != OpenGLInfo.KnownVendor.ATI && glInfo.getKnwonVendor() != OpenGLInfo.KnownVendor.INTEL && glInfo.getKnwonVendor() != OpenGLInfo.KnownVendor.MESA;
        this.supportsVBOs = glInfo.getKnwonVendor() != OpenGLInfo.KnownVendor.INTEL;
    }
}

