/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.config;

import java.awt.Dimension;
import java.awt.Toolkit;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;

public class CanvasConstructionInfo {
    private static final Dimension DESKTOP_RESOLUTION = Toolkit.getDefaultToolkit().getScreenSize();
    private OpenGLLayer layer;
    private DisplayMode dspMode;
    private DisplayMode.FullscreenMode fullscreenMode;
    private boolean vsync;
    private FSAA fsaa;
    private int depthBufferSize = 16;
    private String title;

    private static DisplayMode createDisplayMode(OpenGLLayer layer, int width, int height, int bpp) {
        assert (layer != null);
        DisplayModeSelector modeSelector = DisplayModeSelector.getImplementation(layer);
        DisplayMode displayMode = modeSelector.getBestMode(width, height, bpp, DisplayMode.getDefaultFrequency());
        if (displayMode == null) {
            displayMode = new DisplayMode(null, width, height, DisplayMode.getDefaultBPP(), DisplayMode.getDefaultFrequency());
        }
        return displayMode;
    }

    public void setOpenGLLayer(OpenGLLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer MUST NOT be null");
        }
        this.layer = layer;
    }

    public final OpenGLLayer getOpenGLLayer() {
        return this.layer;
    }

    public void setDisplayMode(DisplayMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode MUST NOT be null");
        }
        this.dspMode = mode;
    }

    public final DisplayMode getDisplayMode() {
        return this.dspMode;
    }

    public void setFullscreenMode(DisplayMode.FullscreenMode fullscreenMode) {
        this.fullscreenMode = fullscreenMode;
    }

    public final DisplayMode.FullscreenMode getFullscreenMode() {
        return this.fullscreenMode;
    }

    public void setVSyncEnabled(boolean vsync) {
        this.vsync = vsync;
    }

    public final boolean isVSyncEnabled() {
        return this.vsync;
    }

    public void setFSAAMode(FSAA fsaa) {
        this.fsaa = fsaa;
    }

    public final FSAA getFSAAMode() {
        return this.fsaa;
    }

    public void setDepthBufferSize(int depthBufferSize) {
        this.depthBufferSize = depthBufferSize;
    }

    public final int getDepthBufferSize() {
        return this.depthBufferSize;
    }

    public void setTitle(String title) {
        if (title == null) {
            this.setFullscreenMode(DisplayMode.FULLSCREEN);
        } else {
            this.setFullscreenMode(DisplayMode.WINDOWED);
        }
        this.title = title;
    }

    public final String getTitle() {
        return this.title;
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this.setOpenGLLayer(layer);
        this.setDisplayMode(dspMode);
        this.setTitle(title);
        this.setFullscreenMode(fullscreen);
        this.setVSyncEnabled(vsync);
        this.setFSAAMode(fsaa);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(layer, dspMode, fullscreen, DisplayMode.VSYNC_ENABLED, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(layer, dspMode, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, String title) {
        this(layer, dspMode, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(CanvasConstructionInfo.extractOpenGLLayer(dspMode), dspMode, fullscreen, vsync, fsaa, title);
    }

    private static final OpenGLLayer extractOpenGLLayer(DisplayMode dspMode) {
        if (dspMode.getNativeMode() == null) {
            return OpenGLLayer.getDefault();
        }
        if (dspMode.getNativeMode().getClass().getName().contains("lwjgl")) {
            return OpenGLLayer.LWJGL;
        }
        return OpenGLLayer.getDefault();
    }

    public CanvasConstructionInfo(DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(CanvasConstructionInfo.extractOpenGLLayer(dspMode), dspMode, fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(dspMode, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, String title) {
        this(dspMode, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.createDisplayMode(layer, width, height, bpp), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.createDisplayMode(layer, width, height, bpp), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(layer, width, height, bpp, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, String title) {
        this(layer, width, height, bpp, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, bpp, fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, bpp, fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(width, height, bpp, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, String title) {
        this(width, height, bpp, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(layer, width, height, DisplayMode.getDefaultBPP(), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(layer, width, height, DisplayMode.getDefaultBPP(), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(layer, width, height, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, String title) {
        this(layer, width, height, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(width, height, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, DisplayMode.FullscreenMode fullscreen, String title) {
        this(width, height, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.DESKTOP_RESOLUTION.width, CanvasConstructionInfo.DESKTOP_RESOLUTION.height, DisplayMode.getDefaultBPP(), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.DESKTOP_RESOLUTION.width, CanvasConstructionInfo.DESKTOP_RESOLUTION.height, DisplayMode.getDefaultBPP(), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(layer, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, DisplayMode.FullscreenMode fullscreen, String title) {
        this(layer, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        this(fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(DisplayMode.FullscreenMode fullscreen, String title) {
        this(fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean vsync, FSAA fsaa) {
        this(layer, DisplayMode.WINDOWED, vsync, fsaa, "Powered by Xith3D");
    }

    public CanvasConstructionInfo(OpenGLLayer layer, FSAA fsaa) {
        this(layer, DisplayMode.WINDOWED, fsaa, "Powered by Xith3D");
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean vsync) {
        this(layer, vsync, FSAA.OFF);
    }

    public CanvasConstructionInfo(OpenGLLayer layer) {
        this(layer, FSAA.OFF);
    }

    public CanvasConstructionInfo(boolean vsync, FSAA fsaa) {
        this(OpenGLLayer.getDefault(), vsync, fsaa);
    }

    public CanvasConstructionInfo(FSAA fsaa) {
        this(OpenGLLayer.getDefault(), fsaa);
    }

    public CanvasConstructionInfo(boolean vsync) {
        this(vsync, FSAA.OFF);
    }

    public CanvasConstructionInfo() {
        this(FSAA.OFF);
    }
}

