/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.Gamma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.TraceGL;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.impl.awt.AWTCursorConverter;
import org.jagatoo.input.impl.mixed.AWTJInputInputDeviceFactory;
import org.jagatoo.input.render.Cursor;
import org.jagatoo.logging.ProfileTimer;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.OldStyleGLCapabilitiesChooser;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasPeerImplAWT
extends CanvasPeerImplBase
implements GLEventListener {
    private static final int RENDER_MODE_CLEAR = 1;
    private static final int RENDER_MODE_DESTROY = 2;
    private GLCapabilities gc;
    private GLCapabilitiesChooser gcc;
    private GLCanvas glCanvas;
    private GL gl;
    private GL plainGL;
    private View view;
    private List<RenderPass> renderPasses;
    private boolean layeredMode;
    private long frameId;
    private long nanoTime;
    private long nanoStep;
    private PickRequest pickRequest = null;
    private Object pickResult = null;
    private int renderMode = 0;
    private boolean isRendering = false;
    private Frame window;
    private boolean closeRequested = false;
    private AWTJInputInputDeviceFactory inputDeviceFactory = null;

    @Override
    public AWTJInputInputDeviceFactory getInputDeviceFactory(InputSystem inputSystem) {
        if (this.inputDeviceFactory == null) {
            this.inputDeviceFactory = new AWTJInputInputDeviceFactory(this, inputSystem.getEventQueue());
        }
        return this.inputDeviceFactory;
    }

    @Override
    public final GLCanvas getDrawable() {
        return this.glCanvas;
    }

    @Override
    public void refreshCursor(Mouse mouse) {
        if (!mouse.isAbsolute() || this.getCursor() == null) {
            this.glCanvas.setCursor(AWTCursorConverter.HIDDEN_CURSOR);
        } else if (this.getCursor() == Cursor.DEFAULT_CURSOR) {
            this.glCanvas.setCursor(java.awt.Cursor.getDefaultCursor());
        } else {
            AWTCursorConverter.convertCursor(this.getCursor());
            this.glCanvas.setCursor((java.awt.Cursor)this.getCursor().getCursorObject());
        }
    }

    @Override
    public final boolean receivesInputEvents() {
        return this.glCanvas.hasFocus();
    }

    public CanvasPeerImplAWT(Object owner, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
        try {
            System.setProperty("org.xith3d.render.jsr231.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        this.gc = new GLCapabilities();
        this.gc.setStencilBits(8);
        this.gc.setDepthBits(depthBufferSize);
        if (fsaa != FSAA.OFF) {
            this.gc.setSampleBuffers(true);
        }
        this.gc.setNumSamples(fsaa.getIntValue());
        this.gcc = new OldStyleGLCapabilitiesChooser();
        this.glCanvas = new GLCanvas(this.gc, this.gcc, null, null);
        this.glCanvas.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
        this.setVSyncEnabled(vsync);
        this.glCanvas.addGLEventListener(this);
        this.glCanvas.setFocusable(true);
        this.gl = this.glCanvas.getGL();
        this.updateTraceDebug();
        this.clear();
        Point upperLeft = null;
        if (owner == null) {
            Frame frame = new Frame("Xith3D (JOGL)");
            frame.setLayout(null);
            if (fullscreen.isFullscreen()) {
                frame.setBackground(Color.BLACK);
            }
            frame.setUndecorated(fullscreen != DisplayMode.FullscreenMode.WINDOWED);
            frame.setSize(displayMode.getWidth(), displayMode.getHeight());
            this.window = frame;
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    CanvasPeerImplAWT.this.closeRequested = true;
                }
            });
            boolean exclusive = fullscreen.isFullscreen() && displayMode.getNativeMode() != null;
            frame.add(this.glCanvas);
            frame.setVisible(true);
            if (!exclusive) {
                Dimension frameSize;
                Thread.yield();
                if (!fullscreen.isFullscreen()) {
                    Insets insets = frame.getInsets();
                    this.glCanvas.setLocation(insets.left, insets.top);
                    frameSize = new Dimension(displayMode.getWidth() + insets.left + insets.right, displayMode.getHeight() + insets.top + insets.bottom);
                    frame.setSize(frameSize);
                } else {
                    frameSize = new Dimension(displayMode.getWidth(), displayMode.getHeight());
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                upperLeft = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                frame.setLocation(upperLeft);
            } else {
                java.awt.DisplayMode awtMode = (java.awt.DisplayMode)displayMode.getNativeMode();
                GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                graphDev.setFullScreenWindow(frame);
                graphDev.setDisplayMode(awtMode);
            }
        } else {
            this.glCanvas.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            ((Container)owner).add(this.glCanvas);
        }
        Thread.yield();
        if (owner == null) {
            this.window.setResizable(false);
            Dimension size = this.window.getSize();
            this.window.setSize(size.width - 2, size.height - 2);
            Thread.yield();
            if (this.window.getLocation().x == 0 && this.window.getLocation().y == 0 && upperLeft != null) {
                this.window.setLocation(upperLeft);
            }
        }
    }

    protected void updateTraceDebug() {
        if (!(this.gl instanceof DebugGL) && !(this.gl instanceof TraceGL)) {
            this.plainGL = this.gl;
        }
        boolean needsDebugGL = this.getRenderPeer().getRenderOptions().areGLErrorChecksEnabled();
        boolean needsTraceGL = this.getRenderPeer().getRenderOptions().isGLTracingEnabled();
        if (needsTraceGL && needsDebugGL && !(this.gl instanceof TraceGL)) {
            X3DLog.debug("OpenGL error check and command tracing are enabled");
            this.gl = new TraceGL(new DebugGL(this.plainGL), System.err);
        } else if (needsTraceGL && !(this.gl instanceof TraceGL)) {
            X3DLog.debug("OpenGL command tracing is enabled");
            this.gl = new TraceGL(this.plainGL, System.err);
        } else if (needsDebugGL && !(this.gl instanceof DebugGL)) {
            X3DLog.debug("OpenGL error check is enabled");
            this.gl = new DebugGL(this.plainGL);
        } else {
            this.gl = this.plainGL;
        }
        this.glCanvas.setGL(this.gl);
    }

    @Override
    public final void init(GLAutoDrawable drawable) {
        this.gl = this.glCanvas.getGL();
        this.updateTraceDebug();
        this.destroyGLNames(false);
        super.init();
    }

    @Override
    public OpenGLLayer getType() {
        return OpenGLLayer.JOGL_AWT;
    }

    @Override
    public void setVSyncEnabled(boolean vsync) {
        super.setVSyncEnabled(vsync);
        this.setSwapInterval(vsync ? 1 : 0);
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public final Frame getWindow() {
        return this.window;
    }

    @Override
    public final Component getComponent() {
        return this.glCanvas;
    }

    @Override
    public void setIcon(URL iconResource) throws IOException {
        if (this.window == null) {
            return;
        }
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        this.window.setIconImage(ImageIO.read(iconResource));
    }

    @Override
    public final void setTitle(String title) {
        if (this.window == null) {
            return;
        }
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        this.window.setTitle(title);
    }

    @Override
    public final String getTitle() {
        if (this.window == null) {
            return null;
        }
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        return this.window.getTitle();
    }

    @Override
    public final boolean setLocation(int x, int y) {
        if (this.window == null) {
            return false;
        }
        if (this.window.getLocation().x == x && this.window.getLocation().y == y) {
            return false;
        }
        this.window.setLocation(x, y);
        return true;
    }

    @Override
    public final int getLeft() {
        return this.glCanvas.getLocationOnScreen().x;
    }

    @Override
    public final int getTop() {
        return this.glCanvas.getLocationOnScreen().y;
    }

    @Override
    public final boolean setSize(int width, int height) {
        if (this.glCanvas.getSize().width != width || this.glCanvas.getSize().height != height) {
            this.glCanvas.setSize(width, height);
            if (this.window != null) {
                Insets insets = this.window.getInsets();
                this.glCanvas.setLocation(insets.left, insets.top);
                Dimension frameSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                this.window.setSize(frameSize);
            }
            this.setDisplayMode(new DisplayMode(this.getType(), null, width, height, this.getBPP(), this.getFrequency()));
            return true;
        }
        return false;
    }

    @Override
    public final int getWidth() {
        return this.glCanvas.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.glCanvas.getHeight();
    }

    @Override
    public final boolean setFullscreen(boolean fullscreen) {
        if (this.window == null) {
            return false;
        }
        boolean oldState = super.setFullscreen(fullscreen);
        if (this.getFullscreenSwitchRequest() != null) {
            boolean exclusive;
            boolean newFSMode = this.getFullscreenSwitchRequest();
            boolean bl = exclusive = newFSMode && this.getDisplayMode().getNativeMode() != null;
            if (!exclusive) {
                Dimension frameSize;
                GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                graphDev.setFullScreenWindow(null);
                Thread.yield();
                if (!newFSMode) {
                    Insets insets = this.window.getInsets();
                    this.glCanvas.setLocation(insets.left, insets.top);
                    frameSize = new Dimension(this.getWidth() + insets.left + insets.right, this.getHeight() + insets.top + insets.bottom);
                    this.window.setSize(frameSize);
                } else {
                    frameSize = new Dimension(this.getWidth(), this.getHeight());
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Point upperLeft = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                this.window.setLocation(upperLeft);
            } else {
                java.awt.DisplayMode awtMode = (java.awt.DisplayMode)this.getDisplayMode().getNativeMode();
                GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                graphDev.setFullScreenWindow(this.window);
                graphDev.setDisplayMode(awtMode);
            }
            if (!newFSMode) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
            }
            this.resetFullscreenSwitchRequest();
        }
        return oldState;
    }

    @Override
    protected boolean setDisplayModeImpl(DisplayMode displayMode) {
        boolean result = true;
        this.setSize(displayMode.getWidth(), displayMode.getHeight());
        return true;
    }

    @Override
    public final void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.gl = drawable.getGL();
        this.updateTraceDebug();
    }

    @Override
    public void setGamma(float gamma, float brightness, float contrast) {
        super.setGamma(gamma, brightness, contrast);
        try {
            Gamma.setDisplayGamma(gamma, brightness, contrast);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public final void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    @Override
    protected void setAutoSwapBufferMode(boolean mode) {
        this.glCanvas.setAutoSwapBufferMode(mode);
    }

    @Override
    public final boolean isRendering() {
        return this.isRendering;
    }

    @Override
    public void beforeThreadChanged() {
    }

    @Override
    public final void display(GLAutoDrawable drawable) {
        if (!this.isInitialized() || this.isRendering) {
            return;
        }
        this.isRendering = true;
        ShapeAtomPeer.reset();
        if (this.closeRequested) {
            this.closeRequested = false;
            this.fireClosingEvent();
        }
        this.gl = drawable.getGL();
        this.updateTraceDebug();
        if (this.swapIntervalChanged) {
            this.swapIntervalChanged = false;
            this.gl.setSwapInterval(this.getSwapInterval());
        }
        if (this.renderMode != 0) {
            boolean proceed = true;
            if ((this.renderMode & 1) != 0) {
                super.clear();
                this.isRendering = false;
                proceed = false;
            }
            if ((this.renderMode & 2) != 0) {
                this.destroy();
                this.isRendering = false;
                proceed = false;
            }
            if (!proceed) {
                return;
            }
        }
        this.pickResult = this.doRender(this.view, this.renderPasses, this.layeredMode, this.frameId, this.nanoTime, this.nanoStep, this.pickRequest);
        this.isRendering = false;
    }

    @Override
    protected Object initRenderingImpl(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "CanvasPeerImpl::initRendering");
        this.renderMode = 0;
        this.view = view;
        this.renderPasses = renderPasses;
        this.layeredMode = layeredMode;
        this.frameId = frameId;
        this.nanoTime = nanoTime;
        this.nanoStep = nanoStep;
        this.pickRequest = pickRequest;
        this.pickResult = null;
        this.glCanvas.display();
        Object result = this.pickResult;
        this.pickResult = null;
        ProfileTimer.endProfile();
        return result;
    }

    @Override
    public void clear() {
        this.renderMode |= 1;
        this.glCanvas.display();
    }

    @Override
    public void destroy() {
        if ((this.renderMode & 2) == 0) {
            GLContext context;
            this.renderMode |= 3;
            if (this.isGammaChanged) {
                try {
                    Gamma.resetDisplayGamma();
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            if ((context = this.glCanvas.getContext()).makeCurrent() != 0) {
                context.release();
                context.destroy();
            }
            this.glCanvas.display();
        } else {
            super.destroy();
            if (this.getWindow() != null) {
                this.getWindow().dispose();
            }
        }
    }
}

