/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.Gamma;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.impl.awt.AWTCursorConverter;
import org.jagatoo.input.impl.mixed.AWTJInputInputDeviceFactory;
import org.jagatoo.input.render.Cursor;
import org.jagatoo.logging.ProfileTimer;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.OldStyleGLCapabilitiesChooser;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasPeerImplSwing
extends CanvasPeerImplBase
implements GLEventListener {
    private static final int RENDER_MODE_CLEAR = 1;
    private static final int RENDER_MODE_DESTROY = 2;
    private GLCapabilities gc;
    private GLCapabilitiesChooser gcc;
    private GLJPanel glJPanel;
    private GL gl;
    private View view;
    private List<RenderPass> renderPasses;
    private boolean layeredMode;
    private long frameId;
    private long nanoTime;
    private long nanoStep;
    private PickRequest pickRequest = null;
    private Object pickResult = null;
    private int renderMode = 0;
    private Window window;
    private boolean closeRequested = false;
    private boolean isRendering = false;
    private AWTJInputInputDeviceFactory inputDeviceFactory = null;

    @Override
    public AWTJInputInputDeviceFactory getInputDeviceFactory(InputSystem inputSystem) {
        if (this.inputDeviceFactory == null) {
            this.inputDeviceFactory = new AWTJInputInputDeviceFactory(this, inputSystem.getEventQueue());
        }
        return this.inputDeviceFactory;
    }

    @Override
    public final GLJPanel getDrawable() {
        return this.glJPanel;
    }

    @Override
    public void refreshCursor(Mouse mouse) {
        if (this.getCursor() == null) {
            this.glJPanel.setCursor(AWTCursorConverter.HIDDEN_CURSOR);
        } else if (this.getCursor() == Cursor.DEFAULT_CURSOR) {
            this.glJPanel.setCursor(java.awt.Cursor.getDefaultCursor());
        } else {
            AWTCursorConverter.convertCursor(this.getCursor());
            this.glJPanel.setCursor((java.awt.Cursor)this.getCursor().getCursorObject());
        }
    }

    @Override
    public final boolean receivesInputEvents() {
        return this.glJPanel.hasFocus();
    }

    public CanvasPeerImplSwing(Object owner, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
        if (owner == null) {
            String message = "The " + this.getClass().getSimpleName() + " must be used with an owner (integrated into an AWT/Swing environment).";
            X3DLog.error(message);
            throw new Error(message);
        }
        try {
            System.setProperty("org.xith3d.render.jsr231.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        this.gc = new GLCapabilities();
        this.gc.setStencilBits(8);
        this.gc.setDepthBits(depthBufferSize);
        if (fsaa != FSAA.OFF) {
            this.gc.setSampleBuffers(true);
        }
        this.gc.setNumSamples(fsaa.getIntValue());
        this.gcc = new OldStyleGLCapabilitiesChooser();
        this.glJPanel = new GLJPanel(this.gc, this.gcc, null);
        this.glJPanel.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
        this.setVSyncEnabled(vsync);
        this.glJPanel.addGLEventListener(this);
        this.glJPanel.setFocusable(true);
        this.clear();
        this.glJPanel.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
        ((Container)owner).add(this.glJPanel);
        Thread.yield();
    }

    @Override
    public final void init(GLAutoDrawable drawable) {
        this.gl = this.glJPanel.getGL();
        this.destroyGLNames(false);
        super.init();
    }

    @Override
    public OpenGLLayer getType() {
        return OpenGLLayer.JOGL_SWING;
    }

    @Override
    public void setVSyncEnabled(boolean vsync) {
        super.setVSyncEnabled(vsync);
        this.setSwapInterval(vsync ? 1 : 0);
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public final Window getWindow() {
        return this.window;
    }

    @Override
    public final Component getComponent() {
        return this.glJPanel;
    }

    @Override
    public void setIcon(URL iconResource) throws IOException {
        if (this.window == null) {
            return;
        }
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        ((Frame)this.window).setIconImage(ImageIO.read(iconResource));
    }

    @Override
    public final void setTitle(String title) {
        if (this.window == null) {
            return;
        }
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        ((Frame)this.window).setTitle(title);
    }

    @Override
    public final String getTitle() {
        if (this.window == null) {
            return null;
        }
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        return ((Frame)this.window).getTitle();
    }

    @Override
    public final boolean setLocation(int x, int y) {
        if (this.window == null) {
            return false;
        }
        if (this.window.getLocation().x == x && this.window.getLocation().y == y) {
            return false;
        }
        this.window.setLocation(x, y);
        return true;
    }

    @Override
    public final int getLeft() {
        return this.glJPanel.getLocationOnScreen().x;
    }

    @Override
    public final int getTop() {
        return this.glJPanel.getLocationOnScreen().y;
    }

    @Override
    public final boolean setSize(int width, int height) {
        if (this.glJPanel.getSize().width != width || this.glJPanel.getSize().height != height) {
            this.glJPanel.setSize(width, height);
            if (this.window != null) {
                Insets insets = this.window.getInsets();
                this.glJPanel.setLocation(insets.left, insets.top);
                Dimension frameSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                this.window.setSize(frameSize);
            }
            this.setDisplayMode(new DisplayMode(this.getType(), null, width, height, this.getBPP(), this.getFrequency()));
            return true;
        }
        return false;
    }

    @Override
    public final int getWidth() {
        return this.glJPanel.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.glJPanel.getHeight();
    }

    @Override
    protected boolean setDisplayModeImpl(DisplayMode displayMode) {
        boolean result = true;
        this.setSize(displayMode.getWidth(), displayMode.getHeight());
        return true;
    }

    @Override
    public final void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        _SG_PrivilegedAccess.incGlobalOptionsChangeId();
        this.gl = drawable.getGL();
    }

    @Override
    public void setGamma(float gamma, float brightness, float contrast) {
        super.setGamma(gamma, brightness, contrast);
        try {
            Gamma.setDisplayGamma(gamma, brightness, contrast);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public final void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    @Override
    protected void setAutoSwapBufferMode(boolean mode) {
        this.glJPanel.setAutoSwapBufferMode(mode);
    }

    @Override
    public final boolean isRendering() {
        return this.isRendering;
    }

    @Override
    public void beforeThreadChanged() {
    }

    @Override
    public final void display(GLAutoDrawable drawable) {
        if (!this.isInitialized() || this.isRendering) {
            return;
        }
        this.isRendering = true;
        ShapeAtomPeer.reset();
        if (this.closeRequested) {
            this.closeRequested = false;
            this.fireClosingEvent();
        }
        this.gl = drawable.getGL();
        if (this.swapIntervalChanged) {
            this.swapIntervalChanged = false;
            this.gl.setSwapInterval(this.getSwapInterval());
        }
        if (this.renderMode != 0) {
            boolean proceed = true;
            if ((this.renderMode & 1) != 0) {
                super.clear();
                this.isRendering = false;
                proceed = false;
            }
            if ((this.renderMode & 2) != 0) {
                this.destroy();
                this.isRendering = false;
                proceed = false;
            }
            if (!proceed) {
                return;
            }
        }
        this.pickResult = this.doRender(this.view, this.renderPasses, this.layeredMode, this.frameId, this.nanoTime, this.nanoStep, this.pickRequest);
        this.isRendering = false;
    }

    @Override
    protected Object initRenderingImpl(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "CanvasPeerImpl::initRendering");
        this.renderMode = 0;
        this.view = view;
        this.renderPasses = renderPasses;
        this.layeredMode = layeredMode;
        this.frameId = frameId;
        this.nanoTime = nanoTime;
        this.nanoStep = nanoStep;
        this.pickRequest = pickRequest;
        this.pickResult = null;
        this.glJPanel.display();
        Object result = this.pickResult;
        this.pickResult = null;
        ProfileTimer.endProfile();
        return result;
    }

    @Override
    public void clear() {
        this.renderMode |= 1;
        this.glJPanel.display();
    }

    @Override
    public void destroy() {
        if ((this.renderMode & 2) == 0) {
            this.renderMode |= 3;
            if (this.isGammaChanged) {
                try {
                    Gamma.resetDisplayGamma();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.glJPanel.display();
        } else {
            super.destroy();
            if (this.getWindow() != null) {
                this.getWindow().dispose();
            }
        }
    }
}

