/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import javax.media.opengl.GL;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.ColoringStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColoringStateUnitPeer
implements StateUnitPeer {
    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "ColoringStateUnitPeer::apply()");
        GL gl = (GL)glObj;
        ColoringAttributes ca = ((ColoringStateUnit)stateUnit).getColoringAttributes();
        Colorf color = ca.getColor();
        TransparencyAttributes m = ((ColoringStateUnit)stateUnit).getTransparencyAttributes();
        if (m.getMode() == TransparencyAttributes.BLENDED && m.isEnabled()) {
            if (!statesCache.enabled || !statesCache.blendingEnabled) {
                X3DLog.debug("Blending enabled");
                gl.glEnable(3042);
                statesCache.blendingEnabled = true;
            }
            gl.glBlendFunc(m.getSrcBlendFunction().toOpenGL(), m.getDstBlendFunction().toOpenGL());
            gl.glColor4f(color.getRed(), color.getGreen(), color.getBlue(), 1.0f - m.getTransparency());
            statesCache.color.set(color);
        } else {
            if (!statesCache.enabled || statesCache.blendingEnabled) {
                X3DLog.debug("Blending disabled");
                gl.glDisable(3042);
                statesCache.blendingEnabled = false;
            }
            gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
            statesCache.color.set(color.getRed(), color.getGreen(), color.getBlue());
        }
        gl.glShadeModel(ca.getShadeModel().toOpenGL());
        ProfileTimer.endProfile();
    }
}

