/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import javax.media.opengl.GL;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.PolygonAttribsStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonAttribsStateUnitPeer
implements StateUnitPeer {
    public static final void enablePolygonOffset(GL gl, DrawMode mode, OpenGLStatesCache statesCache, boolean enable) {
        if (mode == DrawMode.FILL) {
            if (!(!enable || statesCache.enabled && statesCache.polygonOffsetFillEnabled)) {
                gl.glEnable(32823);
                statesCache.polygonOffsetFillEnabled = true;
            } else if (!(enable || statesCache.enabled && !statesCache.polygonOffsetFillEnabled)) {
                gl.glDisable(32823);
                statesCache.polygonOffsetFillEnabled = false;
            }
        } else if (mode == DrawMode.LINE) {
            if (!(!enable || statesCache.enabled && statesCache.polygonOffsetLineEnabled)) {
                gl.glEnable(10754);
                statesCache.polygonOffsetLineEnabled = true;
            } else if (!(enable || statesCache.enabled && !statesCache.polygonOffsetLineEnabled)) {
                gl.glDisable(10754);
                statesCache.polygonOffsetLineEnabled = false;
            }
        } else if (mode == DrawMode.POINT) {
            if (!(!enable || statesCache.enabled && statesCache.polygonOffsetPointEnabled)) {
                gl.glEnable(10753);
                statesCache.polygonOffsetPointEnabled = true;
            } else if (!(enable || statesCache.enabled && !statesCache.polygonOffsetPointEnabled)) {
                gl.glDisable(10753);
                statesCache.polygonOffsetPointEnabled = false;
            }
        }
    }

    public static final void setCullMode(GL gl, OpenGLStatesCache statesCache, int mode, boolean enable, boolean isPickMode) {
        if (isPickMode) {
            switch (mode) {
                case 1028: {
                    gl.glCullFace(1028);
                    break;
                }
                case 1029: {
                    gl.glCullFace(1029);
                    break;
                }
            }
        } else {
            switch (mode) {
                case 1028: {
                    gl.glCullFace(1028);
                    break;
                }
                case 1029: {
                    gl.glCullFace(1029);
                    break;
                }
            }
            if (!(!enable || statesCache.enabled && statesCache.cullFaceEnabled)) {
                gl.glEnable(2884);
            } else if (!(enable || statesCache.enabled && !statesCache.cullFaceEnabled)) {
                gl.glDisable(2884);
            }
            statesCache.cullFaceEnabled = enable;
        }
    }

    public static final boolean setCullMode(GL gl, OpenGLStatesCache statesCache, FaceCullMode mode, boolean autoEnable, boolean isPickMode) {
        Boolean enable;
        if (isPickMode) {
            switch (mode) {
                case NONE: {
                    gl.glCullFace(1029);
                    break;
                }
                case FRONT: {
                    gl.glCullFace(1028);
                    break;
                }
                case BACK: {
                    gl.glCullFace(1029);
                    break;
                }
            }
            return false;
        }
        boolean result = false;
        if (autoEnable) {
            result = statesCache.cullFaceEnabled;
        }
        switch (mode) {
            case NONE: {
                enable = false;
                break;
            }
            case FRONT: {
                gl.glCullFace(1028);
                enable = true;
                break;
            }
            case BACK: {
                gl.glCullFace(1029);
                enable = true;
                break;
            }
            default: {
                enable = null;
            }
        }
        if (enable != null) {
            if (!(!enable.booleanValue() || statesCache.enabled && statesCache.cullFaceEnabled)) {
                gl.glEnable(2884);
            } else if (!(enable.booleanValue() || statesCache.enabled && !statesCache.cullFaceEnabled)) {
                gl.glDisable(2884);
            }
            statesCache.cullFaceEnabled = enable;
        }
        return result;
    }

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "PolygonAttribsStateUnitPeer::apply()");
        GL gl = (GL)glObj;
        PolygonAttributes pa = ((PolygonAttribsStateUnit)stateUnit).getPolygonAttributes();
        DrawMode mode = options.isWireframeModeEnabled() ? DrawMode.LINE : pa.getDrawMode();
        gl.glPolygonMode(1032, mode.toOpenGL());
        float pOfs = pa.getPolygonOffset();
        float pOfsFactor = pa.getPolygonOffsetFactor();
        if (pOfs == 0.0f && pOfsFactor == 0.0f) {
            PolygonAttribsStateUnitPeer.enablePolygonOffset(gl, pa.getDrawMode(), statesCache, false);
        } else {
            gl.glPolygonOffset(pOfsFactor, pOfs);
            PolygonAttribsStateUnitPeer.enablePolygonOffset(gl, pa.getDrawMode(), statesCache, true);
        }
        PolygonAttribsStateUnitPeer.setCullMode(gl, statesCache, pa.getFaceCullMode(), true, renderMode == RenderPeer.RenderMode.PICKING);
        if (!(!pa.isPolygonAntialiasingEnabled() || statesCache.enabled && statesCache.polygonSmoothEnabled)) {
            gl.glEnable(2881);
        } else if (!(pa.isPolygonAntialiasingEnabled() || statesCache.enabled && !statesCache.polygonSmoothEnabled)) {
            gl.glDisable(2881);
        }
        statesCache.polygonSmoothEnabled = pa.isPolygonAntialiasingEnabled();
        ProfileTimer.endProfile();
    }
}

