/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import org.jagatoo.geometry.GeomNioData;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderAtomPeer;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.jsr231.BoundsAtomPeer;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.DisplayListRenderPeer;
import org.xith3d.render.jsr231.PolygonAttribsStateUnitPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Billboard;
import org.xith3d.scenegraph.GeomNioFloatData;
import org.xith3d.scenegraph.GeomNioIntData;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GeometryStripArray;
import org.xith3d.scenegraph.IndexedGeometryArray;
import org.xith3d.scenegraph.IndexedGeometryStripArray;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeAtomPeer
extends RenderAtomPeer {
    private static final int OPT_AUTO_MAX_FRAMES = 10;
    private static final int CARE_MAP_COORDINATES = 1;
    private static final int CARE_MAP_NORMALS = 2;
    private static final int CARE_MAP_COLORS = 4;
    private static final int CARE_MAP_TEXTURE_COORDS = 8;
    private static final int CARE_MAP_VERTEX_ATTRIBS = 16;
    private static final int CARE_MAP_INDICES = 32;
    protected static final int CARE_MAP_ALL = 63;
    private static final IntBuffer tmpIntBuffer = BufferUtil.newIntBuffer(1);
    private static FloatBuffer matrixBuffer = BufferUtil.newFloatBuffer(16);
    private static Transform3D lastTransform = null;
    private static SceneGraphOpenGLReferences.Provider vboNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    GL gl = ((CanvasPeerImplBase)this.getContext()).getGL();
                    tmpIntBuffer.clear();
                    tmpIntBuffer.put(name).rewind();
                    if (this.getContext().getOpenGLCapabilities().isMinVersion15()) {
                        gl.glDeleteBuffers(1, tmpIntBuffer);
                    } else {
                        gl.glDeleteBuffersARB(1, tmpIntBuffer);
                    }
                }
            };
        }
    };

    public static final void reset() {
        lastTransform = null;
    }

    protected static final void setMatrix(GL gl, View view, Transform3D transform, boolean ignoreRotation, boolean forced) {
        if (lastTransform == transform && !forced) {
            return;
        }
        lastTransform = transform;
        gl.glLoadMatrixf(_SG_PrivilegedAccess.getFloatBuffer(view.getModelViewTransform(false), true));
        if (!ignoreRotation) {
            gl.glMultMatrixf(_SG_PrivilegedAccess.getFloatBuffer(transform, true));
        } else {
            Matrix4f mat = transform.getMatrix4f();
            matrixBuffer.clear();
            matrixBuffer.put(1.0f);
            matrixBuffer.put(0.0f);
            matrixBuffer.put(0.0f);
            matrixBuffer.put(mat.m30());
            matrixBuffer.put(0.0f);
            matrixBuffer.put(1.0f);
            matrixBuffer.put(0.0f);
            matrixBuffer.put(mat.m31());
            matrixBuffer.put(0.0f);
            matrixBuffer.put(0.0f);
            matrixBuffer.put(1.0f);
            matrixBuffer.put(mat.m32());
            matrixBuffer.put(mat.m03());
            matrixBuffer.put(mat.m13());
            matrixBuffer.put(mat.m23());
            matrixBuffer.put(mat.m33());
            matrixBuffer.flip();
            gl.glMultMatrixf(matrixBuffer);
        }
    }

    private static final VBOMode getTexCoordVBOMode(Geometry.Optimization optimization) {
        switch (optimization) {
            case USE_VBOS: 
            case USE_VBO_FOR_TEXTURE_COORDINATES: {
                return VBOMode.ALWAYS;
            }
            case NONE: 
            case USE_DISPLAY_LISTS: 
            case USE_VBO_FOR_VERTEX_DATA: {
                return VBOMode.NEVER;
            }
        }
        return VBOMode.AUTO;
    }

    private static final VBOMode getGeomVBOMode(Geometry.Optimization optimization) {
        switch (optimization) {
            case USE_VBOS: 
            case USE_VBO_FOR_VERTEX_DATA: {
                return VBOMode.ALWAYS;
            }
            case USE_VBO_FOR_TEXTURE_COORDINATES: 
            case NONE: 
            case USE_DISPLAY_LISTS: {
                return VBOMode.NEVER;
            }
        }
        return VBOMode.AUTO;
    }

    private static final Boolean vboModeToBool(VBOMode vboMode, GeomNioData data) {
        switch (vboMode) {
            case ALWAYS: {
                return Boolean.TRUE;
            }
            case NEVER: {
                return Boolean.FALSE;
            }
        }
        return _SG_PrivilegedAccess.getFramesSinceDirty(data) >= 10;
    }

    private static final void bindArrayVBO(GL gl, int vbo, OpenGLStatesCache statesCache, boolean glVBOsSupported, boolean arbVBOsSupported) {
        if (statesCache.enabled && statesCache.currentBoundArrayVBO == vbo || !glVBOsSupported && !arbVBOsSupported) {
            return;
        }
        if (glVBOsSupported) {
            gl.glBindBuffer(34962, vbo);
        } else {
            gl.glBindBufferARB(34962, vbo);
        }
        statesCache.currentBoundArrayVBO = vbo;
    }

    private static final void bindIndexVBO(GL gl, int vbo, OpenGLStatesCache statesCache, boolean glVBOsSupported, boolean arbVBOsSupported) {
        if (statesCache.enabled && statesCache.currentBoundElementVBO == vbo || !glVBOsSupported && !arbVBOsSupported) {
            return;
        }
        if (glVBOsSupported) {
            gl.glBindBuffer(34963, vbo);
        } else {
            gl.glBindBufferARB(34963, vbo);
        }
        statesCache.currentBoundElementVBO = vbo;
    }

    private static final void createAndBindVBO(GL gl, CanvasPeer canvasPeer, GeomNioData data, int arrayType, OpenGLStatesCache statesCache, boolean glVBOsSupported, boolean arbVBOsSupported) {
        SceneGraphOpenGLReference openGLRef = data instanceof GeomNioFloatData ? ((GeomNioFloatData)data).getOpenGLReferences().getReference(canvasPeer, vboNameProvider) : ((GeomNioIntData)data).getOpenGLReferences().getReference(canvasPeer, vboNameProvider);
        int cacheHandle = openGLRef.getName();
        boolean newHandle = false;
        if (cacheHandle == -1) {
            tmpIntBuffer.clear();
            if (glVBOsSupported) {
                gl.glGenBuffers(1, tmpIntBuffer);
            } else if (arbVBOsSupported) {
                gl.glGenBuffersARB(1, tmpIntBuffer);
            }
            cacheHandle = tmpIntBuffer.get(0);
            openGLRef.setName(cacheHandle);
            newHandle = true;
        }
        if (arrayType == 0) {
            ShapeAtomPeer.bindIndexVBO(gl, cacheHandle, statesCache, glVBOsSupported, arbVBOsSupported);
        } else {
            ShapeAtomPeer.bindArrayVBO(gl, cacheHandle, statesCache, glVBOsSupported, arbVBOsSupported);
        }
        if (_SG_PrivilegedAccess.isDirty(data) || newHandle) {
            if (arrayType == 0) {
                IntBuffer buffer = ((GeomNioIntData)data).getBuffer();
                buffer.rewind();
                if (glVBOsSupported) {
                    gl.glBufferData(34963, buffer.capacity() * 4, buffer, 35044);
                } else if (arbVBOsSupported) {
                    gl.glBufferDataARB(34963, buffer.capacity() * 4, buffer, 35044);
                }
            } else {
                FloatBuffer buffer = ((GeomNioFloatData)data).getBuffer();
                buffer.rewind();
                if (glVBOsSupported) {
                    gl.glBufferData(34962, buffer.capacity() * 4, buffer, 35044);
                } else if (glVBOsSupported) {
                    gl.glBufferDataARB(34962, buffer.capacity() * 4, buffer, 35044);
                }
            }
            _SG_PrivilegedAccess.setDirty(data, false);
            _SG_PrivilegedAccess.incrementFramesSinceDirty(data);
        }
    }

    private static final void bindVertexArray(GL gl, CanvasPeer canvasPeer, GeomNioData data, int elemSize, int stride, long offset, int index, int arrayType, OpenGLStatesCache statesCache, boolean glVBOsSupported, boolean arbVBOsSupported) {
        SceneGraphOpenGLReference openGLRef = data instanceof GeomNioFloatData ? ((GeomNioFloatData)data).getOpenGLReferences().getReference(canvasPeer, vboNameProvider) : ((GeomNioIntData)data).getOpenGLReferences().getReference(canvasPeer, vboNameProvider);
        int cacheHandle = openGLRef.getName();
        if (cacheHandle != -1) {
            tmpIntBuffer.clear();
            tmpIntBuffer.put(cacheHandle).flip();
            if (glVBOsSupported) {
                gl.glDeleteBuffers(1, tmpIntBuffer);
            } else if (arbVBOsSupported) {
                gl.glDeleteBuffersARB(1, tmpIntBuffer);
            }
            cacheHandle = openGLRef.deleteName();
        }
        ShapeAtomPeer.bindArrayVBO(gl, 0, statesCache, glVBOsSupported, arbVBOsSupported);
        ShapeAtomPeer.bindIndexVBO(gl, 0, statesCache, glVBOsSupported, arbVBOsSupported);
        FloatBuffer dataBuffer = ((GeomNioFloatData)data).getBuffer();
        dataBuffer.position((int)(offset / 4L));
        switch (arrayType) {
            case 32884: {
                gl.glVertexPointer(elemSize, 5126, stride, dataBuffer);
                break;
            }
            case 32885: {
                gl.glNormalPointer(5126, stride, dataBuffer);
                break;
            }
            case 32886: {
                gl.glColorPointer(elemSize, 5126, stride, dataBuffer);
                break;
            }
            case 32888: {
                gl.glTexCoordPointer(elemSize, 5126, stride, dataBuffer);
                break;
            }
            case 34373: {
                gl.glVertexAttribPointer(index, elemSize, 5126, false, stride, dataBuffer);
            }
        }
        _SG_PrivilegedAccess.setDirty(data, false);
        _SG_PrivilegedAccess.incrementFramesSinceDirty(data);
    }

    private static final boolean bindGeometryComponent(GL gl, CanvasPeer canvasPeer, OpenGLStatesCache statesCache, GeomNioData data, int elemSize, int stride, long offset, int index, int arrayType, VBOMode vboMode, Boolean useVBO, boolean glVBOsSupported, boolean arbVBOsSupported) {
        if (useVBO == null) {
            useVBO = ShapeAtomPeer.vboModeToBool(vboMode, data);
        }
        if ((useVBO = Boolean.valueOf(useVBO != false && (glVBOsSupported || arbVBOsSupported))).booleanValue()) {
            if (data != null) {
                ShapeAtomPeer.createAndBindVBO(gl, canvasPeer, data, arrayType, statesCache, glVBOsSupported, arbVBOsSupported);
            }
            switch (arrayType) {
                case 32884: {
                    gl.glVertexPointer(elemSize, 5126, stride, offset);
                    break;
                }
                case 32885: {
                    gl.glNormalPointer(5126, stride, offset);
                    break;
                }
                case 32886: {
                    gl.glColorPointer(elemSize, 5126, stride, offset);
                    break;
                }
                case 32888: {
                    gl.glTexCoordPointer(elemSize, 5126, stride, offset);
                    break;
                }
                case 34373: {
                    gl.glVertexAttribPointer(index, elemSize, 5126, false, stride, offset);
                }
            }
        } else if (data instanceof GeomNioFloatData) {
            ShapeAtomPeer.bindVertexArray(gl, canvasPeer, data, elemSize, stride, offset, index, arrayType, statesCache, glVBOsSupported, arbVBOsSupported);
        }
        return useVBO;
    }

    private static final int setupBuffers(GL gl, CanvasPeer canvasPeer, OpenGLStatesCache statesCache, OpenGLCapabilities glCaps, Geometry geoArray, Geometry.Optimization optimization, int texturesUseMap, boolean glVBOsSupported, boolean arbVBOsSupported) {
        int stride;
        Boolean useVBO;
        VBOMode geomVBOMode = ShapeAtomPeer.getGeomVBOMode(optimization);
        if (geoArray.isInterleaved()) {
            useVBO = ShapeAtomPeer.vboModeToBool(geomVBOMode, geoArray.getInterleavedData()) != false && (glVBOsSupported || arbVBOsSupported);
            stride = geoArray.getInterleavedData().getStride();
            if (useVBO.booleanValue()) {
                ShapeAtomPeer.createAndBindVBO(gl, canvasPeer, geoArray.getInterleavedData(), -1, statesCache, glVBOsSupported, arbVBOsSupported);
            }
        } else {
            useVBO = null;
            stride = 0;
        }
        int vboMap = 0;
        if (geoArray.hasNormals() && ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, geoArray.getNormalsData(), geoArray.getNormalsSize(), stride, geoArray.getNormalsOffset(), -1, 32885, geomVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) {
            vboMap |= 2;
        }
        if (geoArray.hasColors() && ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, geoArray.getColorData(), geoArray.getColorsSize(), stride, geoArray.getColorsOffset(), -1, 32886, geomVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) {
            vboMap |= 4;
        }
        if (texturesUseMap != 0) {
            VBOMode texCoordVBOMode = geoArray.isInterleaved() ? geomVBOMode : ShapeAtomPeer.getTexCoordVBOMode(optimization);
            int maxTUs = glCaps.getMaxTextureUnits();
            int maskValue = 1;
            for (int unit = 0; unit < maxTUs; ++unit) {
                if ((texturesUseMap & maskValue) != 0) {
                    ShapeAtomPeer.selectClientTextureUnit(gl, unit, statesCache, false);
                    GeomNioFloatData texCoords = geoArray.getTexCoordsData(unit);
                    if (geoArray.isInterleaved()) {
                        long offset;
                        int texCoordSize = geoArray.getTexCoordSize(unit);
                        if (ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, texCoords, texCoordSize, stride, offset = geoArray.getTexCoordsOffset(unit), unit, 32888, texCoordVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) {
                            vboMap |= 8;
                        }
                    } else if (ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, texCoords, texCoords.getElemSize(), 0, 0L, unit, 32888, texCoordVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) {
                        vboMap |= 8;
                    }
                }
                maskValue *= 2;
            }
        }
        if (OpenGlExtensions.GL_CUSTOM_VERTEX_ATTRIBUTES && geoArray.hasVertexAttributes()) {
            int n = Math.min(geoArray.getVertexAttributesCount(), glCaps.getMaxVertexAttributes());
            for (int i = 0; i < n; ++i) {
                if (!geoArray.hasVertexAttributes(i)) continue;
                GeomNioFloatData attribData = geoArray.getVertexAttribData(i);
                if (geoArray.isInterleaved()) {
                    long offset;
                    int attribSize = geoArray.getVertexAttribSize(i);
                    if (!ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, attribData, attribSize, stride, offset = geoArray.getVertexAttribsOffset(i), i, 34373, geomVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) continue;
                    vboMap |= 0x10;
                    continue;
                }
                if (!ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, attribData, attribData.getElemSize(), 0, 0L, i, 34373, geomVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) continue;
                vboMap |= 0x10;
            }
        }
        if (ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, geoArray.getCoordinatesData(), geoArray.getCoordinatesSize(), stride, geoArray.getCoordinatesOffset(), -1, 32884, geomVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) {
            vboMap |= 1;
        }
        if (geoArray.hasIndex() && !geoArray.isInterleaved() && ShapeAtomPeer.bindGeometryComponent(gl, canvasPeer, statesCache, ((IndexedGeometryArray)geoArray).getIndexData(), 1, 0, 0L, -1, 0, geomVBOMode, useVBO, glVBOsSupported, arbVBOsSupported)) {
            vboMap |= 0x20;
        }
        return vboMap;
    }

    public static final int getNumTriangles(Geometry geoArray) {
        if (geoArray.hasIndex()) {
            return ((IndexedGeometryArray)geoArray).getValidIndexCount() / geoArray.getFaceSize();
        }
        return geoArray.getValidVertexCount() / geoArray.getFaceSize();
    }

    protected static final int drawBuffers(GL gl, Geometry geoArray, boolean useIndexVBO, boolean isInDisplayList, boolean isMinVersion13) {
        int triangles;
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "ShapeAtomPeer::drawGeometry()");
        int numVertices = geoArray.getValidVertexCount();
        if (numVertices == 0) {
            X3DLog.exception("Skipping because there are no valid vertices ");
            ProfileTimer.endProfile();
            return 0;
        }
        int mode = geoArray.getType().toOpenGL();
        if (mode == -1) {
            X3DLog.exception("Skipping unknown geometry : ", geoArray.getClass().getName());
            ProfileTimer.endProfile();
            return 0;
        }
        if (geoArray.isStrip()) {
            if (geoArray.hasIndex()) {
                IndexedGeometryStripArray igsa = (IndexedGeometryStripArray)geoArray;
                int[] stripVertexCounts = igsa.getStripVertexCounts();
                if (isInDisplayList) {
                    DisplayListRenderPeer.drawIndexedGeometryStripArray(gl, igsa, mode, igsa.getNumStrips(), stripVertexCounts, isMinVersion13);
                } else {
                    int startIndex = igsa.getInitialIndexIndex();
                    int numIndices = igsa.getValidIndexCount();
                    int i0 = 0;
                    for (int s = 0; s < stripVertexCounts.length; ++s) {
                        if (useIndexVBO) {
                            int start = i0 >= startIndex ? i0 : startIndex;
                            int end = start + stripVertexCounts[s] - 1;
                            if (end + 1 > numIndices) {
                                end = numIndices - 1;
                            }
                            if (end < start) break;
                            gl.glDrawRangeElements(mode, start, end, end - start + 1, 5125, 0L);
                        } else {
                            IntBuffer buffer = igsa.getIndexData().getBuffer();
                            int position = buffer.position();
                            int limit = buffer.limit();
                            buffer.position(i0);
                            buffer.limit(i0 + stripVertexCounts[s]);
                            gl.glDrawElements(mode, stripVertexCounts[s], 5125, buffer);
                            buffer.limit(limit);
                            buffer.position(position);
                        }
                        i0 += stripVertexCounts[s];
                    }
                }
                triangles = igsa.getValidIndexCount() / geoArray.getFaceSize();
            } else {
                GeometryStripArray geoStripArr = (GeometryStripArray)geoArray;
                int stripCount = geoStripArr.getNumStrips();
                int[] stripVertexCounts = geoStripArr.getStripVertexCounts();
                if (isInDisplayList) {
                    DisplayListRenderPeer.drawGeometryStripArray(gl, geoStripArr, mode, stripCount, stripVertexCounts, isMinVersion13);
                } else {
                    int startIndex = geoStripArr.getInitialVertexIndex();
                    int numIndices = geoStripArr.getValidVertexCount();
                    int i0 = 0;
                    for (int strip = 0; strip < stripCount; ++strip) {
                        int start = i0 >= startIndex ? i0 : startIndex;
                        int end = start + stripVertexCounts[strip] - 1;
                        if (end + 1 > numIndices) {
                            end = numIndices - 1;
                        }
                        if (end < start) break;
                        gl.glDrawArrays(mode, start, end - start + 1);
                        i0 += stripVertexCounts[strip];
                    }
                }
                triangles = geoArray.getValidVertexCount() / geoArray.getFaceSize();
            }
        } else if (geoArray.hasIndex()) {
            IndexedGeometryArray igeoArray = (IndexedGeometryArray)geoArray;
            if (isInDisplayList) {
                DisplayListRenderPeer.drawIndexedGeometryArray(gl, igeoArray, mode, isMinVersion13);
            } else {
                IntBuffer buffer = igeoArray.getIndexData().getBuffer();
                int startIndex = igeoArray.getInitialIndexIndex();
                int numIndices = igeoArray.getValidIndexCount();
                if (useIndexVBO) {
                    gl.glDrawRangeElements(mode, startIndex, startIndex + numIndices - 1, numIndices, 5125, 0L);
                } else {
                    gl.glDrawElements(mode, numIndices, 5125, buffer);
                }
            }
            triangles = igeoArray.getValidIndexCount() / geoArray.getFaceSize();
        } else {
            if (isInDisplayList) {
                DisplayListRenderPeer.drawRegularGeometryArray(gl, geoArray, mode, isMinVersion13);
            } else {
                gl.glDrawArrays(mode, geoArray.getInitialVertexIndex(), numVertices);
            }
            triangles = geoArray.getValidVertexCount() / geoArray.getFaceSize();
        }
        ProfileTimer.endProfile();
        return triangles;
    }

    public static final void selectClientTextureUnit(GL gl, int unit, OpenGLStatesCache statesCache, boolean force) {
        if (statesCache.enabled && statesCache.currentClientTextureUnit == unit && !force) {
            return;
        }
        X3DLog.debug("Activating (client) texture unit ", unit);
        int glUnit = 33984 + unit;
        gl.glClientActiveTexture(glUnit);
        statesCache.currentClientTextureUnit = unit;
    }

    protected static final int setStates(GL gl, Geometry geoArray, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, boolean useTextures, int careMap) {
        int i;
        if (!((careMap & 1) == 0 || statesCache.enabled && statesCache.coordsArrayEnabled)) {
            gl.glEnableClientState(32884);
            statesCache.coordsArrayEnabled = true;
        }
        if ((careMap & 2) != 0) {
            if (geoArray.hasNormals()) {
                if (!statesCache.enabled || !statesCache.normalsArrayEnabled) {
                    gl.glEnableClientState(32885);
                    statesCache.normalsArrayEnabled = true;
                }
            } else if (!statesCache.enabled || statesCache.normalsArrayEnabled) {
                gl.glDisableClientState(32885);
                statesCache.normalsArrayEnabled = false;
            }
        }
        if ((careMap & 4) != 0) {
            if (geoArray.hasColors()) {
                if (!statesCache.enabled || !statesCache.colorsArrayEnabled) {
                    gl.glEnableClientState(32886);
                    statesCache.colorsArrayEnabled = true;
                }
            } else if (!statesCache.enabled || statesCache.colorsArrayEnabled) {
                gl.glDisableClientState(32886);
                statesCache.colorsArrayEnabled = false;
            }
        }
        int result_texturesUseMap = 0;
        if ((careMap & 8) != 0) {
            int maxTUs = glCaps.getMaxTextureUnits();
            int maskValue = 1;
            for (i = 0; i < maxTUs; ++i) {
                boolean hasTextureUnit;
                boolean bl = hasTextureUnit = geoArray.getTexCoordSize(i) > 0;
                if (useTextures && hasTextureUnit) {
                    if (!statesCache.enabled || (statesCache.texCoordArraysEnableMask & maskValue) == 0) {
                        ShapeAtomPeer.selectClientTextureUnit(gl, i, statesCache, false);
                        gl.glEnableClientState(32888);
                        statesCache.texCoordArraysEnableMask |= maskValue;
                    }
                    result_texturesUseMap |= maskValue;
                } else if (!statesCache.enabled || (statesCache.texCoordArraysEnableMask & maskValue) != 0) {
                    ShapeAtomPeer.selectClientTextureUnit(gl, i, statesCache, false);
                    gl.glDisableClientState(32888);
                    statesCache.texCoordArraysEnableMask &= ~maskValue;
                }
                maskValue *= 2;
            }
        }
        if ((careMap & 0x10) != 0 && OpenGlExtensions.GL_CUSTOM_VERTEX_ATTRIBUTES && (geoArray.hasVertexAttributes() || !statesCache.enabled || statesCache.maxUsedVertexAttrib > 0)) {
            int maskValue = 1;
            int maxVertexAttribs = glCaps.getMaxVertexAttributes();
            for (i = 0; i < maxVertexAttribs; ++i) {
                if (geoArray.hasVertexAttributes(i)) {
                    if (!statesCache.enabled || (statesCache.vertexAttribsEnableMask & (long)maskValue) == 0L) {
                        gl.glEnableVertexAttribArray(i);
                        statesCache.vertexAttribsEnableMask |= (long)maskValue;
                    }
                    if (!statesCache.enabled || i > statesCache.maxUsedVertexAttrib) {
                        statesCache.maxUsedVertexAttrib = i;
                    }
                } else if (!statesCache.enabled || (statesCache.vertexAttribsEnableMask & (long)maskValue) != 0L) {
                    gl.glDisableVertexAttribArray(i);
                    statesCache.vertexAttribsEnableMask &= (long)(~maskValue);
                }
                maskValue *= 2;
            }
        }
        return result_texturesUseMap;
    }

    private static final int renderNoDisplayLists(GL gl, ShapeAtom shapeAtom, int texturesUseMap, Geometry geoArray, Geometry.Optimization optimization, CanvasPeer canvasPeer, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, boolean glVBOsSupported, boolean arbVBOsSupported) {
        int vboMap = ShapeAtomPeer.setupBuffers(gl, canvasPeer, statesCache, glCaps, geoArray, optimization, texturesUseMap, glVBOsSupported, arbVBOsSupported);
        boolean vboForIndex = (vboMap & 0x20) != 0;
        shapeAtom.lastComputedPolysCount = ShapeAtomPeer.drawBuffers(gl, geoArray, vboForIndex, false, glCaps.isMinVersion13());
        return shapeAtom.lastComputedPolysCount;
    }

    protected static final int renderWithForcedVertexArrays(GL gl, ShapeAtom shapeAtom, int texturesUseMap, Geometry geoArray, CanvasPeer canvasPeer, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache) {
        Geometry.Optimization optimization = Geometry.Optimization.NONE;
        return ShapeAtomPeer.renderNoDisplayLists(gl, shapeAtom, texturesUseMap, geoArray, optimization, canvasPeer, glCaps, statesCache, false, false);
    }

    private static final int render(GL gl, ShapeAtom shapeAtom, Geometry geometry, Geometry geoArray, CanvasPeer canvasPeer, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, RenderOptions options, boolean isNormalRenderMode) {
        boolean glVBOsSupported = glCaps.isMinVersion15() && glCaps.supportsVBOs() && options.areVBOsEnabled();
        boolean arbVBOsSupported = OpenGlExtensions.ARB_vertex_buffer_object && glCaps.supportsVBOs() && options.areVBOsEnabled();
        Geometry.Optimization optimization = geometry.getOptimization();
        if (optimization == Geometry.Optimization.USE_DISPLAY_LISTS) {
            if (options.areDisplayListsEnabled()) {
                ShapeAtomPeer.bindArrayVBO(gl, 0, statesCache, glVBOsSupported, arbVBOsSupported);
                ShapeAtomPeer.bindIndexVBO(gl, 0, statesCache, glVBOsSupported, arbVBOsSupported);
                DisplayListRenderPeer.renderDisplayList(gl, shapeAtom, geoArray, canvasPeer, glCaps, statesCache, isNormalRenderMode);
                return shapeAtom.lastComputedPolysCount;
            }
            optimization = Geometry.Optimization.USE_VBOS;
        }
        int texturesUseMap = ShapeAtomPeer.setStates(gl, geoArray, glCaps, statesCache, isNormalRenderMode, 63);
        return ShapeAtomPeer.renderNoDisplayLists(gl, shapeAtom, texturesUseMap, geoArray, optimization, canvasPeer, glCaps, statesCache, glVBOsSupported, arbVBOsSupported);
    }

    @Override
    public final int renderAtom(RenderAtom<?> atom, Object glObj, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        Geometry geometry;
        boolean hasName;
        GL gl = (GL)glObj;
        CanvasPeer canvasPeer = renderPeer.getCanvasPeer();
        OpenGLStatesCache statesCache = renderPeer.getStatesCache();
        ShapeAtom shapeAtom = (ShapeAtom)atom;
        Shape3D shape = (Shape3D)shapeAtom.getNode();
        String shapeName = shape.getName();
        boolean bl = hasName = shapeName != null && shapeName.length() > 0;
        if (hasName && ProfileTimer.isProfilingEnabled()) {
            ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, shapeName);
        }
        if ((geometry = shape.getGeometry()) == null) {
            X3DLog.exception("Shape has no geometry, so skipping : ", shape, " : ", shapeName);
            return 0;
        }
        Appearance app = shape.getAppearance();
        boolean isBillboard = shape instanceof Billboard;
        ShapeAtomPeer.setMatrix(gl, view, _SG_PrivilegedAccess.getLeafWorldTransform(shape), isBillboard, false);
        if (shape.getShowBounds() && renderMode == RenderPeer.RenderMode.NORMAL) {
            BoundsAtomPeer.drawBounds(gl, shape.getBounds(), null, statesCache);
        }
        int triangles = 0;
        if (app != null && app.getPolygonAttributes() != null && app.getPolygonAttributes().getFaceCullMode() == FaceCullMode.SWITCH) {
            tmpIntBuffer.clear();
            gl.glGetIntegerv(2885, tmpIntBuffer);
            int polyMode = tmpIntBuffer.get();
            boolean wasPolyCullEnabled = PolygonAttribsStateUnitPeer.setCullMode(gl, statesCache, PolygonAttributes.CULL_BACK, true, renderMode == RenderPeer.RenderMode.PICKING);
            triangles = ShapeAtomPeer.render(gl, shapeAtom, geometry, geometry, canvasPeer, glCaps, statesCache, options, renderMode == RenderPeer.RenderMode.NORMAL);
            PolygonAttribsStateUnitPeer.setCullMode(gl, statesCache, PolygonAttributes.CULL_FRONT, false, renderMode == RenderPeer.RenderMode.PICKING);
            triangles = ShapeAtomPeer.render(gl, shapeAtom, geometry, geometry, canvasPeer, glCaps, statesCache, options, renderMode == RenderPeer.RenderMode.NORMAL);
            PolygonAttribsStateUnitPeer.setCullMode(gl, statesCache, polyMode, wasPolyCullEnabled, renderMode == RenderPeer.RenderMode.PICKING);
        } else {
            triangles = ShapeAtomPeer.render(gl, shapeAtom, geometry, geometry, canvasPeer, glCaps, statesCache, options, renderMode == RenderPeer.RenderMode.NORMAL);
        }
        if (renderMode == RenderPeer.RenderMode.NORMAL && geometry.hasColors()) {
            gl.glColor4f(statesCache.color.getRed(), statesCache.color.getGreen(), statesCache.color.getBlue(), 1.0f - statesCache.color.getAlpha());
        }
        if (hasName && ProfileTimer.isProfilingEnabled()) {
            ProfileTimer.endProfile();
        }
        return triangles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VBOMode {
        ALWAYS,
        AUTO,
        NEVER;

    }
}

