/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShader;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Shader;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.debug.DebugStrings;
import org.xith3d.utility.logging.X3DLog;

public class GLSLShaderProgramStateUnitPeer {
    private static boolean ARB_shader_objects_supported = false;
    private static ByteBuffer tmpByteBuffer = BufferUtils.createByteBuffer(128);
    private static FloatBuffer tmpFloatBuffer = BufferUtils.createFloatBuffer(128);
    private static IntBuffer tmpIntBuffer = BufferUtils.createIntBuffer(128);
    private static SceneGraphOpenGLReferences.Provider shaderProgramNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    ARBShaderObjects.glDeleteObjectARB(name);
                }
            };
        }
    };
    private static SceneGraphOpenGLReferences.Provider shaderNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                }
            };
        }
    };
    private static boolean checkedOnce = false;

    private static void checkOnce() {
        String extensions = GL11.glGetString(7939);
        if (extensions.indexOf("GL_ARB_shader_objects") != -1) {
            ARB_shader_objects_supported = true;
        } else {
            X3DLog.error("GL_ARB_fragment_shader and/or GL_ARB_vertex_shader not supported, skipping");
        }
        checkedOnce = true;
    }

    protected static final boolean areARBShaderObjectsSupported() {
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce();
        }
        return ARB_shader_objects_supported;
    }

    private static void compileShader(GLSLShader s, SceneGraphOpenGLReference shaderOpenGLRef) {
        if (s.hasCompilationError()) {
            return;
        }
        X3DLog.debug("compiling Shader:\n", s.getShaderCode(), "\n");
        int shaderHandle = s.getType() == Shader.ShaderType.VERTEX ? ARBShaderObjects.glCreateShaderObjectARB(35633) : ARBShaderObjects.glCreateShaderObjectARB(35632);
        shaderOpenGLRef.setName(shaderHandle);
        if (tmpByteBuffer.limit() < s.getShaderCode().length()) {
            tmpByteBuffer = BufferUtils.createByteBuffer((int)((double)s.getShaderCode().length() * 1.5));
        }
        tmpByteBuffer.clear();
        tmpByteBuffer.put(s.getShaderCode().getBytes());
        tmpByteBuffer.flip();
        ARBShaderObjects.glShaderSourceARB(shaderHandle, tmpByteBuffer);
        ARBShaderObjects.glCompileShaderARB(shaderHandle);
        tmpIntBuffer.clear();
        ARBShaderObjects.glGetObjectParameterARB(shaderHandle, 35713, tmpIntBuffer);
        if (tmpIntBuffer.get() != 1) {
            if (GLSLContext.isDebuggingEnabled()) {
                tmpIntBuffer.clear();
                ARBShaderObjects.glGetObjectParameterARB(shaderHandle, 35716, tmpIntBuffer);
                int length = tmpIntBuffer.get();
                if (tmpByteBuffer.limit() < length) {
                    tmpByteBuffer = BufferUtils.createByteBuffer((int)((double)length * 1.5));
                }
                tmpIntBuffer.flip();
                tmpByteBuffer.clear();
                ARBShaderObjects.glGetInfoLogARB(shaderHandle, tmpIntBuffer, tmpByteBuffer);
                byte[] infoBytes = new byte[length];
                tmpByteBuffer.get(infoBytes);
                String errMsg = new String(infoBytes);
                String message = "Failed to compile GLSL Shader.\nMessage:\n" + errMsg + "\n" + "+++++++++++++++++++++++++++++++++++\n" + "Source:\n" + "+++++++++++++++++++++++++++++++++++\n" + DebugStrings.numerateLines(s.getShaderCode(), 1, 3) + "\n" + "+++++++++++++++++++++++++++++++++++\n";
                System.err.println(message);
                X3DLog.error(message);
            }
            s.setCompilationError(true);
            return;
        }
        X3DLog.debug("done glHandle: ", shaderHandle);
        _SG_PrivilegedAccess.setDirty(s, false);
    }

    private static void mapAttributes(GLSLShaderProgram shaderProgram, SceneGraphOpenGLReference shaderProgOpenGLRef) {
        if (!OpenGlExtensions.GL_CUSTOM_VERTEX_ATTRIBUTES) {
            return;
        }
        for (int i = 0; i < shaderProgram.getNumVertexShaders(); ++i) {
            GLSLVertexShader shader = (GLSLVertexShader)shaderProgram.getVertexShader(i);
            int numAttribs = shader.getVertexAttributesCount();
            for (int j = 0; j < numAttribs; ++j) {
                int index = shader.getNthVertexAttributeIndex(j);
                String name = shader.getVertexAttributeMapping(index);
                GLSLShaderProgramStateUnitPeer.setupTempByteBuffer(name.length() + 1);
                tmpByteBuffer.put(name.getBytes());
                tmpByteBuffer.put((byte)0);
                tmpByteBuffer.flip();
                GL20.glBindAttribLocation(shaderProgOpenGLRef.getName(), index, tmpByteBuffer);
            }
        }
    }

    private static void linkShaderProgram(GLSLShaderProgram shaderProgram, CanvasPeer canvasPeer) {
        GLSLShader s;
        int i;
        if (shaderProgram.hasLinkingError()) {
            return;
        }
        X3DLog.debug("linking GLSL shader program: ", shaderProgram.getName());
        SceneGraphOpenGLReference shaderProgOpenGLRef = shaderProgram.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        int glHandle = ARBShaderObjects.glCreateProgramObjectARB();
        shaderProgOpenGLRef.setName(glHandle);
        for (i = 0; i < shaderProgram.getNumVertexShaders(); ++i) {
            s = (GLSLVertexShader)shaderProgram.getVertexShader(i);
            ARBShaderObjects.glAttachObjectARB(glHandle, s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider).getName());
        }
        for (i = 0; i < shaderProgram.getNumFragmentShaders(); ++i) {
            s = (GLSLFragmentShader)shaderProgram.getFragmentShader(i);
            ARBShaderObjects.glAttachObjectARB(glHandle, s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider).getName());
        }
        GLSLShaderProgramStateUnitPeer.mapAttributes(shaderProgram, shaderProgOpenGLRef);
        ARBShaderObjects.glLinkProgramARB(glHandle);
        tmpIntBuffer.clear();
        ARBShaderObjects.glGetObjectParameterARB(glHandle, 35714, tmpIntBuffer);
        if (tmpIntBuffer.get() != 1) {
            X3DLog.error("failed to link glsl program shader id:", glHandle);
            _SG_PrivilegedAccess.setGLSLShaderProgramLinkError(shaderProgram, true);
            return;
        }
        X3DLog.debug("done ... glHandle: ", glHandle);
        _SG_PrivilegedAccess.setGLSLShaderProgramLinked(shaderProgram, true);
    }

    private static void setupTempByteBuffer(int minCap) {
        if (tmpByteBuffer.capacity() < minCap) {
            tmpByteBuffer = BufferUtils.createByteBuffer((int)((double)minCap * 1.5));
        }
        tmpByteBuffer.position(0);
        tmpByteBuffer.limit(tmpByteBuffer.capacity());
    }

    private static void setupTempFloatBuffer(int minCap) {
        if (tmpFloatBuffer.capacity() < minCap) {
            tmpFloatBuffer = BufferUtils.createFloatBuffer((int)((double)minCap * 1.5));
        }
        tmpFloatBuffer.position(0);
        tmpFloatBuffer.limit(tmpFloatBuffer.capacity());
    }

    private static void setupTempIntBuffer(int minCap) {
        if (tmpIntBuffer.capacity() < minCap) {
            tmpIntBuffer = BufferUtils.createIntBuffer((int)((double)minCap * 1.5));
        }
        tmpIntBuffer.position(0);
        tmpIntBuffer.limit(tmpIntBuffer.capacity());
    }

    private static void applyUniformVariables(GLSLContext shaderProgram, CanvasPeer canvasPeer) {
        GLSLShaderProgram program = (GLSLShaderProgram)shaderProgram.getProgram();
        GLSLParameters params = shaderProgram.getUniformParameters();
        if (program.hasLinkingError()) {
            return;
        }
        if (!params.hasUniformVars()) {
            return;
        }
        SceneGraphOpenGLReference shaderProgOpenGLRef = program.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        int numFloatUniformVars = params.getNumUniformVarsFloat();
        block14: for (int k = 0; k < numFloatUniformVars; ++k) {
            String key = params.getFloatUniformVarName(k);
            GLSLShaderProgramStateUnitPeer.setupTempByteBuffer(key.length() + 1);
            tmpByteBuffer.put(key.getBytes());
            tmpByteBuffer.put((byte)0);
            tmpByteBuffer.flip();
            int location = ARBShaderObjects.glGetUniformLocationARB(shaderProgOpenGLRef.getName(), tmpByteBuffer);
            float[] value = params.getUniformVarValueFloat(k);
            GLSLShaderProgramStateUnitPeer.setupTempFloatBuffer(value.length);
            tmpFloatBuffer.put(value);
            tmpFloatBuffer.flip();
            switch (params.getUniformVarBaseSizeFloat(k)) {
                case 1: {
                    ARBShaderObjects.glUniform1ARB(location, tmpFloatBuffer);
                    continue block14;
                }
                case 2: {
                    ARBShaderObjects.glUniform2ARB(location, tmpFloatBuffer);
                    continue block14;
                }
                case 3: {
                    ARBShaderObjects.glUniform3ARB(location, tmpFloatBuffer);
                    continue block14;
                }
                case 4: {
                    ARBShaderObjects.glUniform4ARB(location, tmpFloatBuffer);
                    continue block14;
                }
                case 9: {
                    ARBShaderObjects.glUniformMatrix3ARB(location, true, tmpFloatBuffer);
                    continue block14;
                }
                case 16: {
                    ARBShaderObjects.glUniformMatrix4ARB(location, true, tmpFloatBuffer);
                }
            }
        }
        int numIntUniformVars = params.getNumUniformVarsInt();
        block15: for (int k = 0; k < numIntUniformVars; ++k) {
            String key = params.getIntUniformVarName(k);
            GLSLShaderProgramStateUnitPeer.setupTempByteBuffer(key.length() + 1);
            tmpByteBuffer.put(key.getBytes());
            tmpByteBuffer.put((byte)0);
            tmpByteBuffer.flip();
            int location = ARBShaderObjects.glGetUniformLocationARB(shaderProgOpenGLRef.getName(), tmpByteBuffer);
            int[] value = params.getUniformVarValueInt(k);
            GLSLShaderProgramStateUnitPeer.setupTempIntBuffer(value.length);
            tmpIntBuffer.put(value);
            tmpIntBuffer.flip();
            switch (params.getUniformVarBaseSizeInt(k)) {
                case 1: {
                    ARBShaderObjects.glUniform1ARB(location, tmpIntBuffer);
                    continue block15;
                }
                case 2: {
                    ARBShaderObjects.glUniform2ARB(location, tmpIntBuffer);
                    continue block15;
                }
                case 3: {
                    ARBShaderObjects.glUniform3ARB(location, tmpIntBuffer);
                    continue block15;
                }
                case 4: {
                    ARBShaderObjects.glUniform4ARB(location, tmpIntBuffer);
                }
            }
        }
    }

    protected static final int getCurrentShaderProgram() {
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce();
        }
        if (!ARB_shader_objects_supported) {
            return 0;
        }
        return ARBShaderObjects.glGetHandleARB(35648);
    }

    protected static final void disableGLSLShaders(OpenGLStatesCache statesCache) {
        if (statesCache.enabled && statesCache.currentGLSLShaderProgram == 0) {
            return;
        }
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce();
        }
        if (ARB_shader_objects_supported) {
            ARBShaderObjects.glUseProgramObjectARB(0);
        }
        statesCache.currentGLSLShaderProgram = 0;
    }

    public static final void apply(GLSLContext shaderProgram, CanvasPeer canvasPeer, OpenGLStatesCache statesCache, RenderPeer.RenderMode renderMode) {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "GLSLShaderProgramStateUnitPeer::apply()");
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            GLSLShaderProgramStateUnitPeer.disableGLSLShaders(statesCache);
            return;
        }
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce();
        }
        GLSLShaderProgram program = (GLSLShaderProgram)shaderProgram.getProgram();
        if (shaderProgram.isEnabled() && !program.isLinked()) {
            SceneGraphOpenGLReference shaderOpenGLRef;
            GLSLShader s;
            int i;
            for (i = 0; i < program.getNumVertexShaders(); ++i) {
                s = (GLSLShader)program.getVertexShader(i);
                shaderOpenGLRef = s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider);
                if (!_SG_PrivilegedAccess.isDirty(s)) continue;
                GLSLShaderProgramStateUnitPeer.compileShader(s, shaderOpenGLRef);
            }
            for (i = 0; i < program.getNumFragmentShaders(); ++i) {
                s = (GLSLShader)program.getFragmentShader(i);
                shaderOpenGLRef = s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider);
                if (!_SG_PrivilegedAccess.isDirty(s)) continue;
                GLSLShaderProgramStateUnitPeer.compileShader(s, shaderOpenGLRef);
            }
            GLSLShaderProgramStateUnitPeer.linkShaderProgram(program, canvasPeer);
        }
        if (shaderProgram.isEnabled()) {
            if (program.isLinked() && ARB_shader_objects_supported) {
                int shaderProgGLHandle = program.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider).getName();
                X3DLog.debug("Use GLSL program id ", shaderProgGLHandle);
                if (!statesCache.enabled || statesCache.currentGLSLShaderProgram != shaderProgGLHandle) {
                    ARBShaderObjects.glUseProgramObjectARB(shaderProgGLHandle);
                    statesCache.currentGLSLShaderProgram = shaderProgGLHandle;
                }
                GLSLShaderProgramStateUnitPeer.applyUniformVariables(shaderProgram, canvasPeer);
            }
        } else {
            GLSLShaderProgramStateUnitPeer.disableGLSLShaders(statesCache);
        }
        ProfileTimer.endProfile();
    }
}

