/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.FloatBuffer;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.MaterialStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterialStateUnitPeer
implements StateUnitPeer {
    private static final FloatBuffer tmpFloatBuffer = BufferUtils.createFloatBuffer(4);

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "MaterialStateUnitPeer::apply()");
        Material m = ((MaterialStateUnit)stateUnit).getMaterial();
        if (m != null) {
            if (m.isLightingEnabled() && options.isLightingEnabled()) {
                ShapeAtom shapeAtom;
                Appearance app;
                X3DLog.debug("Lighting enabled");
                if (!statesCache.enabled || !statesCache.lightingEnabled) {
                    GL11.glEnable(2896);
                    statesCache.lightingEnabled = true;
                }
                if (m.getColorTarget() != Material.NONE) {
                    GL11.glColorMaterial(1032, m.getColorTarget().toOpenGL());
                    if (!statesCache.enabled || !statesCache.colorMaterialEnabled) {
                        GL11.glEnable(2903);
                        statesCache.colorMaterialEnabled = true;
                    }
                } else if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
                    GL11.glDisable(2903);
                    statesCache.colorMaterialEnabled = false;
                }
                Colorf ambient = m.getAmbientColor();
                tmpFloatBuffer.clear();
                tmpFloatBuffer.put(ambient.getRed()).put(ambient.getGreen()).put(ambient.getBlue()).put(1.0f);
                tmpFloatBuffer.rewind();
                GL11.glMaterial(1032, 4608, tmpFloatBuffer);
                float opaque = 1.0f;
                if (atom instanceof ShapeAtom && (app = ((Shape3D)(shapeAtom = (ShapeAtom)atom).getNode()).getAppearance()) != null && app.getTransparencyAttributes() != null) {
                    opaque = 1.0f - app.getTransparencyAttributes().getTransparency();
                }
                Colorf diffuse = m.getDiffuseColor();
                tmpFloatBuffer.clear();
                tmpFloatBuffer.put(diffuse.getRed()).put(diffuse.getGreen()).put(diffuse.getBlue()).put(opaque);
                tmpFloatBuffer.rewind();
                GL11.glMaterial(1032, 4609, tmpFloatBuffer);
                Colorf emmissive = m.getEmissiveColor();
                tmpFloatBuffer.clear();
                tmpFloatBuffer.put(emmissive.getRed()).put(emmissive.getGreen()).put(emmissive.getBlue()).put(1.0f);
                tmpFloatBuffer.rewind();
                GL11.glMaterial(1032, 5632, tmpFloatBuffer);
                Colorf specular = m.getSpecularColor();
                tmpFloatBuffer.clear();
                tmpFloatBuffer.put(specular.getRed()).put(specular.getGreen()).put(specular.getBlue()).put(1.0f);
                tmpFloatBuffer.rewind();
                GL11.glMaterial(1032, 4610, tmpFloatBuffer);
                GL11.glMaterialf(1032, 5633, m.getShininess());
                if (!(!m.getNormalizeNormals() || statesCache.enabled && statesCache.normalizeEnabled)) {
                    GL11.glEnable(2977);
                } else if (!(m.getNormalizeNormals() || statesCache.enabled && !statesCache.normalizeEnabled)) {
                    GL11.glDisable(2977);
                }
                statesCache.normalizeEnabled = m.getNormalizeNormals();
            } else {
                if (!statesCache.enabled || statesCache.lightingEnabled) {
                    GL11.glDisable(2896);
                    statesCache.lightingEnabled = false;
                }
                if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
                    GL11.glDisable(2903);
                    statesCache.colorMaterialEnabled = false;
                }
                X3DLog.debug("Lighting disabled");
            }
        } else {
            if (!statesCache.enabled || statesCache.lightingEnabled) {
                GL11.glDisable(2896);
                statesCache.lightingEnabled = false;
            }
            if (!statesCache.enabled || statesCache.colorMaterialEnabled) {
                GL11.glDisable(2903);
                statesCache.colorMaterialEnabled = false;
            }
            X3DLog.debug("Lighting disabled");
        }
        ProfileTimer.endProfile();
    }
}

