/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.lwjgl.opengl.GL11;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.PolygonAttribsStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonAttribsStateUnitPeer
implements StateUnitPeer {
    public static final void enablePolygonOffset(DrawMode mode, OpenGLStatesCache statesCache, boolean enable) {
        if (mode == DrawMode.FILL) {
            if (!(!enable || statesCache.enabled && statesCache.polygonOffsetFillEnabled)) {
                GL11.glEnable(32823);
                statesCache.polygonOffsetFillEnabled = true;
            } else if (!(enable || statesCache.enabled && !statesCache.polygonOffsetFillEnabled)) {
                GL11.glDisable(32823);
                statesCache.polygonOffsetFillEnabled = false;
            }
        } else if (mode == DrawMode.LINE) {
            if (!(!enable || statesCache.enabled && statesCache.polygonOffsetLineEnabled)) {
                GL11.glEnable(10754);
                statesCache.polygonOffsetLineEnabled = true;
            } else if (!(enable || statesCache.enabled && !statesCache.polygonOffsetLineEnabled)) {
                GL11.glDisable(10754);
                statesCache.polygonOffsetLineEnabled = false;
            }
        } else if (mode == DrawMode.POINT) {
            if (!(!enable || statesCache.enabled && statesCache.polygonOffsetPointEnabled)) {
                GL11.glEnable(10753);
                statesCache.polygonOffsetPointEnabled = true;
            } else if (!(enable || statesCache.enabled && !statesCache.polygonOffsetPointEnabled)) {
                GL11.glDisable(10753);
                statesCache.polygonOffsetPointEnabled = false;
            }
        }
    }

    public static final void setCullMode(OpenGLStatesCache statesCache, int mode, boolean enable, boolean isPickMode) {
        if (isPickMode) {
            switch (mode) {
                case 1028: {
                    GL11.glCullFace(1028);
                    break;
                }
                case 1029: {
                    GL11.glCullFace(1029);
                    break;
                }
            }
        } else {
            switch (mode) {
                case 1028: {
                    GL11.glCullFace(1028);
                    break;
                }
                case 1029: {
                    GL11.glCullFace(1029);
                    break;
                }
            }
            if (!(!enable || statesCache.enabled && statesCache.cullFaceEnabled)) {
                GL11.glEnable(2884);
            } else if (!(enable || statesCache.enabled && !statesCache.cullFaceEnabled)) {
                GL11.glDisable(2884);
            }
            statesCache.cullFaceEnabled = enable;
        }
    }

    public static final boolean setCullMode(OpenGLStatesCache statesCache, FaceCullMode mode, boolean autoEnable, boolean isPickMode) {
        Boolean enable;
        if (isPickMode) {
            switch (mode) {
                case NONE: {
                    GL11.glCullFace(1029);
                    break;
                }
                case FRONT: {
                    GL11.glCullFace(1028);
                    break;
                }
                case BACK: {
                    GL11.glCullFace(1029);
                    break;
                }
            }
            return false;
        }
        boolean result = false;
        if (autoEnable) {
            result = statesCache.cullFaceEnabled;
        }
        switch (mode) {
            case NONE: {
                enable = Boolean.FALSE;
                break;
            }
            case FRONT: {
                GL11.glCullFace(1028);
                enable = Boolean.TRUE;
                break;
            }
            case BACK: {
                GL11.glCullFace(1029);
                enable = Boolean.TRUE;
                break;
            }
            default: {
                enable = null;
            }
        }
        if (enable != null) {
            if (!(!enable.booleanValue() || statesCache.enabled && statesCache.cullFaceEnabled)) {
                GL11.glEnable(2884);
            } else if (!(enable.booleanValue() || statesCache.enabled && !statesCache.cullFaceEnabled)) {
                GL11.glDisable(2884);
            }
            statesCache.cullFaceEnabled = enable;
        }
        return result;
    }

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "PolygonAttribsStateUnitPeer::apply()");
        PolygonAttributes pa = ((PolygonAttribsStateUnit)stateUnit).getPolygonAttributes();
        DrawMode mode = options.isWireframeModeEnabled() ? DrawMode.LINE : pa.getDrawMode();
        GL11.glPolygonMode(1032, mode.toOpenGL());
        float pOfs = pa.getPolygonOffset();
        float pOfsFactor = pa.getPolygonOffsetFactor();
        if (pOfs == 0.0f && pOfsFactor == 0.0f) {
            PolygonAttribsStateUnitPeer.enablePolygonOffset(pa.getDrawMode(), statesCache, false);
        } else {
            GL11.glPolygonOffset(pOfsFactor, pOfs);
            PolygonAttribsStateUnitPeer.enablePolygonOffset(pa.getDrawMode(), statesCache, true);
        }
        PolygonAttribsStateUnitPeer.setCullMode(statesCache, pa.getFaceCullMode(), true, renderMode == RenderPeer.RenderMode.PICKING);
        if (!(!pa.isPolygonAntialiasingEnabled() || statesCache.enabled && statesCache.polygonSmoothEnabled)) {
            GL11.glEnable(2881);
        } else if (!(pa.isPolygonAntialiasingEnabled() || statesCache.enabled && !statesCache.polygonSmoothEnabled)) {
            GL11.glDisable(2881);
        }
        statesCache.polygonSmoothEnabled = pa.isPolygonAntialiasingEnabled();
        ProfileTimer.endProfile();
    }
}

