/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing;

import org.openmali.spatial.bodies.Classifier;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBinType;
import org.xith3d.render.preprocessing.sorting.StatePriorities;
import org.xith3d.render.states.StateSortable;
import org.xith3d.scenegraph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RenderBin {
    private final RenderBinType type;
    private final String name;
    private final DynamicAtomArray atoms;
    private int iterationPointer = 0;

    public final RenderBinType getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final DynamicAtomArray getAtoms() {
        return this.atoms;
    }

    public final int size() {
        return this.atoms.size();
    }

    public final void clear() {
        this.atoms.clear();
    }

    public final void shrink() {
        this.atoms.cleanUp();
    }

    public final RenderAtom<? extends Node> getAtom(int index) {
        return this.atoms.get(index);
    }

    public final void resetIterationPointer() {
        this.iterationPointer = 0;
    }

    public final RenderAtom<? extends Node> getNextAtom() {
        if (this.iterationPointer >= this.atoms.size()) {
            return null;
        }
        return this.atoms.get(this.iterationPointer++);
    }

    public final void addAtom(RenderAtom<? extends Node> atom, Classifier.Classification classify, long frameId) {
        this.atoms.append(atom);
        atom.setClassification(classify);
    }

    public void dump(StatePriorities priorities) {
        System.out.println("");
        for (int j = 0; j < this.atoms.size(); ++j) {
            System.out.print("Atom " + j + ": ");
            RenderAtom<?> atom = this.atoms.get(j);
            for (int i = 0; i < priorities.numStatePriorities; ++i) {
                StateSortable ss1 = atom.getSortableStates().map[priorities.statePriorities[i]];
                if (ss1 == null) {
                    System.out.print(" " + priorities.statePriorities[i] + ":-1");
                    continue;
                }
                long bid1 = atom.getSortableStates().map[priorities.statePriorities[i]].getStateId();
                System.out.print(" " + priorities.statePriorities[i] + ":" + bid1);
            }
            System.out.println("");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " \"" + this.getName() + "\" with " + this.size() + " atoms";
    }

    public RenderBin(RenderBinType type, String name, int initialCapacity) {
        this.type = type;
        this.name = name;
        this.atoms = new DynamicAtomArray(initialCapacity);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DynamicAtomArray {
        private RenderAtom<?>[] atoms;
        private int lastSize;
        private int size;

        public final RenderAtom<?>[] getRawArray() {
            return this.atoms;
        }

        public final int size() {
            return this.size;
        }

        public final void clear() {
            this.lastSize = this.size;
            for (int i = 0; i < this.size; ++i) {
                this.atoms[i] = null;
            }
            this.size = 0;
        }

        public final void cleanUp() {
            if (this.lastSize <= this.size) {
                return;
            }
        }

        private final void ensureCapacity(int cap) {
            int oldCapacity = this.atoms.length;
            if (cap > oldCapacity) {
                RenderAtom<?>[] oldData = this.atoms;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                this.atoms = new RenderAtom[newCapacity];
                System.arraycopy(oldData, 0, this.atoms, 0, oldCapacity);
            }
        }

        public final RenderAtom<?> append(RenderAtom<?> atom) {
            this.ensureCapacity(this.size + 1);
            this.atoms[this.size] = atom;
            ++this.size;
            return atom;
        }

        public final RenderAtom<?> get(int index) {
            return this.atoms[index];
        }

        public DynamicAtomArray(int initialCapacity) {
            this.atoms = new RenderAtom[initialCapacity];
            this.size = 0;
        }
    }
}

