/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing;

import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.preprocessing.ShadowAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.ColoringStateUnit;
import org.xith3d.render.states.units.LineAttribsStateUnit;
import org.xith3d.render.states.units.MaterialStateUnit;
import org.xith3d.render.states.units.PointAttribsStateUnit;
import org.xith3d.render.states.units.PolygonAttribsStateUnit;
import org.xith3d.render.states.units.RenderingAttribsStateUnit;
import org.xith3d.render.states.units.ShaderProgramStateUnit;
import org.xith3d.render.states.units.TextureUnitStateUnit;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

public class ShapeAtom
extends ShadowAtom {
    public static final int STATE_TYPE = 0;
    public static final Appearance DEFAULT_APPEARANCE = new Appearance();
    private static RenderingAttributes transparentRenderAttribs = null;
    private final StateUnit[] stateUnitCache = new StateUnit[17];
    private int numValidTUs = 0;
    public int lastComputedPolysCount = 0;

    public ShapeAtom(Shape3D shape, OpenGLCapabilities glCaps) {
        super(0, shape);
        int i;
        Appearance a = shape.getAppearance();
        if (a == null) {
            a = DEFAULT_APPEARANCE;
        }
        this.updateStateUnit(MaterialStateUnit.makeMaterialStateUnit(a.getMaterial(), this.stateUnitCache));
        this.getStateUnit(MaterialStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(PolygonAttribsStateUnit.makePolygonAttribsStateUnit(a.getPolygonAttributes(), this.stateUnitCache));
        this.getStateUnit(PolygonAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(LineAttribsStateUnit.makeLineAttribsStateUnit(a.getLineAttributes(), this.stateUnitCache));
        this.getStateUnit(LineAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(PointAttribsStateUnit.makePointAttribsStateUnit(a.getPointAttributes(), this.stateUnitCache));
        this.getStateUnit(PointAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(ColoringStateUnit.makeColoringStateUnit(a.getColoringAttributes(), a.getTransparencyAttributes(), this.stateUnitCache));
        this.getStateUnit(ColoringStateUnit.STATE_TYPE).updateCachedStateId();
        if (a.getRenderingAttributes() == null && a.getTransparencyAttributes() != null) {
            if (transparentRenderAttribs == null) {
                transparentRenderAttribs = new RenderingAttributes(true, true, 0.0f, RenderingAttributes.GREATER);
            }
            this.updateStateUnit(RenderingAttribsStateUnit.makeRenderingStateUnit(transparentRenderAttribs, this.stateUnitCache));
        } else {
            this.updateStateUnit(RenderingAttribsStateUnit.makeRenderingStateUnit(a.getRenderingAttributes(), this.stateUnitCache));
        }
        this.getStateUnit(RenderingAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(ShaderProgramStateUnit.makeShaderProgramStateUnit(a.getShaderProgramContext(), this.stateUnitCache));
        this.getStateUnit(ShaderProgramStateUnit.STATE_TYPE).updateCachedStateId();
        this.numValidTUs = a.getTextureUnitsCount();
        for (i = 0; i < this.numValidTUs; ++i) {
            this.updateStateUnit(TextureUnitStateUnit.makeTextureUnitStateUnit(i, a.getTextureUnit(i), this.stateUnitCache));
            this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]).updateCachedStateId();
        }
        for (i = this.numValidTUs; i < TextureUnitStateUnit.DEFAULT_UNIT.length; ++i) {
            this.updateStateUnit(TextureUnitStateUnit.DEFAULT_UNIT[i]);
            this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]).updateCachedStateId();
        }
    }

    public void updateStateUnits(Appearance app, OpenGLCapabilities glCaps) {
        int i;
        this.translucent = false;
        this.updateLightsAndFogs();
        MaterialStateUnit materialUnit = (MaterialStateUnit)this.getStateUnit(MaterialStateUnit.STATE_TYPE);
        if (materialUnit.isDefault()) {
            if (app.getMaterial() != null) {
                materialUnit = MaterialStateUnit.makeMaterialStateUnit(app.getMaterial(), this.stateUnitCache);
                this.updateStateUnit(materialUnit);
                _SG_PrivilegedAccess.setChanged(app.getMaterial(), false);
            }
        } else if (app.getMaterial() == null) {
            materialUnit = MaterialStateUnit.makeMaterialStateUnit(null, null);
            this.updateStateUnit(materialUnit);
        } else if (app.getMaterial().isChanged()) {
            materialUnit.update(app.getMaterial());
            this.updateStateMap(materialUnit);
            _SG_PrivilegedAccess.setChanged(app.getMaterial(), false);
        }
        materialUnit.updateCachedStateId();
        this.translucent = this.translucent || materialUnit.isTranslucent();
        PolygonAttribsStateUnit polygonAttrUnit = (PolygonAttribsStateUnit)this.getStateUnit(PolygonAttribsStateUnit.STATE_TYPE);
        if (polygonAttrUnit.isDefault()) {
            if (app.getPolygonAttributes() != null) {
                polygonAttrUnit = PolygonAttribsStateUnit.makePolygonAttribsStateUnit(app.getPolygonAttributes(), this.stateUnitCache);
                this.updateStateUnit(polygonAttrUnit);
                _SG_PrivilegedAccess.setChanged(app.getPolygonAttributes(), false);
            }
        } else if (app.getPolygonAttributes() == null) {
            polygonAttrUnit = PolygonAttribsStateUnit.makePolygonAttribsStateUnit(null, null);
            this.updateStateUnit(polygonAttrUnit);
        } else if (app.getPolygonAttributes().isChanged()) {
            polygonAttrUnit.update(app.getPolygonAttributes());
            this.updateStateMap(polygonAttrUnit);
            _SG_PrivilegedAccess.setChanged(app.getPolygonAttributes(), false);
        }
        polygonAttrUnit.updateCachedStateId();
        this.translucent = this.translucent || polygonAttrUnit.isTranslucent();
        LineAttribsStateUnit lineAttrUnit = (LineAttribsStateUnit)this.getStateUnit(LineAttribsStateUnit.STATE_TYPE);
        if (lineAttrUnit.isDefault()) {
            if (app.getLineAttributes() != null) {
                lineAttrUnit = LineAttribsStateUnit.makeLineAttribsStateUnit(app.getLineAttributes(), this.stateUnitCache);
                this.updateStateUnit(lineAttrUnit);
                _SG_PrivilegedAccess.setChanged(app.getLineAttributes(), false);
            }
        } else if (app.getLineAttributes() == null) {
            lineAttrUnit = LineAttribsStateUnit.makeLineAttribsStateUnit(null, null);
            this.updateStateUnit(lineAttrUnit);
        } else if (app.getLineAttributes().isChanged()) {
            lineAttrUnit.update(app.getLineAttributes());
            this.updateStateMap(lineAttrUnit);
            _SG_PrivilegedAccess.setChanged(app.getLineAttributes(), false);
        }
        lineAttrUnit.updateCachedStateId();
        this.translucent = this.translucent || lineAttrUnit.isTranslucent();
        PointAttribsStateUnit pointAttrUnit = (PointAttribsStateUnit)this.getStateUnit(PointAttribsStateUnit.STATE_TYPE);
        if (pointAttrUnit.isDefault()) {
            if (app.getPointAttributes() != null) {
                pointAttrUnit = PointAttribsStateUnit.makePointAttribsStateUnit(app.getPointAttributes(), this.stateUnitCache);
                this.updateStateUnit(pointAttrUnit);
                _SG_PrivilegedAccess.setChanged(app.getPointAttributes(), false);
            }
        } else if (app.getPointAttributes() == null) {
            pointAttrUnit = PointAttribsStateUnit.makePointAttribsStateUnit(null, null);
            this.updateStateUnit(pointAttrUnit);
        } else if (app.getPointAttributes().isChanged()) {
            pointAttrUnit.update(app.getPointAttributes());
            this.updateStateMap(pointAttrUnit);
            _SG_PrivilegedAccess.setChanged(app.getPointAttributes(), false);
        }
        pointAttrUnit.updateCachedStateId();
        this.translucent = this.translucent || pointAttrUnit.isTranslucent();
        ColoringStateUnit colorUnit = (ColoringStateUnit)this.getStateUnit(ColoringStateUnit.STATE_TYPE);
        if (ColoringStateUnit.isDefault(colorUnit)) {
            if (app.getColoringAttributes() != null || app.getTransparencyAttributes() != null) {
                colorUnit = ColoringStateUnit.makeColoringStateUnit(app.getColoringAttributes(), app.getTransparencyAttributes(), this.stateUnitCache);
                this.updateStateUnit(colorUnit);
                if (app.getColoringAttributes() != null) {
                    _SG_PrivilegedAccess.setChanged(app.getColoringAttributes(), false);
                }
                if (app.getTransparencyAttributes() != null) {
                    _SG_PrivilegedAccess.setChanged(app.getTransparencyAttributes(), false);
                }
            }
        } else if (app.getColoringAttributes() == null && app.getTransparencyAttributes() == null) {
            colorUnit = ColoringStateUnit.makeColoringStateUnit(app.getColoringAttributes(), app.getTransparencyAttributes(), this.stateUnitCache);
            this.updateStateUnit(colorUnit);
        } else {
            boolean t2;
            boolean c2;
            ColoringAttributes colorAttribs = app.getColoringAttributes();
            boolean c1 = colorAttribs == null;
            boolean bl = c2 = colorUnit.getColoringAttributes() == ColoringStateUnit.DEFAULT_COLOR_ATTR;
            boolean c = c1 ? !c2 : colorAttribs.isChanged();
            TransparencyAttributes transAttribs = app.getTransparencyAttributes();
            boolean t1 = transAttribs == null;
            boolean bl2 = t2 = colorUnit.getTransparencyAttributes() == ColoringStateUnit.DEFAULT_TRANS_ATTR;
            boolean t = t1 ? !t2 : transAttribs.isChanged();
            if (c || t) {
                colorUnit.update(app.getColoringAttributes(), app.getTransparencyAttributes());
                this.updateStateMap(colorUnit);
                if (!c1) {
                    _SG_PrivilegedAccess.setChanged(app.getColoringAttributes(), false);
                }
                if (!t1) {
                    _SG_PrivilegedAccess.setChanged(app.getTransparencyAttributes(), false);
                }
            }
        }
        colorUnit.updateCachedStateId();
        this.translucent = this.translucent || colorUnit.isTranslucent();
        RenderingAttribsStateUnit renderingAttrUnit = (RenderingAttribsStateUnit)this.getStateUnit(RenderingAttribsStateUnit.STATE_TYPE);
        if (renderingAttrUnit.isDefault()) {
            if (app.getRenderingAttributes() != null) {
                renderingAttrUnit = RenderingAttribsStateUnit.makeRenderingStateUnit(app.getRenderingAttributes(), this.stateUnitCache);
                this.updateStateUnit(renderingAttrUnit);
                _SG_PrivilegedAccess.setChanged(app.getRenderingAttributes(), false);
            }
        } else if (app.getRenderingAttributes() == null) {
            renderingAttrUnit = RenderingAttribsStateUnit.makeRenderingStateUnit(null, null);
            this.updateStateUnit(renderingAttrUnit);
        } else if (app.getRenderingAttributes().isChanged()) {
            renderingAttrUnit.update(app.getRenderingAttributes());
            this.updateStateMap(renderingAttrUnit);
            _SG_PrivilegedAccess.setChanged(app.getRenderingAttributes(), false);
        }
        renderingAttrUnit.updateCachedStateId();
        this.translucent = this.translucent || renderingAttrUnit.isTranslucent();
        ShaderProgramStateUnit shaderProgramStateUnit = (ShaderProgramStateUnit)this.getStateUnit(ShaderProgramStateUnit.STATE_TYPE);
        if (shaderProgramStateUnit.isDefault()) {
            if (app.getShaderProgramContext() != null) {
                shaderProgramStateUnit = ShaderProgramStateUnit.makeShaderProgramStateUnit(app.getShaderProgramContext(), this.stateUnitCache);
                this.updateStateUnit(shaderProgramStateUnit);
                _SG_PrivilegedAccess.setChanged(app.getShaderProgramContext(), false);
            }
        } else if (app.getShaderProgramContext() == null) {
            shaderProgramStateUnit = ShaderProgramStateUnit.makeShaderProgramStateUnit(null, null);
            this.updateStateUnit(shaderProgramStateUnit);
        } else if (app.getShaderProgramContext().isChanged()) {
            shaderProgramStateUnit.update(app.getShaderProgramContext());
            this.updateStateMap(shaderProgramStateUnit);
            _SG_PrivilegedAccess.setChanged(app.getShaderProgramContext(), false);
        }
        shaderProgramStateUnit.updateCachedStateId();
        this.translucent = this.translucent || shaderProgramStateUnit.isTranslucent();
        int tuc = app.getTextureUnitsCount();
        for (i = 0; i < tuc; ++i) {
            TexCoordGeneration texCoordGen;
            TextureUnitStateUnit texStateUnit = (TextureUnitStateUnit)this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]);
            TextureUnit tu = app.getTextureUnit(i);
            Texture texture = tu == null ? null : tu.getTexture();
            TextureAttributes texAttribs = tu == null ? null : tu.getTextureAttributes();
            TexCoordGeneration texCoordGeneration = texCoordGen = tu == null ? null : tu.getTexCoordGeneration();
            if (texStateUnit.isDefault()) {
                if (texture != null || texAttribs != null || texCoordGen != null) {
                    texStateUnit = TextureUnitStateUnit.makeTextureUnitStateUnit(i, tu, this.stateUnitCache);
                    this.updateStateUnit(texStateUnit);
                }
            } else if (tu == null || texture == null && texAttribs == null && texCoordGen == null) {
                texStateUnit = TextureUnitStateUnit.makeTextureUnitStateUnit(i, null, null);
                this.updateStateUnit(texStateUnit);
            } else if (texture != null && texture.isChanged() || texAttribs != null && texAttribs.isChanged() || texCoordGen != null && texCoordGen.isChanged()) {
                texStateUnit.update(texture, texAttribs, texCoordGen);
                this.updateStateMap(texStateUnit);
            }
            texStateUnit.updateCachedStateId();
            this.translucent = this.translucent || texStateUnit.isTranslucent();
        }
        if (tuc < this.numValidTUs) {
            for (i = tuc; i < this.numValidTUs; ++i) {
                this.updateStateUnit(TextureUnitStateUnit.DEFAULT_UNIT[i]);
                this.updateStateMap(TextureUnitStateUnit.DEFAULT_UNIT[i]);
                this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]).updateCachedStateId();
            }
        }
        this.numValidTUs = tuc;
        if (app.isStatic()) {
            _SG_PrivilegedAccess.markStaticClean(app);
        }
    }
}

