/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing.sorting;

import java.util.Comparator;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.utility.comparator.Sorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrontToBackRenderBinSorter
extends RenderBinSorter
implements Comparator<RenderAtom<?>> {
    private final Plane viewPlane = new Plane();
    private final Vector3f tmpVec = new Vector3f();
    private final Point3f tmpPos = new Point3f();

    @Override
    public int compare(RenderAtom<?> atom1, RenderAtom<?> atom2) {
        if (atom1.getSquaredDistanceToView() < atom2.getSquaredDistanceToView()) {
            return 1;
        }
        if (atom1.getSquaredDistanceToView() > atom2.getSquaredDistanceToView()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public void updateDistancesToView(RenderBin renderBin, Transform3D viewTransform) {
        viewTransform.getMatrix4f().transform(Vector3f.NEGATIVE_Z_AXIS, this.tmpVec);
        this.viewPlane.setNormal(this.tmpVec);
        viewTransform.getTranslation(this.tmpPos);
        this.viewPlane.setD(this.tmpPos.distance(0.0f, 0.0f, 0.0f));
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            atoms.get(i).getPosition(this.tmpPos);
            float dist = this.viewPlane.distanceTo(this.tmpPos);
            atoms.get(i).setCompareIndicators(dist * dist, this.tmpPos.getZ(), null);
        }
    }

    @Override
    public void sortRenderBin(RenderBin renderBin, Transform3D viewTransform) {
        this.updateDistancesToView(renderBin, viewTransform);
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        Sorter.quickSort(atoms.getRawArray(), 0, atoms.size() - 1, this);
    }
}

