/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.Material;

public class MaterialStateUnit
extends StateUnit {
    public static final int STATE_TYPE = StateMap.newStateType();
    private static final StateMap MATERIAL_STATE_MAP = new StateMap();
    private static final MaterialStateUnit DEFAULT_MATERIAL = new MaterialStateUnit(new Material(false), true);
    private Material material;

    public final Material getMaterial() {
        return this.material;
    }

    public Material getNodeComponent() {
        return this.material;
    }

    public final boolean isTranslucent() {
        return false;
    }

    public final long getStateId() {
        return this.material.getStateId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( state-type: " + this.getStateType() + ", " + "state-ID: " + this.getStateId() + " )";
    }

    public final void update(Material mat) {
        this.material = mat;
        MATERIAL_STATE_MAP.assignState(this.material);
    }

    private MaterialStateUnit(Material mat, boolean isDefault) {
        super(STATE_TYPE, isDefault);
        this.update(mat);
    }

    public static MaterialStateUnit makeMaterialStateUnit(Material mat, StateUnit[] cache) {
        if (mat == null) {
            return DEFAULT_MATERIAL;
        }
        if (cache[STATE_TYPE] != null) {
            MaterialStateUnit stateUnit = (MaterialStateUnit)cache[STATE_TYPE];
            stateUnit.update(mat);
            return stateUnit;
        }
        MaterialStateUnit stateUnit = new MaterialStateUnit(mat, false);
        cache[MaterialStateUnit.STATE_TYPE] = stateUnit;
        return stateUnit;
    }
}

