/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.vecmath2.Point3f;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.utils.CopyListener;

public abstract class AbstractLODShape3D
extends Shape3D {
    private String[] lodNames = new String[16];
    private float[] minDistances = new float[16];
    private float[] maxDistances = new float[16];
    private int numLODs = 0;
    private int currentLOD = -1;
    private boolean isInitialized = false;

    public final float getMinDist(int index) {
        if (index >= this.numLODs) {
            throw new ArrayIndexOutOfBoundsException("There's no item with the index " + index);
        }
        return this.minDistances[index];
    }

    public final float getMaxDist(int index) {
        if (index >= this.numLODs) {
            throw new ArrayIndexOutOfBoundsException("There's no item with the index " + index);
        }
        return this.maxDistances[index];
    }

    public final String getLODName(int lod) {
        return this.lodNames[this.currentLOD];
    }

    public final int getNumLODs() {
        return this.numLODs;
    }

    private final int getCurrentLOD() {
        return this.currentLOD;
    }

    protected abstract void onLODChanged(int var1, int var2, String var3);

    public void updateLOD(Point3f viewPosition) {
        if (this.getNumLODs() == 0) {
            this.currentLOD = -1;
            return;
        }
        if (this.getCurrentLOD() < 0) {
            this.currentLOD = 0;
        }
        int oldLOD = this.getCurrentLOD();
        Point3f translation = Point3f.fromPool();
        this.getWorldTransform().getTranslation(translation);
        float dist = translation.distance(viewPosition);
        Point3f.toPool(translation);
        if (this.isInitialized) {
            if (dist < this.minDistances[oldLOD]) {
                for (int i = oldLOD; i >= 0; --i) {
                    if (!(dist <= this.maxDistances[i]) || !(dist >= this.minDistances[i])) continue;
                    this.currentLOD = i;
                    this.onLODChanged(oldLOD, this.currentLOD, this.lodNames[this.currentLOD]);
                    return;
                }
                this.currentLOD = -1;
            } else if (dist > this.maxDistances[oldLOD]) {
                for (int i = oldLOD; i < this.getNumLODs(); ++i) {
                    if (!(dist <= this.maxDistances[i]) || !(dist >= this.minDistances[i])) continue;
                    this.currentLOD = i;
                    this.onLODChanged(oldLOD, this.currentLOD, this.lodNames[this.currentLOD]);
                    return;
                }
                this.currentLOD = -1;
            }
        } else {
            this.currentLOD = -1;
            for (int i = 0; i < this.getNumLODs(); ++i) {
                if (!(dist <= this.maxDistances[i]) || !(dist >= this.minDistances[i])) continue;
                this.currentLOD = i;
                break;
            }
            if (this.currentLOD != -1) {
                this.onLODChanged(-1, this.currentLOD, this.lodNames[this.currentLOD]);
            }
            this.isInitialized = true;
        }
    }

    protected int addLOD(String name, float minDist, float maxDist) {
        if (minDist > maxDist) {
            throw new IllegalArgumentException("minDist (" + minDist + ") is greater than maxDist (" + maxDist + ")");
        }
        int level = -1;
        if (this.getNumLODs() == 0) {
            level = 0;
            this.minDistances[level] = minDist;
            this.maxDistances[level] = maxDist;
            this.currentLOD = level;
            this.lodNames = ArrayUtils.ensureCapacity(this.lodNames, String.class, 1);
            this.lodNames[level] = name;
        } else {
            for (int i = 0; i < this.getNumLODs(); ++i) {
                if (this.minDistances[i] > minDist) {
                    level = i;
                    continue;
                }
                if (!(this.maxDistances[i] < maxDist)) continue;
                level = i + 1;
            }
            if (level < 0) {
                throw new IllegalArgumentException("Don't know where to insert this item.");
            }
            if (level > 0 && this.minDistances[level - 1] > minDist) {
                throw new IllegalArgumentException("minDist MUST NOT overlap two items.");
            }
            if (level < this.getNumLODs() - 1 && this.maxDistances[level + 1] < maxDist) {
                throw new IllegalArgumentException("maxDist MUST NOT overlap two items.");
            }
            this.minDistances = ArrayUtils.ensureCapacity(this.minDistances, this.getNumLODs() + 1);
            this.maxDistances = ArrayUtils.ensureCapacity(this.maxDistances, this.getNumLODs() + 1);
            this.lodNames = ArrayUtils.ensureCapacity(this.lodNames, String.class, this.getNumLODs() + 1);
            if (level < this.getNumLODs()) {
                System.arraycopy(this.minDistances, level, this.minDistances, level + 1, this.getNumLODs() - level);
                System.arraycopy(this.maxDistances, level, this.maxDistances, level + 1, this.getNumLODs() - level);
                System.arraycopy(this.lodNames, level, this.lodNames, level + 1, this.getNumLODs() - level);
            }
            this.minDistances[level] = minDist;
            this.maxDistances[level] = maxDist;
            this.lodNames[level] = name;
        }
        ++this.numLODs;
        return level;
    }

    protected final int addLOD(float minDist, float maxDist) {
        return this.addLOD(null, minDist, maxDist);
    }

    protected abstract AbstractLODShape3D newInstance();

    protected void copy(Shape3D dst) {
        super.copy(dst);
        AbstractLODShape3D newShape = (AbstractLODShape3D)dst;
        if (newShape.lodNames.length != this.lodNames.length) {
            newShape.lodNames = new String[this.lodNames.length];
        }
        System.arraycopy(this.lodNames, 0, newShape.lodNames, 0, this.lodNames.length);
        if (newShape.minDistances.length != this.minDistances.length) {
            newShape.minDistances = new float[this.minDistances.length];
        }
        System.arraycopy(this.minDistances, 0, newShape.minDistances, 0, this.minDistances.length);
        if (newShape.maxDistances.length != this.maxDistances.length) {
            newShape.maxDistances = new float[this.maxDistances.length];
        }
        System.arraycopy(this.maxDistances, 0, newShape.maxDistances, 0, this.maxDistances.length);
        newShape.numLODs = this.numLODs;
        newShape.currentLOD = this.currentLOD;
        newShape.isInitialized = this.isInitialized;
    }

    public AbstractLODShape3D sharedCopy(CopyListener listener) {
        return (AbstractLODShape3D)super.sharedCopy(listener);
    }

    public AbstractLODShape3D sharedCopy() {
        return (AbstractLODShape3D)super.sharedCopy();
    }

    public AbstractLODShape3D(Geometry geometry, Appearance appearance) {
        super(geometry, appearance);
    }

    public AbstractLODShape3D(Geometry geometry) {
        this(geometry, null);
    }

    public AbstractLODShape3D() {
        this(null, null);
    }
}

