/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.vecmath2.Vector4f;
import org.xith3d.scenegraph.Shader;
import org.xith3d.utility.comparator.ComparatorHelper;

public abstract class AssemblyShader
extends Shader {
    protected Vector4f[] shaderProgramParameters = null;

    public final void setParameters(Vector4f[] parameters) {
        this.shaderProgramParameters = new Vector4f[parameters.length];
        System.arraycopy(parameters, 0, this.shaderProgramParameters, 0, parameters.length);
    }

    public final void setParameter(int index, Vector4f parameter) {
        this.shaderProgramParameters[index] = new Vector4f(parameter);
    }

    public final Vector4f[] getParameters() {
        return this.shaderProgramParameters;
    }

    public final Vector4f getParameter(int index) {
        return this.shaderProgramParameters[index];
    }

    public final int getNumParameters() {
        return this.shaderProgramParameters.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssemblyShader)) {
            return false;
        }
        AssemblyShader as = (AssemblyShader)o;
        if (this.getType() != as.getType()) {
            return false;
        }
        if (this.isEnabled() != as.isEnabled()) {
            return false;
        }
        if (ComparatorHelper.compare(this.getShaderCode(), as.getShaderCode()) != 0) {
            return false;
        }
        return ComparatorHelper.compare(this.shaderProgramParameters, as.shaderProgramParameters) == 0;
    }

    public int compareTo(Shader o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AssemblyShader)) {
            return -1;
        }
        if (this.getType().ordinal() < o.getType().ordinal()) {
            return -1;
        }
        if (this.getType().ordinal() > o.getType().ordinal()) {
            return 1;
        }
        AssemblyShader as2 = (AssemblyShader)o;
        int val = ComparatorHelper.compareBoolean(this.isEnabled(), as2.isEnabled());
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.getShaderCode(), as2.getShaderCode());
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.shaderProgramParameters, as2.shaderProgramParameters);
        if (val != 0) {
            return val;
        }
        return 0;
    }

    public AssemblyShader(Shader.ShaderType type, String shaderCode, Vector4f[] parameters, boolean enabled) {
        super(type, shaderCode, enabled);
        if (parameters != null) {
            this.shaderProgramParameters = new Vector4f[parameters.length];
            System.arraycopy(parameters, 0, this.shaderProgramParameters, 0, parameters.length);
        }
    }

    public AssemblyShader(Shader.ShaderType type, String shaderCode, Vector4f[] parameters) {
        this(type, shaderCode, parameters, true);
    }

    public AssemblyShader(Shader.ShaderType type, String shaderCode) {
        this(type, shaderCode, null, true);
    }

    public AssemblyShader(Shader.ShaderType type) {
        this(type, null, null, true);
    }
}

