/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;

public class DummyGroupNode
extends GroupNode {
    private Node[] childNodes;

    public void setParent(GroupNode parent) {
        if (parent != null) {
            parent.removeChild(this);
            throw new IllegalArgumentException("You cannot add a " + this.getClass().getName() + " to the SceneGraph.");
        }
    }

    protected boolean ensureCapacity(int minCapacity) {
        boolean result = super.ensureCapacity(minCapacity);
        if (result) {
            this.childNodes = this.children;
        }
        return result;
    }

    public void addChild(Node child, int index) {
        int oldLength;
        int n = oldLength = this.childNodes == null ? 0 : this.childNodes.length;
        if (index > oldLength) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.ensureCapacity(index + 1);
        this.childNodes[index] = child;
        ++this.numChildren;
    }

    public Node setChild(Node child, int index) {
        if (index >= this.childNodes.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Node old = this.childNodes[index];
        this.childNodes[index] = child;
        return old;
    }

    public Node removeChild(int index) {
        if (index >= this.childNodes.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Node old = this.childNodes[index];
        this.childNodes[index] = null;
        System.arraycopy(this.children, index + 1, this.children, index, this.numChildren - index - 1);
        --this.numChildren;
        return old;
    }

    public void updateBounds(boolean onlyDirty) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).updateBounds(onlyDirty);
        }
    }

    protected DummyGroupNode newInstance() {
        throw new UnsupportedOperationException("DummyGroupNode dos not support newInstance().");
    }

    public boolean traverse(DetailedTraversalCallback callback) {
        boolean result = false;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).traverse(callback)) continue;
            result = true;
        }
        return result;
    }

    public DummyGroupNode() {
        this.childNodes = this.children;
    }
}

