/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.WriteableTriangleContainer;
import org.openmali.spatial.polygons.Triangle;
import org.xith3d.scenegraph.IndexedGeometryArray;
import org.xith3d.scenegraph.NodeComponent;

public class IndexedQuadArray
extends IndexedGeometryArray
implements WriteableTriangleContainer {
    public final boolean isTriangulatable() {
        return true;
    }

    public final boolean isTriangulated() {
        return false;
    }

    public int getTriangleCount() {
        return this.getValidVertexCount() / 3;
    }

    public boolean setTriangle(int i, Triangle triangle) {
        int[] index = this.getIndex();
        int idx0 = i % 2 == 0 ? i * 4 + 0 : i * 4 + 1;
        return this.setTriangle(index[idx0 + 0], index[idx0 + 1], index[idx0 + 2], triangle);
    }

    public boolean getTriangle(int i, Triangle triangle) {
        int[] index = this.getIndex();
        int idx0 = i % 2 == 0 ? i * 4 + 0 : i * 4 + 1;
        return this.getTriangle(index[idx0 + 0], index[idx0 + 1], index[idx0 + 2], triangle);
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
    }

    public IndexedQuadArray cloneNodeComponent(boolean forceDuplicate) {
        IndexedQuadArray iqa = new IndexedQuadArray(this.getCoordinatesSize(), this.getVertexCount(), this.getIndexCount());
        iqa.duplicateNodeComponent(this, forceDuplicate);
        return iqa;
    }

    public IndexedQuadArray(int coordsSize, int vertexCount, int indexCount) {
        super(GeometryArrayType.QUADS, coordsSize, vertexCount, null, indexCount);
    }

    public IndexedQuadArray(int vertexCount, int indexCount) {
        this(3, vertexCount, indexCount);
    }
}

