/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.util.arrays.ArrayUtils;
import org.xith3d.render.ClipperInfo;
import org.xith3d.render.ScissorRect;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.Light;

public final class InheritedNodeAttributes {
    private static final int MAX_LIGHTS = 8;
    private static final int MAX_FOGS = 1;
    private Light[] lights = new Light[8];
    private int numLights = 0;
    private int numEffectiveLights = 0;
    private Fog[] fogs = new Fog[8];
    private int numFogs = 0;
    private int numEffectiveFogs = 0;
    private ScissorRect scissorRect = null;
    private ClipperInfo clipper = null;
    private boolean lightsDirty = false;
    private boolean fogsDirty = false;

    protected final void addLight(Light light) {
        if (this.lights.length <= this.numLights) {
            Light[] tmp = new Light[this.lights.length + 1];
            System.arraycopy(this.lights, 0, tmp, 0, this.lights.length);
            this.lights = tmp;
        }
        this.lights[this.numLights++] = light;
        this.numEffectiveLights = Math.min(this.numLights, 8);
        this.lightsDirty = true;
    }

    protected final void removeLight(Light light) {
        int index = ArrayUtils.indexOf(this.lights, light, true);
        if (index >= 0) {
            System.arraycopy(this.lights, index + 1, this.lights, index, this.numLights - index - 1);
            this.lights[--this.numLights] = null;
            this.numEffectiveLights = Math.min(this.numLights, 8);
        }
        this.lightsDirty = true;
    }

    public final int getLightsCount() {
        return this.numLights;
    }

    public final int getEffectiveLightsCount() {
        return this.numEffectiveLights;
    }

    public final Light getLight(int index) {
        return this.lights[index];
    }

    public final boolean getLightsDirty() {
        return this.lightsDirty;
    }

    public final void setLightsClean() {
        this.lightsDirty = false;
    }

    protected final void addFog(Fog fog) {
        if (this.fogs.length <= this.numFogs) {
            Fog[] tmp = new Fog[this.fogs.length + 1];
            System.arraycopy(this.fogs, 0, tmp, 0, this.fogs.length);
            this.fogs = tmp;
        }
        this.fogs[this.numFogs++] = fog;
        this.numEffectiveFogs = Math.min(this.numFogs, 1);
        this.fogsDirty = true;
    }

    protected final void removeFog(Fog fog) {
        int index = ArrayUtils.indexOf(this.fogs, fog, true);
        if (index >= 0) {
            System.arraycopy(this.fogs, index + 1, this.fogs, index, this.numFogs - index - 1);
            this.fogs[--this.numFogs] = null;
            this.numEffectiveFogs = Math.min(this.numFogs, 1);
        }
        this.fogsDirty = true;
    }

    public final int getFogsCount() {
        return this.numFogs;
    }

    public final int getEffectiveFogsCount() {
        return this.numEffectiveFogs;
    }

    public final Fog getFog(int index) {
        return this.fogs[index];
    }

    public final boolean getFogsDirty() {
        return this.fogsDirty;
    }

    public final void setFogsClean() {
        this.fogsDirty = false;
    }

    protected final void setScissorRect(ScissorRect scissorRect) {
        this.scissorRect = scissorRect;
    }

    public final ScissorRect getScissorRect() {
        return this.scissorRect;
    }

    protected final void setClipper(ClipperInfo clipper) {
        this.clipper = clipper;
    }

    public final ClipperInfo getClipper() {
        return this.clipper;
    }

    protected void merge(InheritedNodeAttributes toMerge) {
        int i;
        for (i = 0; i < toMerge.getLightsCount(); ++i) {
            Light light = toMerge.getLight(i);
            if (ArrayUtils.contains(this.lights, light, true)) continue;
            this.addLight(light);
        }
        for (i = 0; i < toMerge.getFogsCount(); ++i) {
            Fog fog = toMerge.getFog(i);
            if (ArrayUtils.contains(this.fogs, fog, true)) continue;
            this.addFog(fog);
        }
        if (this.scissorRect == null) {
            this.scissorRect = toMerge.scissorRect;
        }
        if (this.clipper == null) {
            this.clipper = toMerge.clipper;
        }
    }

    protected void unmerge(InheritedNodeAttributes toUnmerge) {
        int i;
        for (i = 0; i < toUnmerge.getLightsCount(); ++i) {
            this.removeLight(toUnmerge.getLight(i));
        }
        for (i = 0; i < toUnmerge.getFogsCount(); ++i) {
            this.removeFog(toUnmerge.getFog(i));
        }
        if (this.scissorRect == toUnmerge.getScissorRect()) {
            this.scissorRect = null;
        }
        if (this.clipper == toUnmerge.getClipper()) {
            this.clipper = null;
        }
    }
}

