/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.datatypes.Enableable;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.BoundingLeaf;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;

public abstract class Light
extends Leaf
implements Enableable {
    private static int nextLightID = 1;
    public static final Colorf DEFAULT_COLOR = Colorf.WHITE;
    private final int lightID = nextLightID++;
    private Bounds influencingBounds = null;
    private BoundingLeaf boundingLeaf = null;
    private Colorf color = new Colorf();
    private boolean enabled;

    public final int getLightID() {
        return this.lightID;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setPickable(boolean value) {
    }

    public void setColor(Colorf color) {
        if (color == null) {
            throw new IllegalArgumentException("color must not be null");
        }
        this.color.set(color);
    }

    public void setColor(float r, float g, float b) {
        this.color.set(r, g, b);
    }

    public final Colorf getColor() {
        return this.color.getReadOnly();
    }

    public void setInfluencingBounds(Bounds region) {
        this.influencingBounds = region;
    }

    public final Bounds getInfluencingBounds() {
        return this.influencingBounds;
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf;
    }

    public final BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf;
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public boolean traverse(DetailedTraversalCallback callback) {
        return callback.traversalOperationCommon(this) && callback.traversalOperation(this) && callback.traversalOperationAfter(this) && callback.traversalOperationCommonAfter(this);
    }

    protected static final Colorf getCol(Colorf col) {
        return col == null ? DEFAULT_COLOR : col;
    }

    public Light(boolean enabled, float colorR, float colorG, float colorB) {
        this.color.set(colorR, colorG, colorB);
        this.enabled = enabled;
        super.setPickable(false);
    }

    public Light(float colorR, float colorG, float colorB) {
        this(true, colorR, colorG, colorB);
    }

    public Light(boolean enabled) {
        this(enabled, DEFAULT_COLOR.getRed(), DEFAULT_COLOR.getGreen(), DEFAULT_COLOR.getBlue());
    }

    public Light() {
        this(true);
    }
}

