/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.LinePattern;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineAttributes
extends NodeComponent
implements StateTrackable<LineAttributes> {
    private StateNode stateNode = null;
    private long stateId = -1L;
    public static final LinePattern PATTERN_SOLID = LinePattern.SOLID;
    public static final LinePattern PATTERN_DASH = LinePattern.DASHED;
    public static final LinePattern PATTERN_DOT = LinePattern.DOTTED;
    public static final LinePattern PATTERN_DASH_DOT = LinePattern.DASHED_DOTTED;
    public static final LinePattern PATTERN_USER_DEFINED = LinePattern.USER_DEFINED;
    private float width = 1.0f;
    private LinePattern pattern = LinePattern.SOLID;
    private int patternMask = 65535;
    private int patternScaleFactor = 1;
    private boolean antialiasing = false;
    private boolean sortEnabled = true;

    public final void setLineWidth(float lineWidth) {
        this.width = lineWidth;
        this.setChanged(true);
    }

    public final float getLineWidth() {
        return this.width;
    }

    public final void setLineAntialiasingEnabled(boolean state) {
        this.antialiasing = state;
        this.setChanged(true);
    }

    public final boolean isLineAntialiasingEnabled() {
        return this.antialiasing;
    }

    public final void setLinePattern(LinePattern linePattern) {
        this.pattern = linePattern;
        this.setChanged(true);
    }

    public final LinePattern getLinePattern() {
        return this.pattern;
    }

    public final void setPatternMask(int patternMask) {
        this.patternMask = patternMask;
        this.setChanged(true);
    }

    public final int getPatternMask() {
        return this.patternMask;
    }

    public final void setPatternScaleFactor(int factor) {
        this.patternScaleFactor = factor;
        this.setChanged(true);
    }

    public final int getPatternScaleFactor() {
        return this.patternScaleFactor;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
        this.setChanged(true);
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    @Override
    public final void setStateNode(StateNode node2) {
        this.stateNode = node2;
        this.stateId = node2.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public LineAttributes getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineAttributes)) {
            return false;
        }
        LineAttributes lo = (LineAttributes)o;
        if (this.width != lo.width) {
            return false;
        }
        if (this.pattern != lo.pattern) {
            return false;
        }
        if (this.patternMask != lo.patternMask) {
            return false;
        }
        if (this.patternScaleFactor != lo.patternScaleFactor) {
            return false;
        }
        if (this.antialiasing != lo.antialiasing) {
            return false;
        }
        return this.sortEnabled == lo.sortEnabled;
    }

    @Override
    public int compareTo(LineAttributes o) {
        if (this == o) {
            return 0;
        }
        if (this.width < o.width) {
            return -1;
        }
        if (this.width > o.width) {
            return 1;
        }
        if (this.pattern.ordinal() < o.pattern.ordinal()) {
            return -1;
        }
        if (this.pattern.ordinal() > o.pattern.ordinal()) {
            return 1;
        }
        if (this.patternMask < o.patternMask) {
            return -1;
        }
        if (this.patternMask > o.patternMask) {
            return 1;
        }
        if (this.patternScaleFactor < o.patternScaleFactor) {
            return -1;
        }
        if (this.patternScaleFactor > o.patternScaleFactor) {
            return 1;
        }
        int val = ComparatorHelper.compareBoolean(this.antialiasing, o.antialiasing);
        if (val != 0) {
            return val;
        }
        return ComparatorHelper.compareBoolean(this.sortEnabled, o.sortEnabled);
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        LineAttributes o = (LineAttributes)original;
        this.width = o.getLineWidth();
        this.pattern = o.getLinePattern();
        this.patternMask = o.getPatternMask();
        this.patternScaleFactor = o.getPatternScaleFactor();
        this.antialiasing = o.isLineAntialiasingEnabled();
    }

    @Override
    public LineAttributes cloneNodeComponent(boolean forceDuplicate) {
        LineAttributes la = new LineAttributes();
        la.duplicateNodeComponent(this, forceDuplicate);
        return la;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public LineAttributes() {
        super(false);
    }

    public LineAttributes(float lineWidth, LinePattern linePattern, boolean antialiasing) {
        this();
        this.width = lineWidth;
        this.pattern = linePattern;
        this.antialiasing = antialiasing;
    }

    public LineAttributes(float lineWidth, LinePattern linePattern, int patternScaleFactor, int patternMask, boolean antialiasing) {
        this(lineWidth, linePattern, antialiasing);
        this.patternScaleFactor = patternScaleFactor;
        this.patternMask = patternMask;
    }
}

