/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.Stack;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.spatial.SpatialNode;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingPolytope;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.Clipper;
import org.xith3d.render.ClipperInfo;
import org.xith3d.render.ScissorRect;
import org.xith3d.render.preprocessing.OrderedState;
import org.xith3d.scenegraph.Billboard;
import org.xith3d.scenegraph.BoundsTypeHint;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.IllegalSceneGraphOperation;
import org.xith3d.scenegraph.InheritedNodeAttributes;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.OrderedGroup;
import org.xith3d.scenegraph.SceneGraphObject;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.UpdatableNode;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;
import org.xith3d.scenegraph.traversal.TraversalCallback;
import org.xith3d.scenegraph.utils.CopyListener;
import org.xith3d.utility.logging.X3DLog;

public abstract class Node
extends SceneGraphObject
implements SpatialNode {
    private final boolean is_billboard = this instanceof Billboard;
    private final boolean is_updatableNode = this instanceof UpdatableNode;
    private static boolean defaultPickable = true;
    private transient boolean pickable = defaultPickable;
    private transient boolean renderable = true;
    private transient GroupNode parent = null;
    protected transient boolean boundsAutoCompute = true;
    private transient boolean ignoreBounds = false;
    protected TransformGroup transformGroup = null;
    private ScenegraphModificationsListener modListener = null;
    private Node orderedChild = null;
    private OrderedState orderedState = null;
    private boolean isOccluder = false;
    private Object shadowAttachment = null;
    private final InheritedNodeAttributes inheritedNodeAttribs = new InheritedNodeAttributes();
    protected Bounds bounds;
    protected Bounds untransformedBounds;
    private BoundsType boundsType = null;
    private static BoundsTypeHint boundsTypeHint = BoundsTypeHint.SPHERE;
    protected BoundsTypeHint instanceBoundsTypeHint;
    private Bounds worldBounds;
    private boolean showBounds = false;
    protected boolean boundsDirty = false;
    protected static boolean globalIgnoreBounds = false;
    private static Stack<Boolean> globalIgnoreBoundsStack = new Stack();
    private Object treeCell = null;

    public void setTreeCell(Object treeCell) {
        this.treeCell = treeCell;
    }

    public Object getTreeCell() {
        return this.treeCell;
    }

    public static void setBoundsTypeHint(BoundsTypeHint bth) {
        if (bth == null) {
            throw new IllegalArgumentException("BoundsTypeHint must not be null");
        }
        boundsTypeHint = bth;
    }

    public static BoundsTypeHint getBoundsTypeHint() {
        return boundsTypeHint;
    }

    public final boolean isBillboard() {
        return this.is_billboard;
    }

    public final boolean isUpdatableNode() {
        return this.is_updatableNode;
    }

    public static boolean getDefaultPickable() {
        return defaultPickable;
    }

    public void setPickable(boolean value) {
        this.pickable = value;
        if (this.modListener != null) {
            this.modListener.onNodePropertyChanged(this, "Pickable");
        }
    }

    public final boolean isPickable() {
        return this.pickable;
    }

    public static final void setPickableRecursive(Node node2, boolean pickable) {
        node2.setPickable(pickable);
        if (node2 instanceof GroupNode) {
            GroupNode group = (GroupNode)node2;
            int numChildren = group.numChildren();
            for (int i = 0; i < numChildren; ++i) {
                Node child = group.getChild(i);
                Node.setPickableRecursive(child, pickable);
            }
        }
    }

    public final void setPickableRecursive(boolean pickable) {
        Node.setPickableRecursive(this, pickable);
    }

    public final void setRenderable(boolean value) {
        this.renderable = value;
        if (this.modListener != null) {
            this.modListener.onNodePropertyChanged(this, "Renderable");
        }
    }

    public final boolean isRenderable() {
        return this.renderable;
    }

    public final InheritedNodeAttributes getInheritedNodeAttributes() {
        return this.inheritedNodeAttribs;
    }

    public void setModListener(ScenegraphModificationsListener modListener) {
        this.modListener = modListener;
    }

    public final ScenegraphModificationsListener getModListener() {
        return this.modListener;
    }

    public void setIgnoreBounds(boolean ignoreBounds) {
        if (ignoreBounds == this.ignoreBounds) {
            return;
        }
        this.ignoreBounds = ignoreBounds;
    }

    public final boolean isIgnoreBounds() {
        return this.ignoreBounds;
    }

    public static void setGlobalIgnoreBounds(boolean val) {
        globalIgnoreBounds = val;
    }

    public static void pushGlobalIgnoreBounds(boolean val) {
        globalIgnoreBoundsStack.push(val);
        globalIgnoreBounds = val;
    }

    public static boolean popGlobalIgnoreBounds() {
        if (globalIgnoreBoundsStack.size() > 1) {
            globalIgnoreBoundsStack.pop();
        }
        globalIgnoreBounds = globalIgnoreBoundsStack.peek();
        return globalIgnoreBounds;
    }

    protected void mergeInheritedNodes(InheritedNodeAttributes in) {
        if (in != this.getInheritedNodeAttributes()) {
            this.getInheritedNodeAttributes().merge(in);
        }
    }

    protected void unmergeInheritedNodes(InheritedNodeAttributes in) {
        if (in != this.getInheritedNodeAttributes()) {
            this.getInheritedNodeAttributes().unmerge(in);
        }
    }

    protected void unmergeInheritedLight(Light light) {
        this.getInheritedNodeAttributes().removeLight(light);
    }

    protected void unmergeInheritedFog(Fog fog) {
        this.getInheritedNodeAttributes().removeFog(fog);
    }

    protected void mergeInheritedScissorRect(ScissorRect scissorRect) {
        this.getInheritedNodeAttributes().setScissorRect(scissorRect);
    }

    protected void mergeInheritedClipper(Clipper clipper, ClipperInfo clipperInfo) {
        this.getInheritedNodeAttributes().setClipper(clipperInfo);
    }

    public final void setBoundsAutoCompute(boolean autocompute) {
        this.boundsAutoCompute = autocompute;
    }

    public final boolean getBoundsAutoCompute() {
        return this.boundsAutoCompute;
    }

    public final void getWorldTransform(Transform3D transform3D) {
        if (this.transformGroup != null) {
            transform3D.set(this.transformGroup.getWorldTransform());
        } else {
            transform3D.set(Transform3D.IDENTITY);
        }
    }

    public Transform3D getWorldTransform() {
        if (this.transformGroup == null) {
            return Transform3D.IDENTITY;
        }
        return this.transformGroup.getInlinedWorldTransform();
    }

    public final boolean getShowBounds() {
        return this.showBounds;
    }

    public void setShowBounds(boolean show) {
        this.showBounds = show;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
        if (bounds != null) {
            if (this.untransformedBounds == null) {
                this.untransformedBounds = bounds instanceof BoundingBox ? new BoundingBox(bounds) : (bounds instanceof BoundingPolytope ? new BoundingPolytope(bounds) : new BoundingSphere(bounds));
            } else if (bounds instanceof BoundingBox) {
                if (this.untransformedBounds instanceof BoundingBox) {
                    this.untransformedBounds.set(bounds);
                } else {
                    this.untransformedBounds = new BoundingBox(bounds);
                }
            } else if (bounds instanceof BoundingPolytope) {
                if (this.untransformedBounds instanceof BoundingPolytope) {
                    this.untransformedBounds.set(bounds);
                } else {
                    this.untransformedBounds = new BoundingPolytope(bounds);
                }
            } else {
                this.untransformedBounds.set(bounds);
            }
            if (this.worldBounds == null) {
                this.worldBounds = bounds instanceof BoundingBox ? new BoundingBox(bounds) : (bounds instanceof BoundingPolytope ? new BoundingPolytope(bounds) : new BoundingSphere(bounds));
            } else if (bounds instanceof BoundingBox) {
                if (this.worldBounds instanceof BoundingBox) {
                    this.worldBounds.set(bounds);
                } else {
                    this.worldBounds = new BoundingBox(bounds);
                }
            } else if (bounds instanceof BoundingPolytope) {
                if (this.worldBounds instanceof BoundingPolytope) {
                    this.worldBounds.set(bounds);
                } else {
                    this.worldBounds = new BoundingPolytope(bounds);
                }
            } else {
                this.worldBounds.set(bounds);
            }
        }
        this.boundsType = bounds == null ? null : (bounds instanceof BoundingBox ? BoundsType.AABB : (bounds instanceof BoundingPolytope ? BoundsType.POLYTOPE : BoundsType.SPHERE));
        this.setBoundsDirtyUpward();
        this.updateBounds(true);
    }

    public final BoundsType getBoundsType() {
        return this.boundsType;
    }

    public final Bounds getWorldBounds() {
        return this.worldBounds;
    }

    public final Bounds getBounds() {
        return this.bounds;
    }

    public final GroupNode getParent() {
        return this.parent;
    }

    public final BranchGroup getRoot() {
        if (this.getParent() != null) {
            return this.getParent().getRoot();
        }
        if (this instanceof BranchGroup) {
            return (BranchGroup)this;
        }
        return null;
    }

    public final Node getOrderedChild() {
        return this.orderedChild;
    }

    public final void setOrderedChild(Node orderedChild) {
        this.orderedChild = orderedChild;
    }

    public final OrderedState getOrderedState() {
        if (this.orderedState != null) {
            return this.orderedState;
        }
        if (this.orderedChild != null) {
            return this.orderedChild.getOrderedState();
        }
        return null;
    }

    protected final void setTransformGroup(TransformGroup tg) {
        this.transformGroup = tg;
    }

    public final TransformGroup getTransformGroup() {
        return this.transformGroup;
    }

    protected void setBoundsDirty() {
        this.setBoundsDirtyUpward();
    }

    protected void setBoundsDirtyUpward() {
        this.boundsDirty = true;
        if (this.parent != null) {
            this.parent.setBoundsDirtyUpward();
        }
    }

    public final void detach() {
        GroupNode parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    protected void setParent(GroupNode parent) {
        if (this.parent != null && parent != null) {
            throw new IllegalSceneGraphOperation("Illegal attempt to set the parent of this Node (name: '" + this.getName() + "', " + this + ") as it already has a parent (existing parent name: '" + this.parent.getName() + "', " + this.parent + ") and this would violate the directed acyclic graph constraint of the scenegraph.");
        }
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "Node::setParent()");
        this.parent = parent;
        if (parent == null || !parent.isLive()) {
            this.setLive(false);
        } else if (parent.isLive()) {
            this.setLive(true);
        }
        this.updateTransformGroup();
        this.updateWorldTransform();
        this.updateOrderedChild();
        if (parent != null) {
            if (!parent.boundsDirty) {
                parent.expandBounds(this, true);
            } else {
                parent.updateBoundsCheap(true, false, true, false);
            }
        }
        ProfileTimer.endProfile();
    }

    public void printBounds(boolean childrenToo) {
        this.printBounds(childrenToo, 0);
    }

    private void printBounds(boolean childrenToo, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("   ");
        }
        System.out.println(this.getName() + " " + this.getWorldBounds());
        if (this.isLive()) {
            System.out.println(" (live)");
        }
        if (childrenToo && this instanceof GroupNode) {
            GroupNode group = (GroupNode)this;
            int numChildren = group.numChildren();
            Bounds[] childrenBounds = new Bounds[numChildren];
            for (int i = 0; i < numChildren; ++i) {
                Node n = group.getChild(i);
                n.printBounds(childrenToo, indent + 1);
                childrenBounds[i] = n.getBounds();
            }
            this.bounds.set(childrenBounds);
        }
    }

    private final void setAllWorldBounds(Bounds b) {
        this.worldBounds.set(b);
    }

    protected void updateBoundsCheap(boolean onlyDirty, boolean childrenToo, boolean parentToo, boolean onlyWorld) {
        if (this.isIgnoreBounds() || !this.boundsDirty && onlyDirty) {
            return;
        }
        this.worldBounds.set(this.untransformedBounds);
        this.worldBounds.transform(this.getWorldTransform().getMatrix4f());
        if (!this.boundsAutoCompute && this instanceof GroupNode) {
            GroupNode group = (GroupNode)this;
            int numChildren = group.numChildren();
            for (int i = 0; i < numChildren; ++i) {
                group.getChild(i).setAllWorldBounds(this.worldBounds);
            }
        }
        this.boundsDirty = false;
        GroupNode parent = this.getParent();
        if (parentToo && parent != null) {
            parent.boundsDirty = true;
            parent.updateBoundsCheap(onlyDirty, false, parentToo, onlyWorld);
        }
    }

    public void updateBounds(boolean onlyDirty) {
        this.updateBoundsCheap(onlyDirty, true, true, false);
    }

    public final void setIsOccluder(boolean isOccluder) {
        ShadowFactory shadowFact;
        EffectFactory effFact;
        boolean changed = this.isOccluder != isOccluder;
        this.isOccluder = isOccluder;
        if (changed && (effFact = EffectFactory.getInstance()) != null && (shadowFact = effFact.getShadowFactory()) != null) {
            shadowFact.onOccluderStateChanged(this, isOccluder);
        }
    }

    public final boolean isOccluder() {
        return this.isOccluder;
    }

    public final void setShadowAttachment(Object shadowAttachment) {
        this.shadowAttachment = shadowAttachment;
    }

    public final Object getShadowAttachment() {
        return this.shadowAttachment;
    }

    public void updateWorldTransform() {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "Node::updateWorldTransform");
        if (this instanceof TransformGroup) {
            TransformGroup tg = (TransformGroup)this;
            Transform3D t = tg.getWorldTransform();
            if (this.getTransformGroup() == null) {
                t.set(tg.getTransform());
            } else {
                t.set(tg.getTransform());
                this.getTransformGroup().getWorldTransform().transform(t);
            }
        }
        if (this instanceof GroupNode) {
            GroupNode g = (GroupNode)this;
            int n = g.numChildren();
            for (int i = 0; i < n; ++i) {
                g.getChild(i).updateWorldTransform();
            }
        }
        ProfileTimer.endProfile();
    }

    public final void updateTransformGroup() {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "Node::updateTransformGroup");
        if (this.parent == null) {
            this.setTransformGroup(null);
        } else if (this.parent instanceof TransformGroup) {
            this.setTransformGroup((TransformGroup)this.parent);
        } else {
            this.setTransformGroup(this.parent.getTransformGroup());
        }
        if (this instanceof GroupNode) {
            GroupNode g = (GroupNode)this;
            int n = g.numChildren();
            for (int i = 0; i < n; ++i) {
                g.getChild(i).updateTransformGroup();
            }
        }
        ProfileTimer.endProfile();
    }

    protected final void updateOrderedChild() {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "Node::updateOrderedChild");
        if (this.parent == null) {
            this.setOrderedChild(null);
        } else if (this.parent instanceof OrderedGroup) {
            OrderedState os = this.parent.getOrderedState();
            os = os == null ? new OrderedState() : (OrderedState)os.clone();
            os.addDepth(((OrderedGroup)this.parent).allocateOrderedId());
            this.orderedState = os;
            this.setOrderedChild(this);
        } else {
            this.setOrderedChild(this.parent.getOrderedChild());
        }
        if (this instanceof GroupNode) {
            GroupNode group = (GroupNode)this;
            int numChildren = group.numChildren();
            for (int i = 0; i < numChildren; ++i) {
                group.getChild(i).updateOrderedChild();
            }
        }
        ProfileTimer.endProfile();
    }

    public Node cloneNode(boolean forceDuplicate) {
        try {
            Node node2 = (Node)this.getClass().newInstance();
            node2.duplicateNode(this, forceDuplicate);
            return node2;
        }
        catch (Exception ex) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(ex);
            throw runtimeException;
        }
    }

    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
    }

    public Node sharedCopy(CopyListener listener) {
        throw new UnsupportedOperationException("sharedCopy is not yet implemented for " + this.getClass().getName());
    }

    public Node sharedCopy() {
        return this.sharedCopy(null);
    }

    public void absorbDetails(Node node2) {
        throw new UnsupportedOperationException("absorbDetails is not yet implemented for " + this.getClass().getName());
    }

    public static void setDefaultPickable(boolean value) {
        defaultPickable = value;
    }

    public abstract void freeOpenGLResources(CanvasPeer var1);

    public final void freeOpenGLResources(Canvas3D canvas) {
        if (canvas.getPeer() == null) {
            throw new Error("The given Canvas3D is not linked to a CanvasPeer.");
        }
        this.freeOpenGLResources(canvas.getPeer());
    }

    protected final String getIndentString(int indent) {
        char[] spaces = new char[indent * 2];
        for (int i = 0; i < spaces.length; ++i) {
            spaces[i] = 32;
        }
        return new String(spaces);
    }

    protected abstract void dump(int var1);

    public boolean traverse(TraversalCallback callback) {
        return callback.traversalOperation(this);
    }

    public abstract boolean traverse(DetailedTraversalCallback var1);

    protected Node(boolean initializeBounds) {
        if (initializeBounds) {
            this.instanceBoundsTypeHint = boundsTypeHint;
            this.ignoreBounds = globalIgnoreBounds;
            if (!globalIgnoreBounds) {
                switch (this.instanceBoundsTypeHint) {
                    case AABB: {
                        this.bounds = new BoundingBox();
                        this.untransformedBounds = new BoundingBox();
                        this.worldBounds = new BoundingBox();
                        this.boundsType = BoundsType.AABB;
                        break;
                    }
                    case POLYTOPE: {
                        throw new Error("BoundingPolytopes are not yet supported");
                    }
                    case NONE: {
                        this.bounds = null;
                        this.untransformedBounds = null;
                        this.worldBounds = null;
                        this.boundsType = BoundsType.POLYTOPE;
                        break;
                    }
                    default: {
                        this.bounds = new BoundingSphere();
                        this.untransformedBounds = new BoundingSphere();
                        this.worldBounds = new BoundingSphere();
                        this.boundsType = BoundsType.SPHERE;
                        break;
                    }
                }
            }
        } else {
            this.instanceBoundsTypeHint = null;
            this.ignoreBounds = true;
            this.bounds = null;
            this.untransformedBounds = null;
            this.worldBounds = null;
            this.boundsType = null;
        }
    }

    public Node() {
        this(true);
    }

    static {
        globalIgnoreBoundsStack.push(globalIgnoreBounds);
    }
}

