/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointAttributes
extends NodeComponent
implements StateTrackable<PointAttributes> {
    private StateNode stateNode = null;
    private long stateId = -1L;
    private float size = 1.0f;
    private boolean antialiasing = false;
    private boolean sortEnabled = true;

    public final void setPointSize(float pointSize) {
        this.size = pointSize;
        this.setChanged(true);
    }

    public final float getPointSize() {
        return this.size;
    }

    public final void setPointAntialiasingEnabled(boolean state) {
        this.antialiasing = state;
        this.setChanged(true);
    }

    public final boolean isPointAntialiasingEnabled() {
        return this.antialiasing;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
        this.setChanged(true);
    }

    public final boolean isSortEnabled() {
        return this.sortEnabled;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        PointAttributes o = (PointAttributes)original;
        this.setPointSize(o.getPointSize());
        this.setPointAntialiasingEnabled(o.isPointAntialiasingEnabled());
    }

    @Override
    public PointAttributes cloneNodeComponent(boolean forceDuplicate) {
        PointAttributes pa = new PointAttributes();
        pa.duplicateNodeComponent(this, forceDuplicate);
        return pa;
    }

    @Override
    public final void setStateNode(StateNode node2) {
        this.stateNode = node2;
        this.stateId = node2.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public PointAttributes getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointAttributes)) {
            return false;
        }
        PointAttributes po = (PointAttributes)o;
        if (this.size != po.size) {
            return false;
        }
        if (this.antialiasing != po.antialiasing) {
            return false;
        }
        return this.sortEnabled == po.sortEnabled;
    }

    @Override
    public int compareTo(PointAttributes o) {
        if (this == o) {
            return 0;
        }
        if (this.size < o.size) {
            return -1;
        }
        if (this.size > o.size) {
            return 1;
        }
        int val = ComparatorHelper.compareBoolean(this.antialiasing, o.antialiasing);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareBoolean(this.sortEnabled, o.sortEnabled);
        return val;
    }

    public PointAttributes() {
        super(false);
    }

    public PointAttributes(float pointSize, boolean antialiasing) {
        this();
        this.size = pointSize;
        this.antialiasing = antialiasing;
    }
}

