/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointLight
extends Light {
    public static final Point3f DEFAULT_LOCATION = Point3f.newReadOnly(0.0f, 0.0f, 0.0f);
    public static final Tuple3f DEFAULT_ATTENUATION = Tuple3f.newReadOnly(1.0f, 0.0f, 0.0f);
    private Node trackedNode = null;
    private Point3f location = new Point3f(DEFAULT_LOCATION);
    private Tuple3f attenuation = new Tuple3f(DEFAULT_ATTENUATION);

    public void setTrackedNode(Node node2) {
        this.trackedNode = node2;
    }

    public final Node getTrackedNode() {
        return this.trackedNode;
    }

    public Point3f setLocation(float x, float y, float z) {
        this.location.set(x, y, z);
        return this.location;
    }

    public final Point3f setLocation(Tuple3f location) {
        return this.setLocation(location.getX(), location.getY(), location.getZ());
    }

    public final Point3f getLocation() {
        return this.location;
    }

    public final <T extends Tuple3f> T getLocation(T location) {
        location.set((TupleNf)this.location);
        return location;
    }

    public final void getComputedLocation(Point3f location) {
        if (this.getTrackedNode() == null) {
            this.getLocation(location);
        } else {
            this.getTrackedNode().getWorldTransform().transform(this.getLocation(), location);
        }
    }

    public Tuple3f setAttenuation(float attConstant, float attLinear, float attQuadratic) {
        this.attenuation.set(attConstant, attLinear, attQuadratic);
        return this.attenuation;
    }

    public final Tuple3f setAttenuation(Tuple3f attenuation) {
        this.attenuation.set((TupleNf)attenuation);
        return attenuation;
    }

    public final Tuple3f getAttenuation() {
        return this.attenuation;
    }

    public final Tuple3f getAttenuation(Tuple3f attenuation) {
        attenuation.set((TupleNf)this.attenuation);
        return attenuation;
    }

    public PointLight(boolean enabled, float colorR, float colorG, float colorB, float locX, float locY, float locZ, float attenuationConstant, float attenuationLinear, float attenuationQuadratic) {
        super(enabled, colorR, colorG, colorB);
        this.location.set(locX, locY, locZ);
        this.attenuation.set(attenuationConstant, attenuationLinear, attenuationQuadratic);
    }

    public PointLight(float colorR, float colorG, float colorB, float locX, float locY, float locZ, float attenuationConstant, float attenuationLinear, float attenuationQuadratic) {
        this(true, colorR, colorG, colorB, locX, locY, locZ, attenuationConstant, attenuationLinear, attenuationQuadratic);
    }

    public PointLight(boolean enabled, float colorR, float colorG, float colorB, float locX, float locY, float locZ, float attenuation) {
        this(enabled, colorR, colorG, colorB, locX, locY, locZ, attenuation, attenuation, attenuation);
    }

    public PointLight(float colorR, float colorG, float colorB, float locX, float locY, float locZ, float attenuation) {
        this(true, colorR, colorG, colorB, locX, locY, locZ, attenuation, attenuation, attenuation);
    }

    protected static final Tuple3f getAtt(Tuple3f att) {
        return att == null ? DEFAULT_ATTENUATION : att;
    }

    protected static final Tuple3f getLoc(Tuple3f loc) {
        return loc == null ? DEFAULT_LOCATION : loc;
    }

    public PointLight(boolean enabled, Colorf color, Tuple3f location, Tuple3f attenuation) {
        this(enabled, PointLight.getCol(color).getRed(), PointLight.getCol(color).getGreen(), PointLight.getCol(color).getBlue(), PointLight.getLoc(location).getX(), PointLight.getLoc(location).getY(), PointLight.getLoc(location).getZ(), PointLight.getAtt(attenuation).getX(), PointLight.getAtt(attenuation).getY(), PointLight.getAtt(attenuation).getZ());
    }

    public PointLight(Colorf color, Tuple3f location, Tuple3f attenuation) {
        this(true, color, location, attenuation);
    }

    public PointLight(boolean enabled, Colorf color, Tuple3f location, float attenuation) {
        this(enabled, PointLight.getCol(color).getRed(), PointLight.getCol(color).getGreen(), PointLight.getCol(color).getBlue(), PointLight.getLoc(location).getX(), PointLight.getLoc(location).getY(), PointLight.getLoc(location).getZ(), attenuation, attenuation, attenuation);
    }

    public PointLight(Colorf color, Tuple3f location, float attenuation) {
        this(true, color, location, attenuation);
    }

    public PointLight(boolean enabled, float colorR, float colorG, float colorB, Node trackedNode, float attenuationConstant, float attenuationLinear, float attenuationQuadratic) {
        this(enabled, colorR, colorG, colorB, DEFAULT_LOCATION.getX(), DEFAULT_LOCATION.getY(), DEFAULT_LOCATION.getZ(), attenuationConstant, attenuationLinear, attenuationQuadratic);
        this.setTrackedNode(trackedNode);
    }

    public PointLight(float colorR, float colorG, float colorB, Node trackedNode, float attenuationConstant, float attenuationLinear, float attenuationQuadratic) {
        this(true, colorR, colorG, colorB, trackedNode, attenuationLinear, attenuationLinear, attenuationQuadratic);
    }

    public PointLight(boolean enabled, float colorR, float colorG, float colorB, Node trackedNode, float attenuation) {
        this(enabled, colorR, colorG, colorB, trackedNode, attenuation, attenuation, attenuation);
    }

    public PointLight(float colorR, float colorG, float colorB, Node trackedNode, float attenuation) {
        this(true, colorR, colorG, colorB, trackedNode, attenuation);
    }

    public PointLight(boolean enabled, Colorf color, Node trackedNode, Tuple3f attenuation) {
        this(enabled, color, (Tuple3f)DEFAULT_LOCATION, attenuation);
        this.setTrackedNode(trackedNode);
    }

    public PointLight(Colorf color, Node trackedNode, Tuple3f attenuation) {
        this(true, color, trackedNode, attenuation);
    }

    public PointLight(boolean enabled, Colorf color, Node trackedNode, float attenuation) {
        this(enabled, color, (Tuple3f)DEFAULT_LOCATION, attenuation);
        this.setTrackedNode(trackedNode);
    }

    public PointLight(Colorf color, Node trackedNode, float attenuation) {
        this(true, color, trackedNode, attenuation);
    }

    public PointLight(boolean enabled) {
        this(enabled, DEFAULT_COLOR, (Tuple3f)DEFAULT_LOCATION, DEFAULT_ATTENUATION);
    }

    public PointLight(boolean enabled, Node trackedNode) {
        this(enabled);
        this.setTrackedNode(trackedNode);
    }

    public PointLight() {
        this(true);
    }
}

