/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonAttributes
extends NodeComponent
implements StateTrackable<PolygonAttributes> {
    private StateNode stateNode = null;
    private long stateId = -1L;
    public static final FaceCullMode CULL_NONE = FaceCullMode.NONE;
    public static final FaceCullMode CULL_FRONT = FaceCullMode.FRONT;
    public static final FaceCullMode CULL_BACK = FaceCullMode.BACK;
    public static final FaceCullMode CULL_SWITCH = FaceCullMode.SWITCH;
    public static final DrawMode POLYGON_POINT = DrawMode.POINT;
    public static final DrawMode POLYGON_LINE = DrawMode.LINE;
    public static final DrawMode POLYGON_FILL = DrawMode.FILL;
    private FaceCullMode cullFace = FaceCullMode.NONE;
    private DrawMode drawMode = DrawMode.FILL;
    private float polygonOffset = 0.0f;
    private float polygonOffsetFactor = 0.0f;
    private boolean backFaceNormalFlip = false;
    private boolean antialiasing = false;
    private boolean sortEnabled = true;

    public void setDrawMode(DrawMode drawMode) {
        this.drawMode = drawMode;
        this.setChanged(true);
    }

    public final DrawMode getDrawMode() {
        return this.drawMode;
    }

    public final void setFaceCullMode(FaceCullMode mode) {
        this.cullFace = mode;
        this.setChanged(true);
    }

    public final FaceCullMode getFaceCullMode() {
        return this.cullFace;
    }

    public final void setPolygonOffset(float polygonOffset) {
        this.polygonOffset = polygonOffset;
        this.setChanged(true);
    }

    public final float getPolygonOffset() {
        return this.polygonOffset;
    }

    public final void setPolygonAntialiasingEnabled(boolean state) {
        this.antialiasing = state;
        this.setChanged(true);
    }

    public final boolean isPolygonAntialiasingEnabled() {
        return this.antialiasing;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
        this.setChanged(true);
    }

    public final boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void setBackFaceNormalFlip(boolean backFaceNormalFlip) {
        this.backFaceNormalFlip = backFaceNormalFlip;
        this.setChanged(true);
    }

    public final boolean getBackFaceNormalFlip() {
        return this.backFaceNormalFlip;
    }

    public void setPolygonOffsetFactor(float polygonOffsetFactor) {
        this.polygonOffsetFactor = polygonOffsetFactor;
        this.setChanged(true);
    }

    public final float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    @Override
    public final void setStateNode(StateNode node2) {
        this.stateNode = node2;
        this.stateId = node2.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public PolygonAttributes getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolygonAttributes)) {
            return false;
        }
        PolygonAttributes ro = (PolygonAttributes)o;
        if (this.drawMode != ro.drawMode) {
            return false;
        }
        if (this.cullFace != ro.cullFace) {
            return false;
        }
        if (this.polygonOffset != ro.polygonOffset) {
            return false;
        }
        if (this.polygonOffsetFactor != ro.polygonOffsetFactor) {
            return false;
        }
        if (this.backFaceNormalFlip != ro.backFaceNormalFlip) {
            return false;
        }
        if (this.antialiasing != ro.antialiasing) {
            return false;
        }
        return this.sortEnabled == ro.sortEnabled;
    }

    @Override
    public int compareTo(PolygonAttributes o) {
        if (this == o) {
            return 0;
        }
        if (this.drawMode.ordinal() < o.drawMode.ordinal()) {
            return -1;
        }
        if (this.drawMode.ordinal() > o.drawMode.ordinal()) {
            return 1;
        }
        if (this.polygonOffset < o.polygonOffset) {
            return -1;
        }
        if (this.polygonOffset > o.polygonOffset) {
            return 1;
        }
        if (this.polygonOffsetFactor < o.polygonOffsetFactor) {
            return -1;
        }
        if (this.polygonOffsetFactor > o.polygonOffsetFactor) {
            return 1;
        }
        if (this.cullFace.ordinal() < o.cullFace.ordinal()) {
            return -1;
        }
        if (this.cullFace.ordinal() > o.cullFace.ordinal()) {
            return 1;
        }
        int val = ComparatorHelper.compareBoolean(this.antialiasing, o.antialiasing);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareBoolean(this.backFaceNormalFlip, o.backFaceNormalFlip);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareBoolean(this.sortEnabled, o.sortEnabled);
        if (val != 0) {
            return val;
        }
        return 0;
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        PolygonAttributes o = (PolygonAttributes)original;
        this.setFaceCullMode(o.getFaceCullMode());
        this.setDrawMode(o.getDrawMode());
        this.setPolygonOffset(o.getPolygonOffset());
        this.setPolygonOffsetFactor(o.getPolygonOffsetFactor());
        this.setBackFaceNormalFlip(o.getBackFaceNormalFlip());
        this.setPolygonAntialiasingEnabled(o.isPolygonAntialiasingEnabled());
    }

    @Override
    public PolygonAttributes cloneNodeComponent(boolean forceDuplicate) {
        PolygonAttributes pa = new PolygonAttributes();
        pa.duplicateNodeComponent(this, forceDuplicate);
        return pa;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public PolygonAttributes() {
        super(false);
    }

    public PolygonAttributes(DrawMode drawMode, FaceCullMode cullFace, float polygonOffset) {
        this();
        this.cullFace = cullFace;
        this.drawMode = drawMode;
        this.polygonOffset = polygonOffset;
    }

    public PolygonAttributes(DrawMode drawMode, FaceCullMode cullFace) {
        this(drawMode, cullFace, 0.0f);
    }

    public PolygonAttributes(DrawMode drawMode) {
        this(drawMode, FaceCullMode.NONE, 0.0f);
    }

    public PolygonAttributes(FaceCullMode cullFace) {
        this(DrawMode.FILL, cullFace, 0.0f);
    }

    public PolygonAttributes(DrawMode drawMode, FaceCullMode cullFace, float polygonOffset, float polygonOffsetFactor) {
        this();
        this.polygonOffset = polygonOffset;
        this.polygonOffsetFactor = polygonOffsetFactor;
        this.cullFace = cullFace;
        this.drawMode = drawMode;
    }

    public PolygonAttributes(DrawMode drawMode, FaceCullMode cullFace, float polygonOffset, float polygonOffsetFactor, boolean backFaceNormalFlip, boolean antialiasing, boolean sortEnabled) {
        this();
        this.polygonOffset = polygonOffset;
        this.polygonOffsetFactor = polygonOffsetFactor;
        this.cullFace = cullFace;
        this.drawMode = drawMode;
        this.backFaceNormalFlip = backFaceNormalFlip;
        this.antialiasing = antialiasing;
        this.sortEnabled = sortEnabled;
    }
}

