/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.List;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.utility.geometry.GeometryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticTransform {
    public static void translate(Tuple3f[] coords, float offsetX, float offsetY, float offsetZ) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i].addX(offsetX);
            coords[i].addY(offsetY);
            coords[i].addZ(offsetZ);
        }
    }

    public static void translate(Tuple3f[] coords, Tuple3f offset) {
        StaticTransform.translate(coords, offset.getX(), offset.getY(), offset.getZ());
    }

    public static void translate(Geometry src, float offsetX, float offsetY, float offsetZ) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            coord.addX(offsetX);
            coord.addY(offsetY);
            coord.addZ(offsetZ);
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
    }

    public static void translate(Geometry src, Tuple3f offset) {
        StaticTransform.translate(src, offset.getX(), offset.getY(), offset.getZ());
    }

    public static <S extends Shape3D> S translate(S shape, float offsetX, float offsetY, float offsetZ) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.translate(src, offsetX, offsetY, offsetZ);
        shape.setGeometry(src);
        return shape;
    }

    public static <S extends Shape3D> S translate(S shape, Tuple3f offset) {
        return StaticTransform.translate(shape, offset.getX(), offset.getY(), offset.getZ());
    }

    public static void translate(GroupNode src, float offsetX, float offsetY, float offsetZ) {
        List<Shape3D> shapes = src.findAll(Shape3D.class);
        for (int i = 0; i < shapes.size(); ++i) {
            StaticTransform.translate(shapes.get(i), offsetX, offsetY, offsetZ);
        }
    }

    public static void translate(GroupNode src, Tuple3f offset) {
        StaticTransform.translate(src, offset.getX(), offset.getY(), offset.getZ());
    }

    public static void translate(Tuple3f[] coords, Matrix3f offset) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i].set(coords[i].getX() + offset.m00() + coords[i].getY() * offset.m01() + coords[i].getZ() * offset.m02(), coords[i].getX() * offset.m10() + coords[i].getY() + offset.m11() + coords[i].getZ() * offset.m12(), coords[i].getX() * offset.m20() + coords[i].getY() * offset.m21() + coords[i].getZ() + offset.m22());
        }
    }

    public static void translate(Geometry src, Matrix3f offset) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            coord.set(coord.getX() + offset.m00() + coord.getY() * offset.m01() + coord.getZ() * offset.m02(), coord.getX() * offset.m10() + coord.getY() + offset.m11() + coord.getZ() * offset.m12(), coord.getX() * offset.m20() + coord.getY() * offset.m21() + coord.getZ() + offset.m22());
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
    }

    public static <S extends Shape3D> S translate(S shape, Matrix3f offset) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.translate(src, offset);
        shape.setGeometry(src);
        return shape;
    }

    public static void scale(Tuple3f[] coords, float scaleX, float scaleY, float scaleZ) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i].mulX(scaleX);
            coords[i].mulY(scaleY);
            coords[i].mulZ(scaleZ);
        }
    }

    public static void scale(Geometry src, float scaleX, float scaleY, float scaleZ) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            coord.mulX(scaleX);
            coord.mulY(scaleY);
            coord.mulZ(scaleZ);
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
    }

    public static void scale(Geometry src, Tuple3f scale) {
        StaticTransform.scale(src, scale.getX(), scale.getY(), scale.getZ());
    }

    public static <S extends Shape3D> S scale(S shape, float scaleX, float scaleY, float scaleZ) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.scale(src, scaleX, scaleY, scaleZ);
        shape.setGeometry(src);
        return shape;
    }

    public static void scale(Geometry src, float scale) {
        StaticTransform.scale(src, scale, scale, scale);
    }

    public static <S extends Shape3D> S scale(S shape, Tuple3f scale) {
        return StaticTransform.scale(shape, scale.getX(), scale.getY(), scale.getZ());
    }

    public static <S extends Shape3D> S scale(S shape, float scale) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.scale(src, scale);
        shape.setGeometry(src);
        return shape;
    }

    public static void transform(Tuple3f[] coords, Matrix3f m) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i].set(m.m00() * coords[i].getX() + m.m01() * coords[i].getY() + m.m02() * coords[i].getZ(), m.m10() * coords[i].getX() + m.m11() * coords[i].getY() + m.m12() * coords[i].getZ(), m.m20() * coords[i].getX() + m.m21() * coords[i].getY() + m.m22() * coords[i].getZ());
        }
    }

    public static void transform(Geometry src, Matrix3f m) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            coord.set(m.m00() * coord.getX() + m.m01() * coord.getY() + m.m02() * coord.getZ(), m.m10() * coord.getX() + m.m11() * coord.getY() + m.m12() * coord.getZ(), m.m20() * coord.getX() + m.m21() * coord.getY() + m.m22() * coord.getZ());
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
    }

    public static <S extends Shape3D> S transform(S shape, Matrix3f m) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.transform(src, m);
        shape.setGeometry(src);
        return shape;
    }

    public static void transform(Point3f[] coords, Matrix4f m) {
        for (int i = 0; i < coords.length; ++i) {
            m.transform(coords[i]);
        }
    }

    public static void transform(Geometry src, Matrix4f m) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            m.transform(coord);
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
    }

    public static <S extends Shape3D> S transform(S shape, Matrix4f m) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.transform(src, m);
        shape.setGeometry(src);
        return shape;
    }

    public static void rotate(Tuple3f[] coords, float axisX, float axisY, float axisZ, float theta) {
        StaticTransform.transform(coords, MatrixUtils.getRotationMatrix(axisX, axisY, axisZ, theta));
    }

    public static void rotateX(Tuple3f[] coords, float theta) {
        StaticTransform.rotate(coords, 1.0f, 0.0f, 0.0f, theta);
    }

    public static void rotateY(Tuple3f[] coords, float theta) {
        StaticTransform.rotate(coords, 0.0f, 1.0f, 0.0f, theta);
    }

    public static void rotateZ(Tuple3f[] coords, float theta) {
        StaticTransform.rotate(coords, 0.0f, 0.0f, 1.0f, theta);
    }

    public static void rotate(Geometry src, float axisX, float axisY, float axisZ, float theta) {
        Matrix3f m = MatrixUtils.getRotationMatrix(axisX, axisY, axisZ, theta);
        StaticTransform.transform(src, m);
        if (src.hasNormals()) {
            int n = src.getVertexCount();
            Vector3f normal = Vector3f.fromPool();
            for (int i = 0; i < n; ++i) {
                src.getNormal(i, normal);
                normal.set(m.m00() * normal.getX() + m.m01() * normal.getY() + m.m02() * normal.getZ(), m.m10() * normal.getX() + m.m11() * normal.getY() + m.m12() * normal.getZ(), m.m20() * normal.getX() + m.m21() * normal.getY() + m.m22() * normal.getZ());
                src.setNormal(i, normal);
            }
            Tuple3f[] normals = GeometryUtils.getNormals(src);
            StaticTransform.transform(normals, m);
            src.setNormals(0, (Vector3f[])normals);
        }
    }

    public static void rotateX(Geometry src, float theta) {
        StaticTransform.rotate(src, 1.0f, 0.0f, 0.0f, theta);
    }

    public static void rotateY(Geometry src, float theta) {
        StaticTransform.rotate(src, 0.0f, 1.0f, 0.0f, theta);
    }

    public static void rotateZ(Geometry src, float theta) {
        StaticTransform.rotate(src, 0.0f, 0.0f, 1.0f, theta);
    }

    public static void rotate(Geometry src, Tuple3f axis, float theta) {
        StaticTransform.rotate(src, axis.getX(), axis.getY(), axis.getZ(), theta);
    }

    public static <S extends Shape3D> S rotate(S shape, float axisX, float axisY, float axisZ, float theta) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.rotate(src, axisX, axisY, axisZ, theta);
        shape.setGeometry(src);
        return shape;
    }

    public static <S extends Shape3D> S rotateX(S shape, float theta) {
        return StaticTransform.rotate(shape, 1.0f, 0.0f, 0.0f, theta);
    }

    public static <S extends Shape3D> S rotateY(S shape, float theta) {
        return StaticTransform.rotate(shape, 0.0f, 1.0f, 0.0f, theta);
    }

    public static <S extends Shape3D> S rotateZ(S shape, float theta) {
        return StaticTransform.rotate(shape, 0.0f, 0.0f, 1.0f, theta);
    }

    public static <S extends Shape3D> S rotate(S shape, Tuple3f axis, float theta) {
        return StaticTransform.rotate(shape, axis.getX(), axis.getY(), axis.getZ(), theta);
    }

    public static void mirrorXY(Tuple3f[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i].mulZ(-1.0f);
        }
    }

    public static void mirrorYZ(Tuple3f[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i].mulX(-1.0f);
        }
    }

    public static void mirrorZX(Tuple3f[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i].mulY(-1.0f);
        }
    }

    public static void mirrorXY(Geometry src) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            coord.mulZ(-1.0f);
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
        if (src.hasNormals()) {
            Vector3f normal = Vector3f.fromPool();
            for (int i = 0; i < n; ++i) {
                src.getNormal(i, normal);
                normal.mulZ(-1.0f);
                src.setNormal(i, normal);
            }
            Vector3f.toPool(normal);
        }
    }

    public static void mirrorYZ(Geometry src) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            coord.mulX(-1.0f);
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
        if (src.hasNormals()) {
            Vector3f normal = Vector3f.fromPool();
            for (int i = 0; i < n; ++i) {
                src.getNormal(i, normal);
                normal.mulX(-1.0f);
                src.setNormal(i, normal);
            }
            Vector3f.toPool(normal);
        }
    }

    public static void mirrorZX(Geometry src) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            coord.mulY(-1.0f);
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
        if (src.hasNormals()) {
            Vector3f normal = Vector3f.fromPool();
            for (int i = 0; i < n; ++i) {
                src.getNormal(i, normal);
                normal.mulY(-1.0f);
                src.setNormal(i, normal);
            }
            Vector3f.toPool(normal);
        }
    }

    public static <S extends Shape3D> S mirrorXY(S shape) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.mirrorXY(src);
        shape.setGeometry(src);
        return shape;
    }

    public static <S extends Shape3D> S mirrorYZ(S shape) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.mirrorYZ(src);
        shape.setGeometry(src);
        return shape;
    }

    public static <S extends Shape3D> S mirrorZX(S shape) {
        Geometry src = shape.getGeometry();
        if (src == null) {
            return null;
        }
        StaticTransform.mirrorZX(src);
        shape.setGeometry(src);
        return shape;
    }

    public static void quadratic(Geometry src, Tuple3f A, Matrix3f B, Matrix3f C) {
        int n = src.getVertexCount();
        Point3f coord = Point3f.fromPool();
        for (int i = 0; i < n; ++i) {
            src.getCoordinate(i, coord);
            float x = coord.getX();
            float y = coord.getY();
            float z = coord.getZ();
            coord.set(x + A.getX() + (B.m00() * x + B.m01() * y + B.m02() * z) + x * (C.m00() * x + C.m01() * y + C.m02() * z), y + A.getY() + (B.m10() * x + B.m11() * y + B.m12() * z) + x * (C.m10() * x + C.m11() * y + C.m12() * z), z + A.getZ() + (B.m20() * x + B.m21() * y + B.m22() * z) + x * (C.m20() * x + C.m21() * y + C.m22() * z));
            src.setCoordinate(i, coord);
        }
        Point3f.toPool(coord);
        src.setBoundsDirty();
    }

    public static <S extends Shape3D> S quadratic(S shape, Tuple3f A, Matrix3f B, Matrix3f C) {
        Geometry geom = shape.getGeometry();
        if (geom == null) {
            return null;
        }
        StaticTransform.quadratic(geom, A, B, C);
        shape.setGeometry(geom);
        return shape;
    }

    private StaticTransform() {
    }
}

