/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.BitSet;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;
import org.xith3d.scenegraph.traversal.TraversalCallback;

public class Switch
extends Group {
    public static final int CHILD_NONE = -1;
    public static final int CHILD_ALL = -2;
    public static final int CHILD_MASK = -3;
    private static boolean ignoreMaskForTraversal = true;
    private BitSet childMask;
    private int whichChild;

    public void setWhichChild(int whichChild) {
        if (whichChild >= this.numChildren()) {
            throw new IllegalArgumentException("whichChild out of range.");
        }
        int oldValue = this.whichChild;
        this.whichChild = whichChild;
        if (this.getModListener() != null && whichChild != oldValue) {
            this.getModListener().onSwitchWhichChildChanged(this, oldValue, whichChild);
        }
    }

    public final int getWhichChild() {
        return this.whichChild;
    }

    public final void setChildMask(BitSet childMask) {
        this.childMask = childMask;
    }

    public final BitSet getChildMask() {
        return this.childMask;
    }

    public Node getCurrentChild() {
        if (this.whichChild < 0 || this.whichChild > this.numChildren() - 1) {
            return null;
        }
        return this.getChild(this.whichChild);
    }

    public Node removeChild(int index) {
        Node child = super.removeChild(index);
        if (this.whichChild == index) {
            this.setWhichChild(-1);
        } else if (this.whichChild > index) {
            this.setWhichChild(this.whichChild - 1);
        }
        return child;
    }

    public final boolean isVisible(Node child) {
        if (this.whichChild == -1) {
            return false;
        }
        int idx = this.indexOf(child);
        if (idx < 0) {
            return false;
        }
        if (this.whichChild == -2) {
            return true;
        }
        if (this.whichChild == -3) {
            if (this.childMask == null) {
                return false;
            }
            return this.childMask.get(idx);
        }
        return idx == this.whichChild;
    }

    public static boolean setIgnoreMaskForTraversal(boolean ignore) {
        boolean b = ignoreMaskForTraversal;
        ignoreMaskForTraversal = ignore;
        return b;
    }

    public static boolean getIgnoreMaskForTraversal() {
        return ignoreMaskForTraversal;
    }

    protected Switch newInstance() {
        boolean gib = Node.globalIgnoreBounds;
        Node.globalIgnoreBounds = this.isIgnoreBounds();
        Switch s = new Switch(this.whichChild, this.childMask);
        Node.globalIgnoreBounds = gib;
        return s;
    }

    public boolean traverse(TraversalCallback listener) {
        if (!listener.traversalOperation(this)) {
            return false;
        }
        if (listener.traversalCheckGroup(this)) {
            if (ignoreMaskForTraversal || this.whichChild == -2) {
                int n = this.numChildren();
                for (int i = 0; i < n; ++i) {
                    if (this.getChild(i).traverse(listener)) continue;
                    return false;
                }
            } else {
                switch (this.whichChild) {
                    case -3: {
                        int n = this.numChildren();
                        int i = this.childMask.nextSetBit(0);
                        while (i >= 0 && i < n) {
                            if (!this.getChild(i).traverse(listener)) {
                                return false;
                            }
                            i = this.childMask.nextSetBit(i + 1);
                        }
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        return this.getChild(this.whichChild).traverse(listener);
                    }
                }
            }
        }
        return true;
    }

    public boolean traverse(DetailedTraversalCallback callback) {
        if (!callback.traversalOperationCommon(this)) {
            return false;
        }
        if (!callback.traversalOperation(this)) {
            return false;
        }
        if (callback.traversalCheckGroup(this)) {
            if (ignoreMaskForTraversal || this.whichChild == -2) {
                int n = this.numChildren();
                for (int i = 0; i < n; ++i) {
                    if (this.getChild(i).traverse(callback)) continue;
                    return false;
                }
            } else {
                switch (this.whichChild) {
                    case -3: {
                        int n = this.numChildren();
                        int i = this.childMask.nextSetBit(0);
                        while (i >= 0 && i < n) {
                            if (!this.getChild(i).traverse(callback)) {
                                return false;
                            }
                            i = this.childMask.nextSetBit(i + 1);
                        }
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        if (this.getChild(this.whichChild).traverse(callback)) break;
                        return false;
                    }
                }
            }
        }
        return callback.traversalOperationAfter(this) && callback.traversalOperationCommonAfter(this);
    }

    public Switch(int whichChild, BitSet childMask) {
        this.childMask = childMask;
        this.whichChild = whichChild;
    }

    public Switch(int whichChild) {
        this(whichChild, new BitSet());
    }

    public Switch() {
        this(-1);
    }
}

