/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.datatypes.Enableable;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureType;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.TextureImage;

public abstract class Texture
extends NodeComponent
implements AbstractTexture,
Enableable {
    private static long TEX_STATE_ID_SEQ = 1L;
    private final TextureType type;
    private TextureFormat format = null;
    private TextureImage[] images = null;
    private TextureBoundaryMode boundaryModeS = TextureBoundaryMode.WRAP;
    private TextureBoundaryMode boundaryModeT = TextureBoundaryMode.WRAP;
    private final Colorf boundaryColor = new Colorf(0.0f, 0.0f, 0.0f, 0.0f);
    private int boundaryWidth = 0;
    private boolean mappingEnabled = true;
    private static TextureFilter defaultFilter = null;
    private TextureFilter filter = defaultFilter;
    private long texStateId;
    private boolean dirty = true;
    private String cacheKey = null;
    private String resourceName = null;
    private boolean markedAsLocalDataToBeFreed = false;
    private final SceneGraphOpenGLReferences openGLReferences = new SceneGraphOpenGLReferences(1);
    private boolean sizeChanged = false;

    public final TextureType getType() {
        return this.type;
    }

    public final TextureFormat getFormat() {
        return this.format;
    }

    public void setEnabled(boolean enabled) {
        this.mappingEnabled = enabled;
        this.setChanged(true);
    }

    public final boolean isEnabled() {
        return this.mappingEnabled;
    }

    final void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    protected abstract void checkImageType(TextureImage var1);

    public void setImage(int level, TextureImage image) {
        if (image != null) {
            this.checkImageType(image);
        }
        if (this.images == null) {
            if (image == null) {
                return;
            }
            this.images = new TextureImage[level + 1];
            this.images[level] = image;
        } else if (this.images.length - 1 >= level) {
            if (image == null) {
                if (this.images.length == 1) {
                    this.images = null;
                } else {
                    TextureImage[] temp = new TextureImage[this.images.length - 1];
                    System.arraycopy(this.images, 0, temp, 0, level);
                    System.arraycopy(this.images, level + 1, temp, level, this.images.length - level - 1);
                    this.images = temp;
                }
            } else {
                this.images[level] = image;
            }
        } else {
            if (image == null) {
                return;
            }
            TextureImage[] temp = new TextureImage[level + 1];
            for (int loop = 0; loop < this.images.length; ++loop) {
                temp[loop] = this.images[loop];
            }
            temp[level] = image;
            this.images = temp;
        }
        this.dirty = true;
    }

    public final void setImage(int level, AbstractTextureImage image) {
        this.setImage(level, (TextureImage)image);
    }

    public final void addImage(AbstractTextureImage image) {
        this.setImage(this.getImagesCount(), image);
    }

    public final TextureImage getImage(int level) {
        return this.images[level];
    }

    public final int getImagesCount() {
        if (this.images == null) {
            return 0;
        }
        return this.images.length;
    }

    public final MipmapMode getMipMapMode() {
        if (this.images == null || this.images.length <= 1) {
            return MipmapMode.BASE_LEVEL;
        }
        return MipmapMode.MULTI_LEVEL_MIPMAP;
    }

    public void setSizeChanged() {
        this.sizeChanged = true;
    }

    public final boolean hasSizeChanged() {
        return this.sizeChanged;
    }

    final void resetSizeChanged() {
        this.sizeChanged = false;
    }

    public final Sized2iRO getSize() {
        if (this.getImagesCount() == 0) {
            return null;
        }
        return this.getImage(0).getSize();
    }

    public final int getWidth() {
        if (this.getImagesCount() == 0) {
            return -1;
        }
        return this.getImage(0).getWidth();
    }

    public final int getHeight() {
        if (this.getImagesCount() == 0) {
            return -1;
        }
        return this.getImage(0).getHeight();
    }

    public final Sized2iRO getOriginalSize() {
        if (this.getImagesCount() == 0) {
            return null;
        }
        return this.getImage(0).getOriginalSize();
    }

    public final int getOriginalWidth() {
        if (this.getImagesCount() == 0) {
            return -1;
        }
        return this.getImage(0).getOriginalWidth();
    }

    public final int getOriginalHeight() {
        if (this.getImagesCount() == 0) {
            return -1;
        }
        return this.getImage(0).getOriginalHeight();
    }

    public final void setBoundaryModeS(TextureBoundaryMode mode) {
        this.boundaryModeS = mode;
        this.setChanged(true);
    }

    public final TextureBoundaryMode getBoundaryModeS() {
        return this.boundaryModeS;
    }

    public final void setBoundaryModeT(TextureBoundaryMode mode) {
        this.boundaryModeT = mode;
        this.setChanged(true);
    }

    public final TextureBoundaryMode getBoundaryModeT() {
        return this.boundaryModeT;
    }

    public final void setBoundaryModes(TextureBoundaryMode modeS, TextureBoundaryMode modeT) {
        this.setBoundaryModeS(modeS);
        this.setBoundaryModeT(modeT);
    }

    public void setBoundaryColor(Colorf color) {
        this.boundaryColor.set(color);
        this.setChanged(true);
    }

    public final void setBoundaryColor(float r, float g, float b, float a) {
        this.boundaryColor.set(r, g, b, a);
        this.setChanged(true);
    }

    public final Colorf getBoundaryColor() {
        return this.boundaryColor.getReadOnly();
    }

    public final Colorf getBoundaryColor(Colorf c) {
        c.set(this.boundaryColor);
        return c;
    }

    public void setBoundaryWidth(int boundaryWidth) {
        this.boundaryWidth = boundaryWidth;
        this.setChanged(true);
    }

    public final int getBoundaryWidth() {
        return this.boundaryWidth;
    }

    public static void setDefaultFilter(TextureFilter defaultFilter) {
        Texture.defaultFilter = defaultFilter;
    }

    public static TextureFilter getDefaultFilter() {
        return defaultFilter;
    }

    public final void setFilter(TextureFilter filter) {
        this.filter = filter;
        this.setChanged(true);
    }

    public final TextureFilter getFilter() {
        return this.filter;
    }

    public final long getStateId() {
        return this.texStateId;
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        Texture orgTex = (Texture)original;
        this.format = orgTex.format;
        this.mappingEnabled = orgTex.mappingEnabled;
        if (orgTex.images == null) {
            this.images = null;
        } else {
            this.images = new TextureImage[orgTex.images.length];
            for (int i = 0; i < orgTex.images.length; ++i) {
                this.images[i] = orgTex.images[i];
            }
        }
        this.boundaryModeS = orgTex.boundaryModeS;
        this.boundaryModeT = orgTex.boundaryModeT;
        this.boundaryColor.set(orgTex.boundaryColor);
        this.boundaryWidth = orgTex.boundaryWidth;
        this.filter = orgTex.filter;
    }

    public void enableAutoFreeLocalData() {
        this.markedAsLocalDataToBeFreed = true;
    }

    public final boolean isMarkedAsLocalDataToBeFreed() {
        return this.markedAsLocalDataToBeFreed;
    }

    public final SceneGraphOpenGLReferences getOpenGLReferences() {
        return this.openGLReferences;
    }

    protected void finalize() {
        this.openGLReferences.prepareObjectForDestroy();
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.openGLReferences.referenceExists(canvasPeer)) {
            this.openGLReferences.prepareObjectForDestroy(canvasPeer);
        }
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public final String getCacheKey() {
        return this.cacheKey;
    }

    public final void removeFromCache() {
        TextureLoader.getInstance().getCache().remove(this);
    }

    public void setResourceName(String resName) {
        this.resourceName = resName;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ " + "name = " + (this.getName() != null ? "\"" : "") + this.getName() + (this.getName() != null ? "\"" : "") + ", size = " + this.getWidth() + "x" + this.getHeight() + (!this.getSize().equals(this.getOriginalSize()) ? ", orgSize = " + this.getOriginalWidth() + "x" + this.getOriginalHeight() : "") + ", format = " + (Object)((Object)this.format) + ", mipmapMode = " + (Object)((Object)this.getMipMapMode()) + " (" + this.getImagesCount() + " image" + (this.getImagesCount() != 1 ? "s" : "") + ")" + ", boundaryMode = " + (Object)((Object)this.boundaryModeS) + "/" + (Object)((Object)this.boundaryModeT) + ", boundaryWidth = " + this.boundaryWidth + ", boundaryColor = ( " + this.boundaryColor.getRed() + ", " + this.boundaryColor.getGreen() + ", " + this.boundaryColor.getBlue() + (this.boundaryColor.hasAlpha() ? ", " + this.boundaryColor.getAlpha() : "") + " )" + ", boundaryWidth = " + this.boundaryWidth + ", filter = " + (Object)((Object)this.filter) + ", enabled = " + this.mappingEnabled + ", resourceName = " + (this.resourceName != null ? "\"" : "") + this.resourceName + (this.resourceName != null ? "\"" : "") + ", cacheKey = " + (this.cacheKey != null ? "\"" : "") + this.cacheKey + (this.cacheKey != null ? "\"" : "") + " }";
    }

    public Texture(TextureType type, TextureFormat format, int boundaryWidth) {
        super(true);
        this.texStateId = TEX_STATE_ID_SEQ++;
        this.type = type;
        this.format = format;
        this.boundaryWidth = boundaryWidth;
    }

    public Texture(TextureType type, TextureFormat format) {
        this(type, format, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MipmapMode {
        BASE_LEVEL(false),
        MULTI_LEVEL_MIPMAP(true);

        private boolean boolVal;

        public boolean booleanValue() {
            return this.boolVal;
        }

        private MipmapMode(boolean boolVal) {
            this.boolVal = boolVal;
        }

        public static MipmapMode valueOf(boolean boolVal) {
            return boolVal ? MULTI_LEVEL_MIPMAP : BASE_LEVEL;
        }
    }
}

