/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;

public class Transform
extends TransformGroup {
    public static final Transform IDENTITY_TRANSFORM = new Transform();
    public static final int ROTATION = 0;
    public static final int TRANSLATION = 1;
    public static final int SCALE = 2;
    private final Transform3D tempTransform = new Transform3D();
    private final AxisAngle3f tempAxisAngle = new AxisAngle3f();
    private final Vector3f tempVector = new Vector3f();

    public Transform setTransform(int mode, float x, float y, float z) {
        Transform3D t3d = this.getTransform();
        switch (mode) {
            case 0: {
                t3d.rotXYZ(x, y, z);
                break;
            }
            case 1: {
                t3d.setTranslation(x, y, z);
                break;
            }
            case 2: {
                t3d.setScale(x, y, z);
            }
        }
        this.setTransform(t3d);
        return this;
    }

    public Transform setTransform(int mode, Tuple3f transform) {
        Transform3D t3d = this.getTransform();
        switch (mode) {
            case 0: {
                t3d.rotXYZ(transform.getX(), transform.getY(), transform.getZ());
                break;
            }
            case 1: {
                t3d.setTranslation(transform.getX(), transform.getY(), transform.getZ());
                break;
            }
            case 2: {
                t3d.setScale(transform.getX(), transform.getY(), transform.getZ());
            }
        }
        this.setTransform(t3d);
        return this;
    }

    public Transform setTranslationX(float value) {
        this.setTranslation(value, 0.0f, 0.0f);
        return this;
    }

    public Transform setTranslationY(float value) {
        this.setTranslation(0.0f, value, 0.0f);
        return this;
    }

    public Transform setTranslationZ(float value) {
        Transform3D t3d = this.getTransform();
        t3d.setTranslation(0.0f, 0.0f, value);
        this.setTransform(t3d);
        return this;
    }

    public Transform addTranslation(float x, float y, float z) {
        this.tempTransform.setIdentity();
        this.tempTransform.setTranslation(x, y, z);
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setTranslation(float x, float y, float z) {
        Transform3D t3d = this.getTransform();
        t3d.setTranslation(x, y, z);
        this.setTransform(t3d);
        return this;
    }

    public Transform addTranslation(Tuple3f translate) {
        this.tempTransform.setIdentity();
        this.tempTransform.setTranslation(translate.getX(), translate.getY(), translate.getZ());
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setTranslation(Tuple3f translate) {
        Transform3D t3d = this.getTransform();
        t3d.setTranslation(translate.getX(), translate.getY(), translate.getZ());
        this.setTransform(t3d);
        return this;
    }

    public Transform setRotation(Tuple3f rotate) {
        Transform3D t3d = this.getTransform();
        t3d.rotXYZ(rotate.getX(), rotate.getY(), rotate.getZ());
        this.setTransform(t3d);
        return this;
    }

    public Transform setRotation(float x, float y, float z) {
        Transform3D t3d = this.getTransform();
        t3d.rotXYZ(x, y, z);
        this.setTransform(t3d);
        return this;
    }

    public Transform addRotation(Tuple3f rotate) {
        this.tempTransform.setIdentity();
        this.tempTransform.rotXYZ(rotate.getX(), rotate.getY(), rotate.getZ());
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setRotation(Matrix3f rotationMatrix) {
        this.getTransform().setRotation(rotationMatrix);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform addRotation(Matrix3f rotationMatrix) {
        this.tempTransform.setIdentity();
        this.tempTransform.setRotation(rotationMatrix);
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform addRotation(float x, float y, float z) {
        this.tempTransform.setIdentity();
        this.tempTransform.rotXYZ(x, y, z);
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setRotationX(float angle) {
        Transform3D t3d = this.getTransform();
        t3d.rotXYZ(angle, 0.0f, 0.0f);
        this.setTransform(t3d);
        return this;
    }

    public Transform addRotationX(float angle) {
        this.tempTransform.setIdentity();
        this.tempTransform.rotXYZ(angle, 0.0f, 0.0f);
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setRotationY(float angle) {
        Transform3D t3d = this.getTransform();
        t3d.rotXYZ(0.0f, angle, 0.0f);
        this.setTransform(t3d);
        return this;
    }

    public Transform addRotationY(float angle) {
        this.tempTransform.setIdentity();
        this.tempTransform.rotXYZ(0.0f, angle, 0.0f);
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setRotationZ(float angle) {
        Transform3D t3d = this.getTransform();
        t3d.rotXYZ(0.0f, 0.0f, angle);
        this.setTransform(t3d);
        return this;
    }

    public Transform addRotationZ(float angle) {
        this.tempTransform.setIdentity();
        this.tempTransform.rotXYZ(0.0f, 0.0f, angle);
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setScale(Tuple3f scale) {
        Transform3D t3d = this.getTransform();
        t3d.setScale(scale);
        this.setTransform(t3d);
        return this;
    }

    public Transform setScale(float x, float y, float z) {
        Transform3D t3d = this.getTransform();
        t3d.setScale(x, y, z);
        this.setTransform(t3d);
        return this;
    }

    public Transform setScaleX(float scale) {
        Transform3D t3d = this.getTransform();
        t3d.setScale(scale, 0.0f, 0.0f);
        this.setTransform(t3d);
        return this;
    }

    public Transform setScaleY(float scale) {
        Transform3D t3d = this.getTransform();
        t3d.setScale(0.0f, scale, 0.0f);
        this.setTransform(t3d);
        return this;
    }

    public Transform setScaleZ(float scale) {
        Transform3D t3d = this.getTransform();
        t3d.setScale(0.0f, 0.0f, scale);
        this.setTransform(t3d);
        return this;
    }

    public Transform setScale(float scale) {
        Transform3D t3d = this.getTransform();
        t3d.setScale(scale);
        this.setTransform(t3d);
        return this;
    }

    public Transform addScale(float scale) {
        Transform3D t3d = this.getTransform();
        this.tempTransform.setIdentity();
        this.tempTransform.setScale(scale);
        t3d.mul(this.tempTransform);
        this.setTransform(t3d);
        return this;
    }

    public Transform add(Node n) {
        this.addChild(n);
        return this;
    }

    public Transform add(Transform t) {
        this.addChild(t);
        return t;
    }

    public Transform clear() {
        this.getTransform().setIdentity();
        this.updateTransform();
        return this;
    }

    public Transform setAxisRotation(Tuple3f rotationAxis, float angle) {
        this.tempAxisAngle.set(rotationAxis, angle);
        this.getTransform().setRotation(this.tempAxisAngle);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform addAxisRotation(Tuple3f rotationAxis, float angle) {
        this.tempTransform.setIdentity();
        this.tempAxisAngle.set(rotationAxis, angle);
        this.tempTransform.setRotation(this.tempAxisAngle);
        this.getTransform().mul(this.tempTransform);
        this.setTransform(this.getTransform());
        return this;
    }

    public Transform setAxisTranslation(Tuple3f translationAxis, float length) {
        this.tempVector.set((TupleNf)translationAxis);
        this.tempVector.normalize();
        this.tempVector.scale(length);
        this.setTranslation(this.tempVector);
        return this;
    }

    public Transform addAxisTranslation(Tuple3f translationAxis, float length) {
        this.tempVector.set((TupleNf)translationAxis);
        this.tempVector.normalize();
        this.tempVector.scale(length);
        this.addTranslation(this.tempVector);
        return this;
    }

    public Transform setMatrix(Matrix4f matrix) {
        this.getTransform().set(matrix);
        this.setTransform(this.getTransform());
        return this;
    }

    public static Transform get(Node node2) {
        GroupNode parent;
        if (node2.getParent() != null && (parent = node2.getParent()) instanceof Transform) {
            Transform t = (Transform)parent;
            return t;
        }
        return null;
    }

    public void transform(Point3f input) {
        this.getTransform().getMatrix4f().transform(input);
    }

    public void transform(Vector3f input) {
        this.getTransform().getMatrix4f().transform(input);
    }

    public void set(Transform trans) {
        this.getTransform().set(trans.getTransform());
        this.setTransform(this.getTransform());
    }

    public Transform(Node node2) {
        this.addChild(node2);
    }

    public Transform(int mode, Tuple3f transform, Node node2) {
        this.addChild(node2);
        this.setTransform(mode, transform);
    }

    public Transform() {
    }
}

