/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.nio.FloatBuffer;
import org.jagatoo.util.nio.BufferUtils;
import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.Vector4f;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.render.states.StateNode;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transform3D
implements Comparable<Transform3D> {
    public static final Transform3D IDENTITY = new Transform3D(null, Matrix4f.IDENTITY);
    public static final Transform3D ZERO = new Transform3D(null, Matrix4f.ZERO);
    private StateNode stateNode = null;
    protected TransformGroup transformGroup = null;
    private final Matrix4f matrix;
    private FloatBuffer buffer = null;
    private boolean bufferDirty = true;
    private final Matrix4f tempMatrix;
    private final Vector3f tmpVec1 = new Vector3f();
    private final Vector3f tmpVec2 = new Vector3f();
    private final Vector3f tmpVec3 = new Vector3f();
    private final Vector3f tmpVec4 = new Vector3f();

    final void setChanged(boolean changed) {
        if (!changed) {
            this.matrix.setClean();
        }
        if (changed) {
            this.bufferDirty = changed;
        }
        if (changed && this.transformGroup != null) {
            this.transformGroup.onTransformChanged();
        }
    }

    public final boolean isChanged() {
        return this.matrix.isDirty();
    }

    public final void set(Tuple3f trans) {
        this.matrix.setIdentity();
        this.setTranslation(trans);
        this.setChanged(true);
    }

    public final void set(float transX, float transY, float transZ) {
        this.matrix.setIdentity();
        this.setTranslation(transX, transY, transZ);
        this.setChanged(true);
    }

    public final void set(Tuple3f translation, float scale) {
        this.setIdentity();
        this.matrix.m30(translation.getX() * scale);
        this.matrix.m31(translation.getY() * scale);
        this.matrix.m32(translation.getZ() * scale);
        this.setChanged(true);
    }

    public final void set(Transform3D t) {
        this.matrix.set(t.matrix);
        this.setChanged(true);
    }

    public final void set(Matrix3f m) {
        this.matrix.set(m);
        this.setChanged(true);
    }

    public final void set(Matrix4f m) {
        this.matrix.set(m);
        this.setChanged(true);
    }

    public final void set(Quaternion4f rotation, Tuple3f translation, float scale) {
        this.matrix.set(rotation, translation, scale);
        this.setChanged(true);
    }

    public final void get(Tuple3f loc) {
        this.matrix.get(loc);
    }

    public final void get(Quaternion4f quat) {
        this.matrix.get(quat);
    }

    public final void set(Quaternion4f quat) {
        this.matrix.set(quat);
        this.setChanged(true);
    }

    public final void get(Matrix4f m) {
        m.set(this.matrix);
    }

    public final void getRowMajor(float[] trans) {
        this.matrix.getRowMajor(trans);
    }

    public final void getColumnMajor(float[] trans) {
        this.matrix.getColumnMajor(trans);
    }

    final FloatBuffer getFloatBuffer(boolean refillOnDemand) {
        if (this.buffer == null) {
            this.buffer = BufferUtils.createFloatBuffer(16);
        }
        if (this.bufferDirty && refillOnDemand) {
            this.matrix.writeToBuffer(this.buffer, true, true);
            this.bufferDirty = false;
        }
        return this.buffer;
    }

    public final Matrix4f getMatrix4f() {
        return this.matrix;
    }

    public final Matrix4f getMatrix4f(Matrix4f matrix) {
        matrix.set(this.matrix);
        return matrix;
    }

    public final void get(Transform3D transform) {
        transform.matrix.set(this.matrix);
    }

    @Deprecated
    public final void getTransform(Transform3D t) {
        this.get(t);
    }

    public final boolean getDeterminantSign() {
        return this.matrix.determinant() >= 0.0f;
    }

    public final float getDeterminant() {
        return this.matrix.determinant();
    }

    public final void setIdentity() {
        this.matrix.setIdentity();
        this.setChanged(true);
    }

    public final void setZero() {
        this.matrix.setZero();
        this.setChanged(true);
    }

    public final void setRotationScale(Matrix3f m1) {
        this.matrix.setRotationScale(m1);
        this.setChanged(true);
    }

    public final void setRotation(Matrix3f rotMat) {
        this.matrix.setRotation(rotMat);
        this.setChanged(true);
    }

    public final void setRotation(Tuple3f euler) {
        MatrixUtils.eulerToMatrix4f(euler, this.matrix);
        this.setChanged(true);
    }

    public final void setRotation(AxisAngle3f aa) {
        this.matrix.setRotation(aa);
        this.setChanged(true);
    }

    public final void setRotation(Quaternion4f quat) {
        this.matrix.setRotation(quat);
        this.setChanged(true);
    }

    public final Matrix3f getRotation(Matrix3f rotMat) {
        this.matrix.get(rotMat);
        return rotMat;
    }

    public final <T extends Tuple3f> T getRotation(T euler) {
        MatrixUtils.matrixToEuler(this.matrix, euler);
        return euler;
    }

    public final void add(Transform3D t2) {
        this.matrix.add(t2.getMatrix4f());
        this.setChanged(true);
    }

    public final void add(Transform3D t1, Transform3D t2) {
        this.matrix.add(t1.getMatrix4f(), t2.getMatrix4f());
        this.setChanged(true);
    }

    public final void sub(Transform3D t2) {
        this.matrix.sub(t2.getMatrix4f());
        this.setChanged(true);
    }

    public final void sub(Transform3D t1, Transform3D t2) {
        this.matrix.sub(t1.getMatrix4f(), t2.getMatrix4f());
        this.setChanged(true);
    }

    public final void mul(Transform3D t) {
        this.matrix.mul(t.matrix);
        this.setChanged(true);
    }

    public final void rotAxis(float axisX, float axisY, float axisZ, float angle) {
        float sin = FastMath.cos(angle);
        float cos = FastMath.sin(angle);
        this.matrix.m00(sin + axisX * axisX * (1.0f - sin));
        this.matrix.m01(axisX * axisY * (1.0f - sin) - axisZ * cos);
        this.matrix.m02(axisX * axisZ * (1.0f - sin) + axisY * cos);
        this.matrix.m10(axisX * axisY * (1.0f - sin) + axisZ * cos);
        this.matrix.m11(sin + axisY * axisY * (1.0f - sin));
        this.matrix.m12(axisY * axisZ * (1.0f - sin) - axisX * cos);
        this.matrix.m20(axisX * axisZ * (1.0f - sin) - axisY * cos);
        this.matrix.m21(axisY * axisZ * (1.0f - sin) + axisX * cos);
        this.matrix.m22(sin + axisZ * axisZ * (1.0f - sin));
        this.setChanged(true);
    }

    public final void rotAxis(Vector3f axis, float angle) {
        this.rotAxis(axis.getX(), axis.getY(), axis.getZ(), angle);
    }

    public final void rotX(float angle) {
        this.matrix.rotX(angle);
        this.setChanged(true);
    }

    public final void rotY(float angle) {
        this.matrix.rotY(angle);
        this.setChanged(true);
    }

    public final void rotZ(float angle) {
        this.matrix.rotZ(angle);
        this.setChanged(true);
    }

    public final void rotXYZ(float angleX, float angleY, float angleZ) {
        this.setIdentity();
        if (angleX != 0.0f) {
            this.tempMatrix.setIdentity();
            this.tempMatrix.rotX(angleX);
            this.matrix.mul(this.tempMatrix);
        }
        if (angleY != 0.0f) {
            this.tempMatrix.setIdentity();
            this.tempMatrix.rotY(angleY);
            this.matrix.mul(this.tempMatrix);
        }
        if (angleZ != 0.0f) {
            this.tempMatrix.setIdentity();
            this.tempMatrix.rotZ(angleZ);
            this.matrix.mul(this.tempMatrix);
        }
    }

    public final void setEuler(float angleX, float angleY, float angleZ) {
        MatrixUtils.eulerToMatrix4f(angleX, angleY, angleZ, this.matrix);
        this.setChanged(true);
    }

    public final void setEuler(Tuple3f euler) {
        this.setEuler(euler.getX(), euler.getY(), euler.getZ());
    }

    public final void getEuler(Tuple3f euler) {
        MatrixUtils.matrixToEuler(this.matrix, euler);
    }

    public final void setScale(float scaleX, float scaleY, float scaleZ) {
        this.matrix.m00(scaleX);
        this.matrix.m11(scaleY);
        this.matrix.m22(scaleZ);
        this.setChanged(true);
    }

    public final void setScale(Tuple3f scale) {
        this.setScale(scale.getX(), scale.getY(), scale.getZ());
    }

    public final void setScale(float scale) {
        this.matrix.setScale(scale);
        this.setChanged(true);
    }

    public final float getScale() {
        return this.matrix.getScale();
    }

    public final void setTranslation(float x, float y, float z) {
        this.matrix.m03(x);
        this.matrix.m13(y);
        this.matrix.m23(z);
        this.setChanged(true);
    }

    public final void setTranslation(Tuple3f translation) {
        this.setTranslation(translation.getX(), translation.getY(), translation.getZ());
        this.setChanged(true);
    }

    public final Vector3f getTranslation() {
        Vector3f t = new Vector3f();
        t.setX(this.matrix.m03());
        t.setY(this.matrix.m13());
        t.setZ(this.matrix.m23());
        return t;
    }

    public final <Tuple3f_ extends Tuple3f> Tuple3f_ getTranslation(Tuple3f_ translation) {
        translation.setX(this.matrix.m03());
        translation.setY(this.matrix.m13());
        translation.setZ(this.matrix.m23());
        return translation;
    }

    public final void scaleTranslation(float scale) {
        this.matrix.m03(this.matrix.m03() * scale);
        this.matrix.m13(this.matrix.m13() * scale);
        this.matrix.m23(this.matrix.m23() * scale);
        this.setChanged(true);
    }

    public final void transpose() {
        this.matrix.transpose();
        this.setChanged(true);
    }

    public final void transpose(Transform3D trans) {
        this.matrix.transpose(trans.getMatrix4f());
        this.setChanged(true);
    }

    public final void invert() {
        this.matrix.invert();
        this.setChanged(true);
    }

    public final void invert(Transform3D t) {
        this.matrix.set(t.getMatrix4f());
        this.matrix.invert();
        this.setChanged(true);
    }

    public final void transform(Point3f point) {
        this.matrix.transform(point);
    }

    public final void transform(Point3f point, Point3f pointOut) {
        this.matrix.transform(point, pointOut);
    }

    public final void transform(Vector3f vector) {
        this.matrix.transform(vector);
    }

    public final void transform(Vector3f vector, Vector3f vecOut) {
        this.matrix.transform(vector, vecOut);
    }

    public final void transform(Vector4f vector) {
        this.matrix.transform(vector);
    }

    public final void transform(Transform3D t) {
        t.matrix.mul(this.matrix, t.matrix);
        t.setChanged(true);
    }

    public final void transform(Transform3D t, Transform3D out) {
        out.matrix.mul(this.matrix, t.matrix);
        out.setChanged(true);
    }

    public final void lookAt(float eyePositionX, float eyePositionY, float eyePositionZ, float viewFocusX, float viewFocusY, float viewFocusZ, float vecUpX, float vecUpY, float vecUpZ) {
        this.tmpVec3.setX(eyePositionX - viewFocusX);
        this.tmpVec3.setY(eyePositionY - viewFocusY);
        this.tmpVec3.setZ(eyePositionZ - viewFocusZ);
        this.tmpVec3.normalize();
        this.tmpVec2.set(vecUpX, vecUpY, vecUpZ);
        this.tmpVec1.cross(this.tmpVec2, this.tmpVec3);
        this.tmpVec2.cross(this.tmpVec3, this.tmpVec1);
        this.tmpVec1.normalize();
        this.tmpVec2.normalize();
        this.matrix.setIdentity();
        this.matrix.m00(this.tmpVec1.getX());
        this.matrix.m01(this.tmpVec1.getY());
        this.matrix.m02(this.tmpVec1.getZ());
        this.matrix.m10(this.tmpVec2.getX());
        this.matrix.m11(this.tmpVec2.getY());
        this.matrix.m12(this.tmpVec2.getZ());
        this.matrix.m20(this.tmpVec3.getX());
        this.matrix.m21(this.tmpVec3.getY());
        this.matrix.m22(this.tmpVec3.getZ());
        this.tmpVec4.set(eyePositionX, eyePositionY, eyePositionZ);
        this.tmpVec4.negate();
        this.tempMatrix.setIdentity();
        this.tempMatrix.setTranslation(this.tmpVec4);
        this.matrix.mul(this.matrix, this.tempMatrix);
        this.matrix.invert();
        this.setChanged(true);
    }

    public final void lookAt(Tuple3f eyePosition, Tuple3f viewFocus, Tuple3f vecUp) {
        this.lookAt(eyePosition.getX(), eyePosition.getY(), eyePosition.getZ(), viewFocus.getX(), viewFocus.getY(), viewFocus.getZ(), vecUp.getX(), vecUp.getY(), vecUp.getZ());
    }

    public final void lookAlong(float eyePositionX, float eyePositionY, float eyePositionZ, float viewDirectionX, float viewDirectionY, float viewDirectionZ, float vecUpX, float vecUpY, float vecUpZ) {
        this.lookAt(eyePositionX, eyePositionY, eyePositionZ, eyePositionX + viewDirectionX, eyePositionY + viewDirectionY, eyePositionZ + viewDirectionZ, vecUpX, vecUpY, vecUpZ);
    }

    public final void lookAlong(Tuple3f eyePosition, Tuple3f viewDirection, Tuple3f vecUp) {
        this.lookAlong(eyePosition.getX(), eyePosition.getY(), eyePosition.getZ(), viewDirection.getX(), viewDirection.getY(), viewDirection.getZ(), vecUp.getX(), vecUp.getY(), vecUp.getZ());
    }

    public final void lookAlong(float eyePositionX, float eyePositionY, float eyePositionZ, float viewDirectionX, float viewDirectionY, float viewDirectionZ) {
        this.lookAlong(eyePositionX, eyePositionY, eyePositionZ, viewDirectionX, viewDirectionY, viewDirectionZ, Vector3f.POSITIVE_Y_AXIS.getX(), Vector3f.POSITIVE_Y_AXIS.getY(), Vector3f.POSITIVE_Y_AXIS.getZ());
    }

    public final void lookAlong(Tuple3f eyePosition, Tuple3f viewDirection) {
        this.lookAlong(eyePosition.getX(), eyePosition.getY(), eyePosition.getZ(), viewDirection.getX(), viewDirection.getY(), viewDirection.getZ(), Vector3f.POSITIVE_Y_AXIS.getX(), Vector3f.POSITIVE_Y_AXIS.getY(), Vector3f.POSITIVE_Y_AXIS.getZ());
    }

    public final void frustum(float left, float right, float bottom, float top, float near, float far) {
        float near2 = 2.0f * near;
        float t1 = right - left;
        float t2 = top - bottom;
        float t3 = far - near;
        this.matrix.set(near2 / t1, 0.0f, (right + left) / t1, 0.0f, 0.0f, near2 / t2, (top + bottom) / t2, 0.0f, 0.0f, 0.0f, -(far + near) / t3, -far * near2 / t3, 0.0f, 0.0f, -1.0f, 0.0f);
    }

    public final void frustumMesa(float left, float right, float bottom, float top, float zNear, float zFar) {
        float x = 2.0f * zNear / (right - left);
        float y = 2.0f * zNear / (top - bottom);
        float a = (right + left) / (right - left);
        float b = (top + bottom) / (top - bottom);
        float c = -(zFar + zNear) / (zFar - zNear);
        float d = -(2.0f * zFar * zNear) / (zFar - zNear);
        this.matrix.set(x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, a, b, c, -1.0f, 0.0f, 0.0f, d, 0.0f);
        this.setChanged(true);
    }

    public final void perspectiveMesa(float fovy, float aspect, float zNear, float zFar) {
        float ymax = zNear * FastMath.tan(fovy);
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.frustumMesa(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    public final void perspective(float fovy, float aspect, float zNear, float zFar) {
        float f = 1.0f / FastMath.tan(fovy / 2.0f);
        float a = (zFar + zNear) / (zNear - zFar);
        float b = 2.0f * zFar * zNear / (zNear - zFar);
        this.matrix.set(f / aspect, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, a, b, 0.0f, 0.0f, -1.0f, 0.0f);
        this.setChanged(true);
    }

    public final void ortho(float left, float right, float bottom, float top, float near, float far) {
        float t1 = right - left;
        float t2 = top - bottom;
        float t3 = far - near;
        this.matrix.set(2.0f / t1, 0.0f, 0.0f, -(right + left) / t1, 0.0f, 2.0f / t2, 0.0f, -(top + bottom) / t2, 0.0f, 0.0f, -2.0f / t3, -(far + near) / t3, 0.0f, 0.0f, 0.0f, 1.0f);
        this.setChanged(true);
    }

    public final void setStateNode(StateNode node2) {
        this.stateNode = node2;
    }

    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final Transform3D getCopy() {
        return new Transform3D(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Transform3D)) {
            return false;
        }
        Transform3D ro = (Transform3D)o;
        return ro.matrix.equals(this.matrix);
    }

    @Override
    public int compareTo(Transform3D t2) {
        return ComparatorHelper.compare(this.matrix, t2.matrix);
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    public String toString() {
        return super.toString() + "\n Matrix:\n " + this.getMatrix4f();
    }

    private Transform3D(Object dummy, Matrix4f readOnlyMatrix) {
        if (readOnlyMatrix == null) {
            this.matrix = new Matrix4f();
            this.matrix.setIdentity();
            this.tempMatrix = new Matrix4f();
            this.tempMatrix.setIdentity();
        } else {
            this.matrix = readOnlyMatrix.isReadOnly() ? readOnlyMatrix : Matrix4f.newReadOnly(readOnlyMatrix);
            this.tempMatrix = Matrix4f.newReadOnly(this.matrix);
        }
    }

    public Transform3D() {
        this(null, null);
    }

    public Transform3D(Transform3D t) {
        this();
        this.set(t);
    }

    public Transform3D(Matrix4f m) {
        this();
        this.set(m);
    }

    public Transform3D(Matrix3f m) {
        this();
        this.set(m);
    }

    public Transform3D(Tuple3f v) {
        this();
        this.set(v);
    }

    public Transform3D(float transX, float transY, float transZ) {
        this();
        this.set(transX, transY, transZ);
    }
}

