/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.datatypes.Enableable;
import org.jagatoo.opengl.enums.BlendFunction;
import org.jagatoo.opengl.enums.BlendMode;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransparencyAttributes
extends NodeComponent
implements Enableable,
StateTrackable<TransparencyAttributes> {
    public static final BlendMode NONE = BlendMode.NONE;
    public static final BlendMode BLENDED = BlendMode.BLENDED;
    public static final BlendMode NICEST = BlendMode.NICEST;
    public static final BlendMode FASTEST = BlendMode.FASTEST;
    public static final BlendMode SCREEN_DOOR = BlendMode.SCREEN_DOOR;
    public static final BlendFunction BLEND_ZERO = BlendFunction.ZERO;
    public static final BlendFunction BLEND_ONE = BlendFunction.ONE;
    public static final BlendFunction BLEND_SRC_ALPHA = BlendFunction.SRC_ALPHA;
    public static final BlendFunction BLEND_ONE_MINUS_SRC_ALPHA = BlendFunction.ONE_MINUS_SRC_ALPHA;
    private BlendFunction srcBlendFunction = BLEND_SRC_ALPHA;
    private BlendFunction dstBlendFunction = BLEND_ONE_MINUS_SRC_ALPHA;
    private BlendMode mode = BlendMode.BLENDED;
    private float tval = 0.0f;
    private boolean enabled = true;
    private boolean sortEnabled = true;
    private StateNode stateNode = null;
    private long stateId = -1L;

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setChanged(true);
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
        this.setChanged(true);
    }

    public final boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public final void setTransparency(float tval) {
        this.tval = tval;
        this.setChanged(true);
    }

    public final float getTransparency() {
        return this.tval;
    }

    public void setMode(BlendMode mode) {
        this.mode = mode;
        this.setChanged(true);
    }

    public final BlendMode getMode() {
        return this.mode;
    }

    public void setSrcBlendFunction(BlendFunction srcBlendFunction) {
        this.srcBlendFunction = srcBlendFunction;
        this.setChanged(true);
    }

    public final BlendFunction getSrcBlendFunction() {
        return this.srcBlendFunction;
    }

    public void setDstBlendFunction(BlendFunction dstBlendFunction) {
        this.dstBlendFunction = dstBlendFunction;
        this.setChanged(true);
    }

    public final BlendFunction getDstBlendFunction() {
        return this.dstBlendFunction;
    }

    @Override
    public final void setStateNode(StateNode node2) {
        this.stateNode = node2;
        this.stateId = node2.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public TransparencyAttributes getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransparencyAttributes)) {
            return false;
        }
        TransparencyAttributes ro = (TransparencyAttributes)o;
        if (this.mode != ro.mode) {
            return false;
        }
        if (this.tval != ro.tval) {
            return false;
        }
        if (this.srcBlendFunction != ro.srcBlendFunction) {
            return false;
        }
        if (this.dstBlendFunction != ro.dstBlendFunction) {
            return false;
        }
        if (this.sortEnabled != ro.sortEnabled) {
            return false;
        }
        return this.enabled == ro.enabled;
    }

    @Override
    public int compareTo(TransparencyAttributes o) {
        if (this == o) {
            return 0;
        }
        if (this.mode.ordinal() < o.mode.ordinal()) {
            return -1;
        }
        if (this.mode.ordinal() > o.mode.ordinal()) {
            return 1;
        }
        if (this.tval < o.tval) {
            return -1;
        }
        if (this.tval > o.tval) {
            return 1;
        }
        if (this.srcBlendFunction.ordinal() < o.srcBlendFunction.ordinal()) {
            return -1;
        }
        if (this.srcBlendFunction.ordinal() > o.srcBlendFunction.ordinal()) {
            return 1;
        }
        if (this.dstBlendFunction.ordinal() < o.dstBlendFunction.ordinal()) {
            return -1;
        }
        if (this.dstBlendFunction.ordinal() > o.dstBlendFunction.ordinal()) {
            return 1;
        }
        int val = ComparatorHelper.compareBoolean(this.sortEnabled, o.sortEnabled);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareBoolean(this.enabled, o.enabled);
        if (val != 0) {
            return val;
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + "[a=" + this.tval + ";mode=" + (Object)((Object)this.mode) + ";srcf=" + (Object)((Object)this.srcBlendFunction) + ";dstf=" + (Object)((Object)this.dstBlendFunction) + ";sort=" + this.sortEnabled + ";ena=" + this.enabled + "]";
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        TransparencyAttributes a = (TransparencyAttributes)original;
        this.setSortEnabled(a.isSortEnabled());
        this.setEnabled(a.isEnabled());
        this.setMode(a.getMode());
        this.setSrcBlendFunction(a.getSrcBlendFunction());
        this.setDstBlendFunction(a.getDstBlendFunction());
        this.setTransparency(a.getTransparency());
    }

    @Override
    public TransparencyAttributes cloneNodeComponent(boolean forceDuplicate) {
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.duplicateNodeComponent(this, forceDuplicate);
        return ta;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public TransparencyAttributes() {
        super(false);
    }

    public TransparencyAttributes(BlendMode mode, float tval) {
        this();
        this.mode = mode;
        this.tval = tval;
    }

    public TransparencyAttributes(float tval) {
        this();
        this.tval = tval;
    }

    public TransparencyAttributes(BlendMode mode, float tval, BlendFunction srcBlendFunction, BlendFunction dstBlendFunction) {
        this();
        this.mode = mode;
        this.tval = tval;
        this.srcBlendFunction = srcBlendFunction;
        this.dstBlendFunction = dstBlendFunction;
    }

    public TransparencyAttributes(BlendMode mode, float tval, BlendFunction srcBlendFunction, BlendFunction dstBlendFunction, boolean sortEnabled, boolean enabled) {
        this();
        this.mode = mode;
        this.tval = tval;
        this.srcBlendFunction = srcBlendFunction;
        this.dstBlendFunction = dstBlendFunction;
        this.sortEnabled = sortEnabled;
        this.enabled = enabled;
    }
}

