/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.particles.jops;

import java.util.ArrayList;
import java.util.List;
import org.softmed.jops.Generator;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.modifiers.Modifier;
import org.softmed.jops.modifiers.PointMass;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.particles.jops.GeneratorNode;
import org.xith3d.scenegraph.particles.jops.PointMassNode;

public class GeneratorAndPointMassVisualizer {
    private List<PointMassNode> pointMasses = new ArrayList<PointMassNode>();
    private List<GeneratorNode> generatorNodes = new ArrayList<GeneratorNode>();
    private GroupNode node;

    public void dispose() {
        if (this.node == null) {
            return;
        }
        this.removeGeneratorsAndPointMasses();
        this.node = null;
    }

    protected void showGeneratorsAndPointMasses(ParticleSystem particleSystem, GroupNode node2) {
        this.node = node2;
        if (particleSystem == null || node2 == null) {
            return;
        }
        List<Generator> gens2 = particleSystem.getGenerators();
        for (int i = 0; i < gens2.size(); ++i) {
            Generator generator = gens2.get(i);
            GeneratorNode gnode = new GeneratorNode();
            gnode.setGenerator(generator);
            this.generatorNodes.add(gnode);
            node2.addChild(gnode);
        }
        List<Modifier> modifiers = particleSystem.getModifiers();
        for (int i = 0; i < modifiers.size(); ++i) {
            Modifier modifier = modifiers.get(i);
            if (!(modifier instanceof PointMass)) continue;
            PointMassNode pmnode = new PointMassNode();
            pmnode.setPointMass((PointMass)modifier);
            this.pointMasses.add(pmnode);
            node2.addChild(pmnode);
        }
    }

    protected void removeGeneratorsAndPointMasses() {
        int i;
        for (i = 0; i < this.generatorNodes.size(); ++i) {
            GeneratorNode generator = this.generatorNodes.get(i);
            this.node.removeChild(generator);
            generator.setGenerator(null);
        }
        this.generatorNodes.clear();
        for (i = 0; i < this.pointMasses.size(); ++i) {
            PointMassNode pmnode = this.pointMasses.get(i);
            this.node.removeChild(pmnode);
            pmnode.setPointMass(null);
        }
        this.pointMasses.clear();
    }
}

