/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.particles.jops;

import java.util.List;
import org.jagatoo.opengl.enums.BlendFunction;
import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.PerspectiveCorrectionMode;
import org.jagatoo.opengl.enums.TestFunction;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureCombineMode;
import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.softmed.jops.Generator;
import org.softmed.jops.GeneratorBehaviour;
import org.softmed.jops.Particle;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Billboard;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TransparencyAttributes;

public class GeneratorShape3D
extends Shape3D
implements Billboard {
    private static boolean WIRE_FRAME = false;
    private Generator generator;
    private int count;
    private Vector3f viewUp = new Vector3f();
    private Vector3f viewRight = new Vector3f();
    private TexCoord2f bl = new TexCoord2f();
    private TexCoord2f br = new TexCoord2f();
    private TexCoord2f tl = new TexCoord2f();
    private Vector3f particleRight = new Vector3f();
    private float correctedVAngle;
    private int[] index;
    private final float[] coordsBuffer = new float[9];
    private final float[] colorBuffer = new float[4];
    private Vector3f particleUp = new Vector3f();
    private boolean relativeOrientation = false;
    private static final TextureAttributes texAttribs = new TextureAttributes(TextureMode.MODULATE, null, null, PerspectiveCorrectionMode.NICEST);
    private static final RenderingAttributes renderingAttribs;

    public static final void setWireFrameEnabled(boolean mode) {
        WIRE_FRAME = mode;
    }

    public static boolean isWireFrameEnabled() {
        return WIRE_FRAME;
    }

    public final IndexedTriangleArray getGeometry() {
        return (IndexedTriangleArray)super.getGeometry();
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
        this.setup();
    }

    public final Generator getGenerator() {
        return this.generator;
    }

    protected void rotate2f(TexCoord2f v, float angle) {
        v.set(v.getS() * FastMath.cos(angle) - v.getT() * FastMath.sin(angle), v.getT() * FastMath.cos(angle) + v.getS() * FastMath.sin(angle));
    }

    private void setTexture(int index, Particle particle) {
        float texWidth = 1.0f / particle.texWidth;
        float texHeight = 1.0f / particle.texHeight;
        this.bl.set(-0.5f, -0.5f);
        this.br.set(1.5f, -0.5f);
        this.tl.set(-0.5f, 1.5f);
        this.rotate2f(this.bl, particle.angle);
        this.rotate2f(this.br, particle.angle);
        this.rotate2f(this.tl, particle.angle);
        float bias = 0.5f;
        this.bl.set(this.bl.getS() * texWidth + 0.5f, this.bl.getT() * texHeight + 0.5f);
        this.br.set(this.br.getS() * texWidth + 0.5f, this.br.getT() * texHeight + 0.5f);
        this.tl.set(this.tl.getS() * texWidth + 0.5f, this.tl.getT() * texHeight + 0.5f);
        IndexedTriangleArray geom = this.getGeometry();
        geom.setTextureCoordinate(0, index + 0, this.bl);
        geom.setTextureCoordinate(0, index + 1, this.br);
        geom.setTextureCoordinate(0, index + 2, this.tl);
    }

    private void setColor(int index, Colorf color, float alpha) {
        this.colorBuffer[0] = color.getRed();
        this.colorBuffer[1] = color.getGreen();
        this.colorBuffer[2] = color.getBlue();
        this.colorBuffer[3] = alpha;
        IndexedTriangleArray geom = this.getGeometry();
        geom.setColor(index, this.colorBuffer);
        geom.setColor(index + 1, this.colorBuffer);
        geom.setColor(index + 2, this.colorBuffer);
    }

    protected void buildFacingCameraTriangles(float[] carray, Particle particle) {
        Vector3f position = new Vector3f(particle.position);
        this.getWorldTransform().transform(position);
        float tsize = particle.size;
        float width = particle.width * 0.25f;
        float height = particle.height * 0.25f;
        Point3f tup = new Point3f();
        tup.set(this.viewUp.getX(), this.viewUp.getY(), this.viewUp.getZ());
        tup.scale(height);
        Point3f tdir = new Point3f();
        tdir.set(this.viewRight.getX(), this.viewRight.getY(), this.viewRight.getZ());
        tdir.scale(width);
        Point3f mup = new Point3f(tup);
        mup.scale(-0.5f);
        Point3f mdir = new Point3f(tdir);
        mdir.scale(-0.5f);
        mup.add(mdir);
        Point3f topleftT = new Point3f();
        Point3f bottomleftT = new Point3f();
        Point3f bottomrightT = new Point3f();
        topleftT.setX(tup.getX() - tdir.getX() - mup.getX());
        topleftT.setY(tup.getY() - tdir.getY() - mup.getY());
        topleftT.setZ(tup.getZ() - tdir.getZ() - mup.getZ());
        bottomleftT.setX(-tup.getX() - tdir.getX() - mup.getX());
        bottomleftT.setY(-tup.getY() - tdir.getY() - mup.getY());
        bottomleftT.setZ(-tup.getZ() - tdir.getZ() - mup.getZ());
        bottomrightT.setX(-tup.getX() + tdir.getX() - mup.getX());
        bottomrightT.setY(-tup.getY() + tdir.getY() - mup.getY());
        bottomrightT.setZ(-tup.getZ() + tdir.getZ() - mup.getZ());
        bottomrightT.scale(tsize);
        bottomleftT.scale(tsize);
        topleftT.scale(tsize);
        carray[0] = bottomleftT.getX() + position.getX();
        carray[1] = bottomleftT.getY() + position.getY();
        carray[2] = bottomleftT.getZ() + position.getZ();
        carray[3] = bottomrightT.getX() + position.getX();
        carray[4] = bottomrightT.getY() + position.getY();
        carray[5] = bottomrightT.getZ() + position.getZ();
        carray[6] = topleftT.getX() + position.getX();
        carray[7] = topleftT.getY() + position.getY();
        carray[8] = topleftT.getZ() + position.getZ();
    }

    protected void buildAbsoluteOrientedTriangles(float[] carray, Particle particle) {
        this.correctedVAngle = particle.angleV - 1.5707964f;
        this.particleUp.setX(FastMath.cos(particle.angleH) * FastMath.sin(this.correctedVAngle));
        this.particleUp.setZ(FastMath.sin(particle.angleH) * FastMath.sin(this.correctedVAngle));
        this.particleUp.setY(FastMath.cos(this.correctedVAngle));
        this.particleRight.setX(FastMath.cos(particle.angleH) * FastMath.sin(particle.angleV));
        this.particleRight.setZ(FastMath.sin(particle.angleH) * FastMath.sin(particle.angleV));
        this.particleRight.setY(FastMath.cos(particle.angleV));
        Vector3f side = new Vector3f();
        side.cross(this.particleRight, this.particleUp);
        Vector3f position = new Vector3f(particle.position);
        this.getWorldTransform().getMatrix4f().transform(position);
        float tsize = particle.size * 2.0f;
        float width = particle.width * 0.25f;
        float height = particle.height * 0.25f;
        Point3f tup = new Point3f();
        tup.set((TupleNf)this.particleUp);
        tup.scale(height);
        Point3f tdir = new Point3f();
        tdir.set((TupleNf)side);
        tdir.scale(width);
        Point3f mup = new Point3f(tup);
        mup.scale(-0.5f);
        Point3f mdir = new Point3f(tdir);
        mdir.scale(-0.5f);
        mup.add(mdir);
        Point3f topLeftT = new Point3f();
        Point3f bottomLeftT = new Point3f();
        Point3f bottomRightT = new Point3f();
        topLeftT.setX(tup.getX() - tdir.getX() - mup.getX());
        topLeftT.setY(tup.getY() - tdir.getY() - mup.getY());
        topLeftT.setZ(tup.getZ() - tdir.getZ() - mup.getZ());
        bottomLeftT.setX(-tup.getX() - tdir.getX() - mup.getX());
        bottomLeftT.setY(-tup.getY() - tdir.getY() - mup.getY());
        bottomLeftT.setZ(-tup.getZ() - tdir.getZ() - mup.getZ());
        bottomRightT.setX(-tup.getX() + tdir.getX() - mup.getX());
        bottomRightT.setY(-tup.getY() + tdir.getY() - mup.getY());
        bottomRightT.setZ(-tup.getZ() + tdir.getZ() - mup.getZ());
        bottomRightT.scale(tsize);
        bottomLeftT.scale(tsize);
        topLeftT.scale(tsize);
        if (particle.rotation != null) {
            particle.rotation.transform(bottomRightT);
            particle.rotation.transform(bottomLeftT);
            particle.rotation.transform(topLeftT);
        }
        if (this.relativeOrientation) {
            this.getWorldTransform().getMatrix4f().transform(bottomRightT);
            this.getWorldTransform().getMatrix4f().transform(bottomLeftT);
            this.getWorldTransform().getMatrix4f().transform(topLeftT);
        }
        carray[0] = bottomLeftT.getX() + position.getX();
        carray[1] = bottomLeftT.getY() + position.getY();
        carray[2] = bottomLeftT.getZ() + position.getZ();
        carray[3] = bottomRightT.getX() + position.getX();
        carray[4] = bottomRightT.getY() + position.getY();
        carray[5] = bottomRightT.getZ() + position.getZ();
        carray[6] = topLeftT.getX() + position.getX();
        carray[7] = topLeftT.getY() + position.getY();
        carray[8] = topLeftT.getZ() + position.getZ();
    }

    private void buildTriangles(float[] carray, Particle particle) {
        if (this.generator.isAbsoluteParticleAngle()) {
            this.buildAbsoluteOrientedTriangles(carray, particle);
        } else {
            this.buildFacingCameraTriangles(carray, particle);
        }
    }

    public void update(Vector3f up, Vector3f right) {
        this.viewUp.set((TupleNf)up);
        this.viewRight.set((TupleNf)right);
    }

    protected void update() {
        ++this.count;
        List<Particle> particles = this.generator.getParticles();
        Particle particle = null;
        int aliveParticles = 0;
        int tempVertexCount = 0;
        if (GeneratorShape3D.isWireFrameEnabled()) {
            for (int i = 0; i < particles.size(); ++i) {
                particle = particles.get(i);
                if (particle.life <= 0.0f) continue;
                tempVertexCount = aliveParticles * 3;
                this.index[tempVertexCount + 0] = tempVertexCount + 0;
                this.index[tempVertexCount + 1] = tempVertexCount + 1;
                this.index[tempVertexCount + 2] = tempVertexCount + 2;
                this.buildTriangles(this.coordsBuffer, particle);
                this.setColor(i * 3, particle.color, particle.alpha);
                this.getGeometry().setCoordinates(i * 3, this.coordsBuffer);
                ++aliveParticles;
            }
        } else {
            for (int i = 0; i < particles.size(); ++i) {
                particle = particles.get(i);
                if (particle.life <= 0.0f) continue;
                tempVertexCount = aliveParticles * 3;
                this.index[tempVertexCount + 0] = tempVertexCount + 0;
                this.index[tempVertexCount + 1] = tempVertexCount + 1;
                this.index[tempVertexCount + 2] = tempVertexCount + 2;
                this.buildTriangles(this.coordsBuffer, particle);
                this.setColor(i * 3, particle.color, particle.alpha);
                this.getGeometry().setCoordinates(i * 3, this.coordsBuffer);
                this.setTexture(i * 3, particle);
                ++aliveParticles;
            }
        }
        this.getGeometry().setIndex(this.index);
        this.getGeometry().setInitialIndexIndex(0);
        this.getGeometry().setValidIndexCount(tempVertexCount);
    }

    public void updateFaceToCamera(Matrix3f viewRotation, long frameId, long nanoTime, long nanoStep) {
        this.update();
    }

    protected BlendFunction getBlendFactor(int glBlendFactorInteger) {
        switch (glBlendFactorInteger) {
            case 0: {
                return BlendFunction.ZERO;
            }
            case 1: {
                return BlendFunction.ONE;
            }
            case 772: {
                return BlendFunction.DST_ALPHA;
            }
            case 774: {
                return BlendFunction.DST_COLOR;
            }
            case 770: {
                return BlendFunction.SRC_ALPHA;
            }
            case 768: {
                return BlendFunction.SRC_COLOR;
            }
            case 773: {
                return BlendFunction.ONE_MINUS_DST_ALPHA;
            }
            case 775: {
                return BlendFunction.ONE_MINUS_DST_COLOR;
            }
            case 771: {
                return BlendFunction.ONE_MINUS_SRC_ALPHA;
            }
            case 769: {
                return BlendFunction.ONE_MINUS_SRC_COLOR;
            }
            case 776: {
                return BlendFunction.SRC_ALPHA_SATURATE;
            }
        }
        throw new RuntimeException("GL blend mode not recognized : " + glBlendFactorInteger);
    }

    private void setup() {
        if (this.generator.getGb() == null || this.generator.getRender() == null) {
            return;
        }
        GeneratorBehaviour gb = this.generator.getGb();
        int maxParticles = gb.getNumber();
        IndexedTriangleArray geom = new IndexedTriangleArray(maxParticles * 3 + 0, maxParticles * 3 + 0);
        geom.setOptimization(Geometry.Optimization.NONE);
        this.setGeometry(geom);
        this.index = new int[gb.getNumber() * 3];
        geom.setIndex(this.index);
        Texture2D texture = TextureLoader.getInstance().getTexture(this.generator.getRender().getTextureName(), Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        texture.setBoundaryModeS(TextureBoundaryMode.CLAMP_TO_BORDER);
        texture.setBoundaryModeT(TextureBoundaryMode.CLAMP_TO_BORDER);
        TransparencyAttributes transparencyAttribs = new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.1f, this.getBlendFactor(this.generator.getRender().getSourceFactor()), this.getBlendFactor(this.generator.getRender().getDestinationFactor()));
        transparencyAttribs.setEnabled(true);
        transparencyAttribs.setSortEnabled(true);
        Appearance app = new Appearance();
        if (WIRE_FRAME) {
            PolygonAttributes pa = new PolygonAttributes(DrawMode.LINE);
            app.setPolygonAttributes(pa);
        } else {
            app.setTexture(texture);
            app.setTextureAttributes(texAttribs);
            app.setRenderingAttributes(renderingAttribs);
            app.setTransparencyAttributes(transparencyAttribs);
        }
        this.setAppearance(app);
    }

    public Sized2iRO getSizeOnScreen() {
        return null;
    }

    public void dispose() {
        this.generator = null;
    }

    public boolean isAbsoluteOrientation() {
        return this.relativeOrientation;
    }

    public void setAbsoluteOrientation(boolean absoluteOrientation) {
        this.relativeOrientation = absoluteOrientation;
    }

    public GeneratorShape3D(boolean relativeOrientation) {
        this.relativeOrientation = relativeOrientation;
    }

    public GeneratorShape3D(boolean relativeOrientation, Generator generator) {
        this.setGenerator(generator);
        this.relativeOrientation = relativeOrientation;
    }

    static {
        texAttribs.setCombineAlphaMode(TextureCombineMode.REPLACE);
        renderingAttribs = new RenderingAttributes(true, false, 0.001f, TestFunction.GREATER);
    }
}

