/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.Box;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;

public class Cube
extends Box {
    public static GeometryConstruct createGeometryConstructTA(float offsetX, float offsetY, float offsetZ, float size, int features, boolean colorAlpha, int texCoordsSize) {
        return Box.createGeometryConstructTA(offsetX, offsetY, offsetZ, size, size, size, features, colorAlpha, texCoordsSize);
    }

    public static GeometryConstruct createGeometryConstructTA(float size, int features, boolean colorAlpha, int texCoordsSize) {
        return Cube.createGeometryConstructTA(0.0f, 0.0f, 0.0f, size, features, colorAlpha, texCoordsSize);
    }

    public static TriangleArray createGeometryTA(float offsetX, float offsetY, float offsetZ, float size, int features, boolean colorAlpha, int texCoordsSize) {
        return Box.createGeometryTA(offsetX, offsetY, offsetZ, size, size, size, features, colorAlpha, texCoordsSize);
    }

    public static TriangleArray createGeometryTA(float size, int features, boolean colorAlpha, int texCoordsSize) {
        return Cube.createGeometryTA(0.0f, 0.0f, 0.0f, size, features, colorAlpha, texCoordsSize);
    }

    public Cube(float size, int features, boolean colorAlpha, int texCoordsSize) {
        super(size, size, size, features, colorAlpha, texCoordsSize);
    }

    public Cube(float size) {
        this(size, 11, false, 2);
    }

    public Cube(float size, Texture texture) {
        this(size, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cube(Texture texture) {
        this(1.0f, texture);
    }

    public Cube(float size, String texture) {
        this(size, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP));
    }

    public Cube(String texture) {
        this(TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP));
    }

    public Cube(float size, Colorf color) {
        this(size, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cube(Colorf color) {
        this(1.0f, color);
    }

    public Cube(float size, Appearance app) {
        this(size, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Cube(Appearance app) {
        this(1.0f, app);
    }
}

