/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.Disk;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class Cylinder
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.TRIANGLE_ARRAY;
    private static final int TEX_FEATURES = 11;
    private static final int COLOR_FEATURES = 1;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: 
            case INDEXED_TRIANGLE_ARRAY: 
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Cylinder.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    public static GeometryConstruct createGeometryConstructITSA(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        int[] stripLengths;
        if (closed) {
            System.err.println("A closed Cylinder is currently not supported for non TriangleArray geometry");
        }
        closed = false;
        Tuple3f[] vertices = null;
        int[] indices = null;
        int v0 = 0;
        int i0 = 0;
        if (closed) {
            v0 = 2;
            vertices = new Point3f[slices * 2 + 2 + v0];
            vertices[0] = new Point3f(0.0f, -0.5f, 0.0f);
            vertices[1] = new Point3f(0.0f, 0.5f, 0.0f);
            i0 = (int)FastMath.floor((float)slices / 3.0f) * 5;
            if (slices % 3 == 1) {
                i0 += 3;
            } else if (slices % 3 == 2) {
                i0 += 4;
            }
            indices = new int[slices * 2 + 2 + i0];
        } else {
            vertices = new Point3f[slices * 2 + 2];
            indices = new int[slices * 2 + 2];
        }
        Vector3f[] normals = null;
        TexCoord2f[] texCoords = null;
        if ((features & 2) > 0) {
            normals = new Vector3f[vertices.length];
        }
        if ((features & 8) != 0 && texCoordsSize == 2) {
            texCoords = new TexCoord2f[vertices.length];
        }
        float r0 = 1.0f * radius;
        float r1 = taper * radius;
        float halfHeight = height / 2.0f;
        for (int i = 0; i < slices + 1; ++i) {
            float a = (float)i * ((float)Math.PI * 2) / (float)slices;
            vertices[v0 + i * 2 + 0] = new Point3f(FastMath.cos(a) * r0, -halfHeight, FastMath.sin(a) * r0);
            vertices[v0 + i * 2 + 1] = new Point3f(FastMath.cos(a) * r1, halfHeight, FastMath.sin(a) * r1);
            if (normals != null) {
                normals[v0 + i * 2 + 0] = new Vector3f(FastMath.cos(a), 0.0f, FastMath.sin(a));
                normals[v0 + i * 2 + 1] = new Vector3f(FastMath.cos(a), 0.0f, FastMath.sin(a));
            }
            if (texCoords != null) {
                texCoords[v0 + i * 2 + 0] = new TexCoord2f((float)i / (float)slices, 0.0f);
                texCoords[v0 + i * 2 + 1] = new TexCoord2f((float)i / (float)slices, 1.0f);
            }
            indices[i0 + i * 2 + 0] = i * 2 + 0;
            indices[i0 + i * 2 + 1] = i * 2 + 1;
        }
        if (closed) {
            stripLengths = new int[2];
        } else {
            stripLengths = new int[2];
            for (int i = 0; i < stripLengths.length; ++i) {
                stripLengths[i] = slices + 1;
            }
        }
        return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY, vertices, normals, texCoords, indices, stripLengths);
    }

    public static IndexedTriangleStripArray createGeometryITSA(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gc = Cylinder.createGeometryConstructITSA(radius, height, taper, closed, slices, features, colorAlpha, texCoordsSize);
        return GeomFactory.createIndexedTriangleStripArray(gc);
    }

    public static GeometryConstruct createGeometryConstructITA(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        Tuple3f[] vertices = new Point3f[slices * 2];
        int[] indices = new int[slices * 2 * 3];
        Vector3f[] normals = null;
        TexCoord2f[] texCoords = null;
        if ((features & 2) > 0) {
            normals = new Vector3f[slices * 2];
        }
        if ((features & 8) != 0 && texCoordsSize == 2) {
            texCoords = new TexCoord2f[slices * 2];
        }
        float r0 = 1.0f * radius;
        float r1 = taper * radius;
        float halfHeight = height / 2.0f;
        for (int i = 0; i < slices; ++i) {
            float a = (float)i * ((float)Math.PI * 2) / (float)slices;
            vertices[i * 2 + 0] = new Point3f(FastMath.cos(a) * r0, -halfHeight, -FastMath.sin(a) * r0);
            vertices[i * 2 + 1] = new Point3f(FastMath.cos(a) * r1, halfHeight, -FastMath.sin(a) * r1);
            if (normals != null) {
                normals[i * 2 + 0] = new Vector3f(FastMath.cos(a), 0.0f, -FastMath.sin(a));
                normals[i * 2 + 1] = new Vector3f(FastMath.cos(a), 0.0f, -FastMath.sin(a));
            }
            if (texCoords != null) {
                texCoords[i * 2 + 0] = new TexCoord2f((float)i / (float)slices, 0.0f);
                texCoords[i * 2 + 1] = new TexCoord2f((float)i / (float)slices, 1.0f);
            }
            indices[i * 2 * 3 + 0] = (i * 2 + 3) % (slices * 2);
            indices[i * 2 * 3 + 1] = (i * 2 + 1) % (slices * 2);
            indices[i * 2 * 3 + 2] = (i * 2 + 2) % (slices * 2);
            indices[i * 2 * 3 + 3] = (i * 2 + 1) % (slices * 2);
            indices[i * 2 * 3 + 4] = (i * 2 + 0) % (slices * 2);
            indices[i * 2 * 3 + 5] = (i * 2 + 2) % (slices * 2);
        }
        return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_ARRAY, vertices, normals, texCoords, indices, null);
    }

    public static IndexedTriangleArray createGeometryITA(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gc = Cylinder.createGeometryConstructITA(radius, height, taper, closed, slices, features, colorAlpha, texCoordsSize);
        return GeomFactory.createIndexedTriangleArray(gc);
    }

    public static GeometryConstruct createGeometryConstructTA(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        TexCoord2f texBottom;
        TexCoord2f texTop;
        TexCoord2f[] texture;
        Vector3f[] normals;
        Tuple3f[] vertices;
        float rBottom;
        float rTop;
        if (slices < 3) {
            throw new IllegalArgumentException("slices < 3");
        }
        if ((taper = Math.abs(taper)) <= 1.0f) {
            rTop = taper * radius;
            rBottom = radius;
        } else {
            rTop = radius;
            rBottom = radius / taper;
        }
        int vtOff = 0;
        int noOff = 0;
        int txOff = 0;
        int numVerticesBody = 6 * slices;
        float texBase = height;
        if (closed) {
            float i3;
            int i;
            int i2;
            texBase = radius + height + radius;
            GeometryConstruct gcTop = Disk.createGeometryConstructTA(radius, slices, features, colorAlpha, texCoordsSize);
            GeometryConstruct gcBottom = Disk.createGeometryConstructTA(radius, slices, features, colorAlpha, texCoordsSize);
            StaticTransform.rotateX(gcTop.getCoordinates(), -1.5707964f);
            StaticTransform.rotateX(gcBottom.getCoordinates(), 1.5707964f);
            if (gcTop.getNormals() != null) {
                StaticTransform.rotateX(gcTop.getNormals(), -1.5707964f);
            }
            if (gcBottom.getNormals() != null) {
                StaticTransform.rotateX(gcBottom.getNormals(), 1.5707964f);
            }
            StaticTransform.translate(gcTop.getCoordinates(), 0.0f, height / 2.0f, 0.0f);
            StaticTransform.translate(gcBottom.getCoordinates(), 0.0f, -(height / 2.0f), 0.0f);
            vtOff = gcTop.numVertices();
            noOff = gcTop.numNormals();
            txOff = gcTop.numTextureCoordinates2f();
            int vtOff2 = vtOff + numVerticesBody;
            int noOff2 = noOff + numVerticesBody;
            int txOff2 = txOff + numVerticesBody;
            vertices = new Tuple3f[vtOff + numVerticesBody + gcBottom.numVertices()];
            normals = new Vector3f[noOff + numVerticesBody + gcBottom.numNormals()];
            texture = new TexCoord2f[txOff + numVerticesBody + gcBottom.numTextureCoordinates2f()];
            int j = 0;
            for (i2 = 0; i2 < gcTop.numVertices(); ++i2) {
                vertices[j++] = gcTop.getCoordinates()[i2];
            }
            j = vtOff2;
            for (i2 = 0; i2 < gcBottom.numVertices(); ++i2) {
                vertices[j++] = gcBottom.getCoordinates()[i2];
            }
            j = 0;
            for (i2 = 0; i2 < gcTop.numNormals(); ++i2) {
                normals[j++] = gcTop.getNormals()[i2];
            }
            j = noOff2;
            for (i2 = 0; i2 < gcBottom.numNormals(); ++i2) {
                normals[j++] = gcBottom.getNormals()[i2];
            }
            float texShift = (radius + height) / texBase;
            j = 0;
            int n = gcTop.numTextureCoordinates2f();
            for (i = 0; i < n; ++i) {
                texture[j] = gcTop.getTextureCoordinates2f()[i];
                i3 = i / 3;
                switch (i % 3) {
                    case 0: {
                        texture[j].set((i3 + 0.0f) / (float)slices, texShift);
                        break;
                    }
                    case 1: {
                        texture[j].set((i3 + 0.0f) / (float)slices, 1.0f);
                        break;
                    }
                    case 2: {
                        texture[j].set((i3 + 1.0f) / (float)slices, texShift);
                    }
                }
                ++j;
            }
            texShift = radius / texBase;
            j = txOff2;
            n = gcBottom.numTextureCoordinates2f();
            for (i = 0; i < n; ++i) {
                texture[j] = gcBottom.getTextureCoordinates2f()[i];
                i3 = i / 3;
                switch (i % 3) {
                    case 0: {
                        texture[j].set((i3 + 0.0f) / (float)slices, texShift);
                        break;
                    }
                    case 1: {
                        texture[j].set((i3 + 0.0f) / (float)slices, 0.0f);
                        break;
                    }
                    case 2: {
                        texture[j].set((i3 + 1.0f) / (float)slices, texShift);
                    }
                }
                ++j;
            }
        } else {
            vertices = new Tuple3f[numVerticesBody];
            normals = new Vector3f[numVerticesBody];
            texture = new TexCoord2f[numVerticesBody];
        }
        Point3f top = new Point3f(rTop, height / 2.0f, 0.0f);
        Point3f bottom = new Point3f(rBottom, -(height / 2.0f), 0.0f);
        if (closed) {
            texTop = new TexCoord2f(0.0f, (radius + height) / texBase);
            texBottom = new TexCoord2f(0.0f, radius / texBase);
        } else {
            texTop = new TexCoord2f(0.0f, 1.0f);
            texBottom = new TexCoord2f(0.0f, 0.0f);
        }
        Vector3f normal = new Vector3f(1.0f, 0.0f, 0.0f);
        int index = 0;
        for (int i = 0; i < slices; ++i) {
            normal.setX(FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / (float)slices));
            normal.setZ(-FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / (float)slices));
            normal.normalize();
            vertices[vtOff + index] = new Point3f(top);
            normals[noOff + index] = new Vector3f(normal);
            texture[txOff + index++] = new TexCoord2f(texTop);
            vertices[vtOff + index] = new Point3f(bottom);
            normals[noOff + index] = new Vector3f(normal);
            texture[txOff + index++] = new TexCoord2f(texBottom);
            top.setX(rTop * FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / (float)slices));
            top.setZ(rTop * -FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / (float)slices));
            texTop.setS(((float)i + 1.0f) / (float)slices);
            vertices[vtOff + index] = new Point3f(top);
            normals[noOff + index] = new Vector3f(normal);
            texture[txOff + index++] = new TexCoord2f(texTop);
            vertices[vtOff + index] = new Point3f(top);
            normals[noOff + index] = new Vector3f(normal);
            texture[txOff + index++] = new TexCoord2f(texTop);
            vertices[vtOff + index] = new Point3f(bottom);
            normals[noOff + index] = new Vector3f(normal);
            texture[txOff + index++] = new TexCoord2f(texBottom);
            bottom.setX(rBottom * FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / (float)slices));
            bottom.setZ(rBottom * -FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / (float)slices));
            texBottom.setS(((float)i + 1.0f) / (float)slices);
            vertices[vtOff + index] = new Point3f(bottom);
            normals[noOff + index] = new Vector3f(normal);
            texture[txOff + index++] = new TexCoord2f(texBottom);
        }
        if ((features & 2) == 0) {
            normals = null;
        }
        if ((features & 8) == 0) {
            texture = null;
        }
        return new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, vertices, normals, texture);
    }

    public static TriangleArray createGeometryTA(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gc = Cylinder.createGeometryConstructTA(radius, height, taper, closed, slices, features, colorAlpha, texCoordsSize);
        return GeomFactory.createTriangleArray(gc);
    }

    public static Geometry createGeometry(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Cylinder.getGeometryConstructionTypeHint()) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: {
                return Cylinder.createGeometryITSA(radius, height, taper, closed, slices, features, colorAlpha, texCoordsSize);
            }
            case INDEXED_TRIANGLE_ARRAY: {
                return Cylinder.createGeometryITA(radius, height, taper, closed, slices, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_ARRAY: {
                return Cylinder.createGeometryTA(radius, height, taper, closed, slices, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Cylinder.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    private Cylinder(Geometry geom) {
        super(geom);
    }

    public Cylinder(float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(Cylinder.createGeometry(1.0f, 1.0f, taper, closed, slices, features, colorAlpha, texCoordsSize));
    }

    public Cylinder(float taper, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(taper, false, slices, features, colorAlpha, texCoordsSize);
    }

    public Cylinder(float size, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(Cylinder.createGeometry(size, size, taper, closed, slices, features, colorAlpha, texCoordsSize));
    }

    public Cylinder(float size, float taper, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(size, taper, false, slices, features, colorAlpha, texCoordsSize);
    }

    public Cylinder(float radius, float height, float taper, boolean closed, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(Cylinder.createGeometry(radius, height, taper, closed, slices, features, colorAlpha, texCoordsSize));
    }

    public Cylinder(float radius, float height, float taper, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(radius, height, taper, false, slices, features, colorAlpha, texCoordsSize);
    }

    public Cylinder(float taper, boolean closed, int slices, Texture texture) {
        this(taper, closed, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cylinder(float taper, int slices, Texture texture) {
        this(taper, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cylinder(float size, float taper, boolean closed, int slices, Texture texture) {
        this(size, taper, closed, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cylinder(float size, float taper, int slices, Texture texture) {
        this(size, taper, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cylinder(float radius, float height, float taper, boolean closed, int slices, Texture texture) {
        this(radius, height, taper, closed, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cylinder(float radius, float height, float taper, int slices, Texture texture) {
        this(radius, height, taper, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Cylinder(float taper, boolean closed, int slices, String texture) {
        this(taper, closed, slices, (Texture)TextureLoader.getInstance().getTexture(texture));
    }

    public Cylinder(float taper, int slices, String texture) {
        this(taper, slices, TextureLoader.getInstance().getTexture(texture));
    }

    public Cylinder(float size, float taper, boolean closed, int slices, String texture) {
        this(size, taper, closed, slices, (Texture)TextureLoader.getInstance().getTexture(texture));
    }

    public Cylinder(float size, float taper, int slices, String texture) {
        this(size, taper, slices, (Texture)TextureLoader.getInstance().getTexture(texture));
    }

    public Cylinder(float size, float height, float taper, boolean closed, int slices, String texture) {
        this(size, height, taper, closed, slices, TextureLoader.getInstance().getTexture(texture));
    }

    public Cylinder(float radius, float height, float taper, int slices, String texture) {
        this(radius, height, taper, slices, (Texture)TextureLoader.getInstance().getTexture(texture));
    }

    public Cylinder(float taper, boolean closed, int slices, Colorf color) {
        this(taper, closed, slices, 1, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cylinder(float taper, int slices, Colorf color) {
        this(taper, slices, 1, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cylinder(float size, float taper, boolean closed, int slices, Colorf color) {
        this(size, taper, closed, slices, 1, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cylinder(float size, float taper, int slices, Colorf color) {
        this(size, taper, slices, 1, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cylinder(float radius, float height, float taper, boolean closed, int slices, Colorf color) {
        this(radius, height, taper, closed, slices, 1, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cylinder(float taper, int slices, float radius, float height, Colorf color) {
        this(radius, height, taper, slices, 1, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Cylinder(float taper, boolean closed, int slices, Appearance app) {
        this(taper, closed, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Cylinder(float taper, int slices, Appearance app) {
        this(taper, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Cylinder(float size, float taper, boolean closed, int slices, Appearance app) {
        this(size, taper, closed, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Cylinder(float size, float taper, int slices, Appearance app) {
        this(size, taper, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Cylinder(float radius, float height, float taper, boolean closed, int slices, Appearance app) {
        this(radius, height, taper, closed, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Cylinder(float radius, float height, float taper, int slices, Appearance app) {
        this(radius, height, taper, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }
}

