/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.Cone;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class Disk
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.TRIANGLE_ARRAY;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Disk.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    public static GeometryConstruct createGeometryConstructTA(float radius, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gc = Cone.createGeometryConstructTA(radius, 0.0f, slices, features, colorAlpha, texCoordsSize);
        StaticTransform.rotateX(gc.getCoordinates(), 1.5707964f);
        if (gc.numNormals() > 0) {
            for (int i = 0; i < gc.numNormals(); ++i) {
                gc.getNormals()[i].set(0.0f, 0.0f, 1.0f);
            }
        }
        return gc;
    }

    public static TriangleArray createGeometryTA(float radius, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gc = Disk.createGeometryConstructTA(radius, slices, features, colorAlpha, texCoordsSize);
        return GeomFactory.createTriangleArray(gc);
    }

    public static Geometry createGeometry(float radius, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Disk.getGeometryConstructionTypeHint()) {
            case TRIANGLE_ARRAY: {
                return Disk.createGeometryTA(radius, slices, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Disk.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public Disk(float radius, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        super(Disk.createGeometry(radius, slices, features, colorAlpha, texCoordsSize));
    }

    public Disk(int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(1.0f, slices, features, colorAlpha, texCoordsSize);
    }

    public Disk(float radius, int slices, Texture texture) {
        this(radius, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Disk(int slices, Texture texture) {
        this(slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Disk(float radius, int slices, String texture) {
        this(radius, slices, TextureLoader.getInstance().getTexture(texture));
    }

    public Disk(int slices, String texture) {
        this(slices, TextureLoader.getInstance().getTexture(texture));
    }

    public Disk(float radius, int slices, Colorf color) {
        this(radius, slices, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Disk(int slices, Colorf color) {
        this(1.0f, slices, color);
    }

    public Disk(float radius, int slices, Appearance app) {
        this(radius, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Disk(int slices, Appearance app) {
        this(1.0f, slices, app);
    }
}

